/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress.automation.areas;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaInfo;
import net.remmintan.mods.minefortress.core.interfaces.automation.ProfessionsSelectionType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionModelBuilderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IAreasClientManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ISavedAreasHolder;
import net.remmintan.mods.minefortress.networking.c2s.C2SAddAreaPacket;
import net.remmintan.mods.minefortress.networking.c2s.C2SRemoveAutomationAreaPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.joml.Vector4f;
import org.minefortress.fortress.automation.areas.AutomationAreaInfo;
import org.minefortress.fortress.automation.areas.SavedAreasHolder;
import org.minefortress.utils.ModUtils;

public final class AreasClientManager
implements ISelectionInfoProvider,
ISelectionModelBuilderInfoProvider,
IAreasClientManager {
    private final SavedAreasHolder savedAreasHolder = new SavedAreasHolder();
    private boolean needsUpdate;
    private ProfessionsSelectionType selectionType;
    private class_2338 selectionStart;
    private class_2338 selectionEnd;
    private IAutomationAreaInfo hoveredArea;
    private boolean isCorrectState = true;

    @Override
    public boolean select(class_239 target) {
        if (target == null) {
            return false;
        }
        if (target instanceof class_3965) {
            class_3965 bhr = (class_3965)target;
            if (this.selectionType == null) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Please select an area type first!"));
                return false;
            }
            class_2338 blockPos = bhr.method_17777();
            if (this.selectionStart == null) {
                this.needsUpdate = true;
                this.selectionStart = blockPos.method_10062();
                this.selectionEnd = blockPos.method_10062();
            } else {
                if (this.isCorrectState) {
                    List<class_2338> selectedBlocks = Collections.unmodifiableList(this.getSelectedBlocks());
                    AutomationAreaInfo info = new AutomationAreaInfo(selectedBlocks, this.selectionType, UUID.randomUUID());
                    C2SAddAreaPacket packet = new C2SAddAreaPacket(info);
                    FortressClientNetworkHelper.send("add_area", packet);
                } else {
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"The selected area is not inside the fortress!"));
                }
                this.resetSelection();
            }
        }
        return true;
    }

    @Override
    public void updateSelection(class_239 crosshairTarget) {
        if (crosshairTarget instanceof class_3965) {
            class_3965 bhr = (class_3965)crosshairTarget;
            class_2338 blockPos = bhr.method_17777();
            if (blockPos == null) {
                return;
            }
            this.hoveredArea = this.getSavedAreasHolder().getHovered(blockPos).orElse(null);
            class_2338 possibleEnd = blockPos.method_10062();
            if (this.selectionStart != null && possibleEnd != null && !possibleEnd.equals((Object)this.selectionEnd)) {
                this.selectionEnd = possibleEnd;
                this.needsUpdate = true;
            }
            this.isCorrectState = ModUtils.getInfluenceManager().getFortressBorder().map(it -> this.getSelectedBlocks().stream().allMatch(arg_0 -> ((class_2784)it).method_11952(arg_0))).orElse(true);
        }
    }

    @Override
    public void resetSelection() {
        this.selectionEnd = null;
        this.selectionStart = null;
        this.needsUpdate = true;
        this.hoveredArea = null;
        this.isCorrectState = true;
    }

    @Override
    public void removeHovered() {
        if (this.hoveredArea != null) {
            C2SRemoveAutomationAreaPacket packet = new C2SRemoveAutomationAreaPacket(this.hoveredArea.getId());
            FortressClientNetworkHelper.send("c2s_remove_area", packet);
        }
    }

    @Override
    public boolean isSelecting() {
        return this.selectionStart != null;
    }

    @Override
    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    @Override
    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    @Override
    public List<class_2338> getSelectedBlocks() {
        if (this.selectionStart == null || this.selectionEnd == null) {
            return List.of();
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return List.of();
        }
        return Streams.stream((Iterable)class_2338.method_10097((class_2338)this.selectionStart.method_33096(-64), (class_2338)this.selectionEnd.method_33096(320))).map(class_2338::method_10062).filter(it -> BuildingHelper.canRemoveBlock((class_1937)world, it) && BuildingHelper.canPlaceBlock((class_1937)world, it.method_10084())).toList();
    }

    @Override
    public ProfessionsSelectionType getSelectionType() {
        return this.selectionType;
    }

    @Override
    public void setSelectionType(ProfessionsSelectionType selectionType) {
        this.selectionType = selectionType;
    }

    @Override
    public Vector4f getClickColor() {
        if (!this.isCorrectState) {
            return new Vector4f(0.6666667f, 0.0f, 0.0f, 0.5f);
        }
        return this.selectionType.getColor();
    }

    @Override
    public List<Pair<class_2382, class_2382>> getSelectionDimensions() {
        return Collections.emptyList();
    }

    @Override
    public ISavedAreasHolder getSavedAreasHolder() {
        return this.savedAreasHolder;
    }

    @Override
    public Optional<String> getHoveredAreaName() {
        return Optional.ofNullable(this.hoveredArea).map(IAutomationAreaInfo::getAreaType).map(ProfessionsSelectionType::getTitle);
    }
}

