/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.FortressGamemode;
import net.remmintan.mods.minefortress.core.ScreenType;
import net.remmintan.mods.minefortress.core.interfaces.IFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaProvider;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationArea;
import net.remmintan.mods.minefortress.core.interfaces.automation.server.IServerAutomationAreaManager;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.buildings.IServerBuildingsManager;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IFortressBuilding;
import net.remmintan.mods.minefortress.core.interfaces.entities.IPawnNameGenerator;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IProfessional;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IServerInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.IServerProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IServerTaskManager;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundSyncFortressManagerPacket;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundSyncSpecialBlocksPacket;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.colonist.ColonistNameGenerator;
import org.minefortress.fight.influence.ServerInfluenceManager;
import org.minefortress.fortress.automation.areas.AreasServerManager;
import org.minefortress.fortress.buildings.FortressBuildingManager;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.fortress.resources.gui.craft.FortressCraftingScreenHandlerFactory;
import org.minefortress.fortress.resources.gui.smelt.FurnaceScreenHandlerFactory;
import org.minefortress.fortress.resources.server.ServerResourceManager;
import org.minefortress.professions.ServerProfessionManager;
import org.minefortress.registries.FortressEntities;
import org.minefortress.tasks.RepairBuildingTask;
import org.minefortress.tasks.ServerTaskManager;
import org.minefortress.utils.BlockInfoUtils;

public final class ServerFortressManager
implements IFortressManager,
IServerManagersProvider,
IServerFortressManager {
    private static final class_2680 DEFAULT_STATE_ABOVE_CAMPFIRE = class_2246.field_10499.method_9564();
    private static final int DEFAULT_COLONIST_COUNT = 5;
    public static final class_2680 CAMPFIRE_DEFAULT_STATE = class_2246.field_17350.method_9564();
    private final MinecraftServer server;
    private final Set<class_1309> pawns = new HashSet<class_1309>();
    private final Map<class_2248, List<class_2338>> specialBlocks = new HashMap<class_2248, List<class_2338>>();
    private final Map<class_2248, List<class_2338>> blueprintsSpecialBlocks = new HashMap<class_2248, List<class_2338>>();
    private final IServerProfessionsManager professionManager;
    private final IServerResourceManager resourceManager;
    private final IServerBuildingsManager fortressBuildingManager;
    private final IServerTaskManager taskManager = new ServerTaskManager();
    private final IServerAutomationAreaManager automationAreaManager = new AreasServerManager();
    private final IServerInfluenceManager influenceManager = new ServerInfluenceManager(this);
    private IPawnNameGenerator nameGenerator = new ColonistNameGenerator();
    private int maxX = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;
    private int minX = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private FortressGamemode gamemode = FortressGamemode.NONE;
    private boolean needSync = true;
    private boolean needSyncSpecialBlocks = true;
    private class_2338 fortressCenter = null;
    private int maxColonistsCount = -1;
    private boolean campfireEnabled;
    private boolean borderEnabled;

    public ServerFortressManager(MinecraftServer server) {
        this.server = server;
        this.professionManager = new ServerProfessionManager(() -> this, server);
        this.resourceManager = new ServerResourceManager(server);
        this.fortressBuildingManager = new FortressBuildingManager(() -> server.method_3847(class_1937.field_25179));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            this.gamemode = FortressGamemode.SURVIVAL;
        }
    }

    @Override
    public void addColonist(class_1309 colonist) {
        this.pawns.add(colonist);
        this.scheduleSync();
    }

    @Override
    public IServerTaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public IServerInfluenceManager getInfluenceManager() {
        return this.influenceManager;
    }

    @Override
    public IServerBuildingsManager getBuildingsManager() {
        return this.fortressBuildingManager;
    }

    public void tick(@Nullable class_3222 player) {
        this.taskManager.tick(this, this.getWorld());
        this.tickFortress(player);
        this.professionManager.tick(player);
        this.resourceManager.tick(player);
        this.automationAreaManager.tick(player);
        this.influenceManager.tick(player);
        this.fortressBuildingManager.tick(player);
        if (!this.needSync || player == null) {
            return;
        }
        boolean isServer = FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
        ClientboundSyncFortressManagerPacket syncFortressPacket = new ClientboundSyncFortressManagerPacket(this.pawns.size(), this.fortressCenter, this.gamemode, isServer, this.maxColonistsCount, this.getReservedPawnsCount(), this.campfireEnabled, this.borderEnabled);
        FortressServerNetworkHelper.send(player, "fortress_manager_sync", syncFortressPacket);
        if (this.needSyncSpecialBlocks) {
            ClientboundSyncSpecialBlocksPacket syncBlocks = new ClientboundSyncSpecialBlocksPacket(this.specialBlocks, this.blueprintsSpecialBlocks);
            FortressServerNetworkHelper.send(player, "fortress_blocks_sync", syncBlocks);
            this.needSyncSpecialBlocks = false;
        }
        this.needSync = false;
    }

    @Override
    public void replaceColonistWithTypedPawn(class_1309 colonist, String warriorId, class_1299<? extends class_1309> entityType) {
        class_2338 pos = this.getRandomSpawnPosition();
        class_3218 world = (class_3218)colonist.method_5770();
        UUID masterId = ((Colonist)colonist).getMasterId().orElseThrow(() -> new IllegalStateException("Colonist has no master!"));
        class_2487 infoTag = ServerFortressManager.getColonistInfoTag(masterId);
        infoTag.method_10582("professionId", warriorId);
        class_1309 newWarrior = (class_1309)entityType.method_5899(world, infoTag, it -> {}, pos, class_3730.field_16467, true, false);
        colonist.method_5643(this.getOutOfWorldDamageSource(), Float.MAX_VALUE);
        this.pawns.remove(colonist);
        this.pawns.add(newWarrior);
    }

    public void tickFortress(@Nullable class_3222 player) {
        ItemInfo ii;
        List<class_1309> deadPawns;
        if (this.maxColonistsCount != -1 && this.getTotalColonistsCount() > this.maxColonistsCount) {
            long deltaColonists = Math.max(this.pawns.stream().filter(class_1309::method_5805).count() - (long)this.maxColonistsCount, 0L);
            this.pawns.stream().filter(class_1309::method_5805).limit(deltaColonists).forEach(it -> it.method_5643(this.getOutOfWorldDamageSource(), 40.0f));
        }
        if (!(deadPawns = this.pawns.stream().filter(is -> !is.method_5805()).toList()).isEmpty()) {
            for (class_1309 class_13092 : deadPawns) {
                if (class_13092 instanceof IProfessional) {
                    IProfessional iProfessional = (IProfessional)class_13092;
                    String professionId = iProfessional.getProfessionId();
                    this.professionManager.decreaseAmount(professionId, true);
                }
                this.pawns.remove(class_13092);
            }
            this.scheduleSync();
        }
        if (this.allPawnsAreFree() && (!this.specialBlocks.containsKey(class_2246.field_9980) || this.specialBlocks.get(class_2246.field_9980).isEmpty()) && !this.resourceManager.hasItems(Collections.singletonList(ii = new ItemInfo(class_1802.field_8465, 1)))) {
            this.resourceManager.increaseItemAmount(class_1802.field_8465, 1);
        }
        if (!this.specialBlocks.isEmpty() && !this.blueprintsSpecialBlocks.isEmpty() && this.getWorld() != null && this.getWorld().method_27983() == class_1937.field_25179) {
            List<class_2338> positions;
            class_2248 block;
            boolean needSync = false;
            for (Map.Entry<class_2248, List<class_2338>> entry : new HashSet<Map.Entry<class_2248, List<class_2338>>>(this.specialBlocks.entrySet())) {
                block = entry.getKey();
                positions = entry.getValue();
                boolean bl = needSync = needSync || positions.removeIf(pos -> this.getWorld().method_8320(pos).method_26204() != block);
                if (!positions.isEmpty()) continue;
                this.specialBlocks.remove(block);
            }
            for (Map.Entry<class_2248, List<class_2338>> entry : new HashSet<Map.Entry<class_2248, List<class_2338>>>(this.blueprintsSpecialBlocks.entrySet())) {
                block = entry.getKey();
                positions = entry.getValue();
                boolean bl = needSync = needSync || positions.removeIf(pos -> this.getWorld().method_8320(pos).method_26204() != block);
                if (!positions.isEmpty()) continue;
                this.blueprintsSpecialBlocks.remove(block);
            }
            if (needSync) {
                this.scheduleSyncSpecialBlocks();
            }
        }
        if (this.fortressCenter != null) {
            long l;
            if (this.campfireEnabled) {
                this.setTheCampfireState(player);
            } else {
                this.resetCampfireState(player);
            }
            int colonistsCount = this.pawns.size();
            float f = class_3532.method_37166((float)82.0f, (float)99.0f, (float)((float)colonistsCount / 50.0f));
            if (!(this.maxColonistsCount != -1 && colonistsCount >= this.maxColonistsCount || this.getWorld().method_8510() % 100L != 0L || !((float)this.getWorld().field_9229.method_43048(100) >= f) || (long)colonistsCount >= (l = this.fortressBuildingManager.getTotalBedsCount()) && colonistsCount >= 5 || player == null)) {
                this.spawnPawnNearCampfire(player.method_5667()).ifPresent(it -> player.method_7353((class_2561)class_2561.method_43470((String)(it.method_5477().getString() + " appeared in the village.")), false));
            }
        }
    }

    private void setTheCampfireState(@Nullable class_3222 player) {
        class_2680 blockState = this.getWorld().method_8320(this.fortressCenter);
        if (blockState != CAMPFIRE_DEFAULT_STATE) {
            this.getWorld().method_8652(this.fortressCenter, CAMPFIRE_DEFAULT_STATE, 3);
            if (player != null) {
                this.getWorld().method_33596((class_1297)player, class_5712.field_28164, this.fortressCenter);
            }
        }
        class_2338 aboveTheCenter = this.fortressCenter.method_10084();
        class_2680 blockStateAbove = this.getWorld().method_8320(aboveTheCenter);
        if (blockStateAbove != DEFAULT_STATE_ABOVE_CAMPFIRE) {
            this.getWorld().method_8652(aboveTheCenter, DEFAULT_STATE_ABOVE_CAMPFIRE, 3);
            if (player != null) {
                this.getWorld().method_33596((class_1297)player, class_5712.field_28164, aboveTheCenter);
            }
        }
    }

    private void resetCampfireState(@Nullable class_3222 player) {
        class_2680 blockState = this.getWorld().method_8320(this.fortressCenter);
        if (blockState == CAMPFIRE_DEFAULT_STATE) {
            this.getWorld().method_8652(this.fortressCenter, class_2246.field_10124.method_9564(), 3);
            if (player != null) {
                this.getWorld().method_33596((class_1297)player, class_5712.field_28164, this.fortressCenter);
            }
        }
        class_2338 aboveTheCenter = this.fortressCenter.method_10084();
        class_2680 blockStateAbove = this.getWorld().method_8320(aboveTheCenter);
        if (blockStateAbove == DEFAULT_STATE_ABOVE_CAMPFIRE) {
            this.getWorld().method_8652(aboveTheCenter, class_2246.field_10124.method_9564(), 3);
            if (player != null) {
                this.getWorld().method_33596((class_1297)player, class_5712.field_28164, aboveTheCenter);
            }
        }
    }

    @Override
    public int getReservedPawnsCount() {
        return (int)this.getProfessionals().stream().filter(it -> it.getProfessionId().equals("reserve")).count();
    }

    @Override
    public void killAllPawns() {
        class_1282 outOfWorldDamageSource = this.getOutOfWorldDamageSource();
        this.pawns.forEach(it -> it.method_5643(outOfWorldDamageSource, 40.0f));
    }

    private class_1282 getOutOfWorldDamageSource() {
        class_3218 world = this.server.method_3847(class_1937.field_25179);
        if (world == null) {
            throw new IllegalStateException("World is null");
        }
        return world.method_48963().method_48829();
    }

    private Stream<IWorkerPawn> getWorkersStream() {
        return this.pawns.stream().filter(IWorkerPawn.class::isInstance).map(IWorkerPawn.class::cast);
    }

    private boolean allPawnsAreFree() {
        return this.getWorkersStream().noneMatch(it -> it.getTaskControl().hasTask());
    }

    @Override
    public Optional<class_1309> spawnPawnNearCampfire(UUID masterPlayerId) {
        class_2338 randomSpawnPosition = this.getRandomSpawnPosition();
        class_2487 tag = ServerFortressManager.getColonistInfoTag(masterPlayerId);
        class_1299<Colonist> colonistType = FortressEntities.COLONIST_ENTITY_TYPE;
        class_3218 world = this.getWorld();
        Colonist spawnedPawn = (Colonist)colonistType.method_5899(world, tag, it -> {}, randomSpawnPosition, class_3730.field_16471, true, false);
        return Optional.ofNullable(spawnedPawn);
    }

    @Override
    public void setupCenter(@NotNull class_2338 fortressCenter, class_1937 world, class_3222 player) {
        this.fortressCenter = fortressCenter;
        if (!(world instanceof class_3218)) {
            throw new IllegalArgumentException("World must be a server world");
        }
        if (this.campfireEnabled) {
            this.setTheCampfireState(player);
        }
        if (this.minX > this.fortressCenter.method_10263() - 10) {
            this.minX = this.fortressCenter.method_10263() - 10;
        }
        if (this.minZ > this.fortressCenter.method_10260() - 10) {
            this.minZ = this.fortressCenter.method_10260() - 10;
        }
        if (this.maxX < this.fortressCenter.method_10263() + 10) {
            this.maxX = this.fortressCenter.method_10263() + 10;
        }
        if (this.maxZ < this.fortressCenter.method_10260() + 10) {
            this.maxZ = this.fortressCenter.method_10260() + 10;
        }
        for (int i = 0; i < 5; ++i) {
            this.spawnPawnNearCampfire(player.method_5667());
        }
        this.influenceManager.addCenterAsInfluencePosition();
        player.method_26284(this.getWorld().method_27983(), player.method_24515(), 0.0f, true, false);
        this.scheduleSync();
    }

    @Override
    public void openHandledScreen(ScreenType type, class_3222 player, class_2338 pos) {
        switch (type) {
            case CRAFTING: {
                player.method_17355((class_3908)new FortressCraftingScreenHandlerFactory());
                break;
            }
            case FURNACE: {
                player.method_17355((class_3908)new FurnaceScreenHandlerFactory(pos));
            }
        }
    }

    @Override
    public void jumpToCampfire(class_3222 player) {
        if (this.fortressCenter == null) {
            return;
        }
        if (player.method_37908().method_27983() != class_1937.field_25179) {
            return;
        }
        player.method_36457(60.0f);
        player.method_36456(135.0f);
        player.method_20620((double)(this.fortressCenter.method_10263() + 10), (double)(this.fortressCenter.method_10264() + 20), (double)(this.fortressCenter.method_10260() + 10));
    }

    private static class_2487 getColonistInfoTag(UUID masterPlayerId) {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_25927("fortress_id", masterPlayerId);
        return nbtCompound;
    }

    private class_2338 getRandomSpawnPosition() {
        int spawnY;
        int spawnZ;
        int spawnX;
        do {
            spawnX = this.fortressCenter.method_10263() + this.getWorld().field_9229.method_43048(10) - 5;
            spawnZ = this.fortressCenter.method_10260() + this.getWorld().field_9229.method_43048(10) - 5;
            spawnY = this.getWorld().method_8624(class_2902.class_2903.field_13202, spawnX, spawnZ);
        } while (spawnX == this.fortressCenter.method_10263() && spawnZ == this.fortressCenter.method_10260());
        return new class_2338(spawnX, spawnY, spawnZ);
    }

    @Override
    public void syncOnJoin(boolean campfireEnabled, boolean borderEnabled) {
        this.campfireEnabled = campfireEnabled;
        this.borderEnabled = borderEnabled;
        this.needSync = true;
        this.needSyncSpecialBlocks = true;
        this.automationAreaManager.sync();
        this.influenceManager.sync();
    }

    @Override
    public void scheduleSync() {
        this.needSync = true;
    }

    private void scheduleSyncSpecialBlocks() {
        this.needSyncSpecialBlocks = true;
        this.scheduleSync();
    }

    public Set<IProfessional> getProfessionals() {
        return this.pawns.stream().filter(IProfessional.class::isInstance).map(IProfessional.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 posList;
        String blockId;
        if (this.fortressCenter != null) {
            tag.method_10569("centerX", this.fortressCenter.method_10263());
            tag.method_10569("centerY", this.fortressCenter.method_10264());
            tag.method_10569("centerZ", this.fortressCenter.method_10260());
        }
        tag.method_10569("minX", this.minX);
        tag.method_10569("minZ", this.minZ);
        tag.method_10569("maxX", this.maxX);
        tag.method_10569("maxZ", this.maxZ);
        class_2487 buildingsNbt = this.fortressBuildingManager.toNbt();
        tag.method_10566("buildings", (class_2520)buildingsNbt);
        class_2487 nameGeneratorTag = new class_2487();
        this.nameGenerator.write(nameGeneratorTag);
        tag.method_10566("nameGenerator", (class_2520)nameGeneratorTag);
        if (!this.specialBlocks.isEmpty()) {
            class_2487 specialBlocksTag = new class_2487();
            for (Map.Entry<class_2248, List<class_2338>> specialBlock : this.specialBlocks.entrySet()) {
                blockId = class_7923.field_41175.method_10221((Object)specialBlock.getKey()).toString();
                posList = new class_2499();
                for (class_2338 pos : specialBlock.getValue()) {
                    posList.add((Object)class_2512.method_10692((class_2338)pos));
                }
                specialBlocksTag.method_10566(blockId, (class_2520)posList);
            }
            tag.method_10566("specialBlocks", (class_2520)specialBlocksTag);
        }
        if (!this.blueprintsSpecialBlocks.isEmpty()) {
            class_2487 blueprintsSpecialBlocksTag = new class_2487();
            for (Map.Entry<class_2248, List<class_2338>> specialBlock : this.blueprintsSpecialBlocks.entrySet()) {
                blockId = class_7923.field_41175.method_10221((Object)specialBlock.getKey()).toString();
                posList = new class_2499();
                for (class_2338 pos : specialBlock.getValue()) {
                    posList.add((Object)class_2512.method_10692((class_2338)pos));
                }
                blueprintsSpecialBlocksTag.method_10566(blockId, (class_2520)posList);
            }
            tag.method_10566("blueprintsSpecialBlocks", (class_2520)blueprintsSpecialBlocksTag);
        }
        class_2487 professionTag = new class_2487();
        this.professionManager.writeToNbt(professionTag);
        tag.method_10566("profession", (class_2520)professionTag);
        tag.method_10582("gamemode", this.gamemode.name());
        if (this.maxColonistsCount != -1) {
            tag.method_10569("maxColonistsCount", this.maxColonistsCount);
        }
        this.resourceManager.write(tag);
        this.automationAreaManager.write(tag);
        this.influenceManager.write(tag);
    }

    public void readFromNbt(class_2487 tag) {
        int j;
        ArrayList<class_2338> positions;
        class_2499 posList;
        class_2248 block;
        int centerX = tag.method_10550("centerX");
        int centerY = tag.method_10550("centerY");
        int centerZ = tag.method_10550("centerZ");
        if (centerX != 0 || centerY != 0 || centerZ != 0) {
            this.fortressCenter = new class_2338(centerX, centerY, centerZ);
        }
        if (tag.method_10545("minX")) {
            this.minX = tag.method_10550("minX");
        }
        if (tag.method_10545("minZ")) {
            this.minZ = tag.method_10550("minZ");
        }
        if (tag.method_10545("maxX")) {
            this.maxX = tag.method_10550("maxX");
        }
        if (tag.method_10545("maxZ")) {
            this.maxZ = tag.method_10550("maxZ");
        }
        this.fortressBuildingManager.reset();
        if (tag.method_10545("buildings")) {
            class_2487 buildingsTag = tag.method_10562("buildings");
            this.fortressBuildingManager.readFromNbt(buildingsTag);
        }
        if (tag.method_10545("nameGenerator")) {
            class_2487 nameGeneratorTag = tag.method_10562("nameGenerator");
            this.nameGenerator = new ColonistNameGenerator(nameGeneratorTag);
        }
        if (tag.method_10545("specialBlocks")) {
            class_2487 specialBlocksTag = tag.method_10562("specialBlocks");
            for (String blockId : specialBlocksTag.method_10541()) {
                block = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockId));
                posList = specialBlocksTag.method_10554(blockId, 10);
                positions = new ArrayList<class_2338>();
                for (j = 0; j < posList.size(); ++j) {
                    positions.add(class_2512.method_10691((class_2487)posList.method_10602(j)));
                }
                this.specialBlocks.put(block, positions);
            }
            this.scheduleSyncSpecialBlocks();
        }
        if (tag.method_10545("blueprintsSpecialBlocks")) {
            class_2487 blueprintsSpecialBlocksTag = tag.method_10562("blueprintsSpecialBlocks");
            for (String blockId : blueprintsSpecialBlocksTag.method_10541()) {
                block = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockId));
                posList = blueprintsSpecialBlocksTag.method_10554(blockId, 10);
                positions = new ArrayList();
                for (j = 0; j < posList.size(); ++j) {
                    positions.add(class_2512.method_10691((class_2487)posList.method_10602(j)));
                }
                this.blueprintsSpecialBlocks.put(block, positions);
            }
            this.scheduleSyncSpecialBlocks();
        }
        if (tag.method_10545("profession")) {
            class_2487 professionTag = tag.method_10562("profession");
            this.professionManager.readFromNbt(professionTag);
        }
        if (tag.method_10545("gamemode")) {
            String gamemodeName = tag.method_10558("gamemode");
            FortressGamemode fortressGamemode = FortressGamemode.valueOf(gamemodeName);
            this.setGamemode(fortressGamemode);
        }
        this.resourceManager.read(tag);
        if (tag.method_10545("maxColonistsCount")) {
            this.maxColonistsCount = tag.method_10550("maxColonistsCount");
        }
        this.automationAreaManager.read(tag);
        this.influenceManager.read(tag);
        this.scheduleSync();
    }

    @Override
    public Optional<IAutomationArea> getAutomationAreaByRequirementId(String requirement) {
        IServerBuildingsManager iServerBuildingsManager = this.fortressBuildingManager;
        if (iServerBuildingsManager instanceof IAutomationAreaProvider) {
            IAutomationAreaProvider provider = (IAutomationAreaProvider)((Object)iServerBuildingsManager);
            Stream<IAutomationArea> buildings = provider.getAutomationAreasByRequirement(requirement);
            Stream<IAutomationArea> areas = this.automationAreaManager.getByRequirement(requirement);
            return Stream.concat(buildings, areas).min(Comparator.comparing(IAutomationArea::getUpdated));
        }
        return Optional.empty();
    }

    @Override
    public IPawnNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    @Override
    public class_2338 getFortressCenter() {
        return this.fortressCenter != null ? this.fortressCenter.method_10062() : null;
    }

    @Override
    public Optional<class_2338> getRandomPosWithinFortress() {
        if (this.minX == Integer.MAX_VALUE) {
            return Optional.empty();
        }
        int x = this.getWorld().field_9229.method_43048(this.maxX - this.minX) + this.minX;
        int z = this.getWorld().field_9229.method_43048(this.maxZ - this.minZ) + this.minZ;
        int y = this.getWorld().method_8624(class_2902.class_2903.field_13202, x, z);
        class_2338 fortressPos = new class_2338(x, y, z);
        if (this.fortressBuildingManager.isPartOfAnyBuilding(fortressPos)) {
            return Optional.empty();
        }
        boolean isFluid = this.getWorld().method_8320(fortressPos).method_27852(class_2246.field_10382);
        if (isFluid) {
            return Optional.empty();
        }
        boolean isFluidAbove = this.getWorld().method_8320(fortressPos.method_10074()).method_27852(class_2246.field_10382);
        if (isFluidAbove) {
            return Optional.empty();
        }
        return Optional.of(fortressPos.method_10084());
    }

    @Override
    public boolean isPositionWithinFortress(class_2338 pos) {
        if (this.minX == Integer.MAX_VALUE) {
            return false;
        }
        return pos.method_10263() >= this.minX && pos.method_10263() <= this.maxX && pos.method_10260() >= this.minZ && pos.method_10260() <= this.maxZ;
    }

    @Override
    public Optional<class_2338> getRandomPositionAroundCampfire() {
        class_2338 fortressCenter = this.getFortressCenter();
        if (fortressCenter == null) {
            return Optional.empty();
        }
        class_5819 random = this.getWorld().field_9229;
        double radius = Math.sqrt(random.method_43058());
        double angle = random.method_43058() * 2.0 * Math.PI;
        int x = (int)Math.round(radius * Math.cos(angle) * this.getCampfireWarmRadius());
        int z = (int)Math.round(radius * Math.sin(angle) * this.getCampfireWarmRadius());
        int blockX = fortressCenter.method_10263() + x;
        int blockZ = fortressCenter.method_10260() + z;
        int blockY = this.getWorld().method_8624(class_2902.class_2903.field_13202, blockX, blockZ);
        return Optional.of(new class_2338(blockX, blockY, blockZ));
    }

    @Override
    public double getCampfireWarmRadius() {
        return Math.max(Math.sqrt(this.getTotalColonistsCount()), 4.0);
    }

    @Override
    public boolean hasRequiredBuilding(String requirementId, int minCount) {
        return this.fortressBuildingManager.hasRequiredBuilding(requirementId, minCount);
    }

    @Override
    public boolean hasRequiredBlock(class_2248 block, boolean blueprint, int minCount) {
        if (blueprint) {
            return this.blueprintsSpecialBlocks.getOrDefault(block, Collections.emptyList()).size() > minCount;
        }
        return this.specialBlocks.getOrDefault(block, Collections.emptyList()).size() > minCount;
    }

    @Override
    public IServerAutomationAreaManager getAutomationAreaManager() {
        return this.automationAreaManager;
    }

    @Override
    public boolean isBlockSpecial(class_2248 block) {
        return block.equals(class_2246.field_9980) || block.equals(class_2246.field_10181);
    }

    @Override
    public void addSpecialBlocks(class_2248 block, class_2338 blockPos, boolean blueprint) {
        List blocks;
        List list = blocks = blueprint ? this.blueprintsSpecialBlocks.computeIfAbsent(block, k -> new ArrayList()) : this.specialBlocks.computeIfAbsent(block, k -> new ArrayList());
        if (!blocks.contains(blockPos)) {
            blocks.add(blockPos);
        }
        this.scheduleSyncSpecialBlocks();
    }

    @Override
    public int getTotalColonistsCount() {
        return this.pawns.size();
    }

    public Optional<Colonist> getPawnWithoutAProfession() {
        return this.pawns.stream().filter(Colonist.class::isInstance).map(Colonist.class::cast).filter(it -> it.getProfessionId().equals("colonist")).findAny();
    }

    @Override
    public IServerProfessionsManager getProfessionsManager() {
        return this.professionManager;
    }

    @Override
    public List<IWorkerPawn> getFreeColonists() {
        return this.getWorkersStream().filter(c -> !c.getTaskControl().hasTask()).collect(Collectors.toList());
    }

    @Override
    public List<class_2338> getSpecialBlocksByType(class_2248 block, boolean blueprint) {
        if (blueprint) {
            return this.blueprintsSpecialBlocks.getOrDefault(block, Collections.emptyList());
        }
        return this.specialBlocks.getOrDefault(block, Collections.emptyList());
    }

    @Override
    public void setGamemode(FortressGamemode gamemode) {
        this.gamemode = gamemode;
        this.scheduleSync();
    }

    @Override
    public boolean isCreative() {
        return this.gamemode == FortressGamemode.CREATIVE;
    }

    @Override
    public boolean isSurvival() {
        return this.gamemode != null && this.gamemode == FortressGamemode.SURVIVAL;
    }

    @Override
    public IServerResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private class_3218 getWorld() {
        return this.server.method_3847(class_1937.field_25179);
    }

    @Override
    public void increaseMaxColonistsCount() {
        if (this.maxColonistsCount == -1) {
            return;
        }
        ++this.maxColonistsCount;
        if (this.maxColonistsCount >= this.getTotalColonistsCount()) {
            this.maxColonistsCount = -1;
        }
        this.scheduleSync();
    }

    @Override
    public void decreaseMaxColonistsCount() {
        if (this.maxColonistsCount == -1) {
            this.maxColonistsCount = this.getTotalColonistsCount();
        }
        --this.maxColonistsCount;
        if (this.maxColonistsCount <= 0) {
            this.maxColonistsCount = 1;
        }
        this.scheduleSync();
    }

    @Override
    public void expandTheVillage(class_2338 pos) {
        if (this.maxX < pos.method_10263()) {
            this.maxX = pos.method_10263();
        }
        if (this.minX > pos.method_10263()) {
            this.minX = pos.method_10263();
        }
        if (this.maxZ < pos.method_10260()) {
            this.maxZ = pos.method_10260();
        }
        if (this.minZ > pos.method_10260()) {
            this.minZ = pos.method_10260();
        }
    }

    public double getVillageRadius() {
        double radius1 = this.flatDistanceToCampfire(this.maxX, this.maxZ);
        double radius2 = this.flatDistanceToCampfire(this.minX, this.minZ);
        double radius3 = this.flatDistanceToCampfire(this.maxX, this.minZ);
        double radius4 = this.flatDistanceToCampfire(this.minX, this.maxZ);
        return Math.max(Math.max(radius1, radius2), Math.max(radius3, radius4));
    }

    @Override
    public void repairBuilding(class_3222 player, UUID taskId, UUID buildingId) {
        IServerBuildingsManager buildingManager = this.getBuildingsManager();
        IServerResourceManager resourceManager = this.getResourceManager();
        try {
            IFortressBuilding building = buildingManager.getBuildingById(buildingId).orElseThrow(() -> new IllegalStateException("Building not found"));
            Map<class_2338, class_2680> blocksToRepair = building.getAllBlockStatesToRepairTheBuilding();
            if (this.isSurvival()) {
                List<IItemInfo> blockInfos = BlockInfoUtils.convertBlockStatesMapItemsMap(blocksToRepair).entrySet().stream().map(it -> new ItemInfo((class_1792)it.getKey(), ((Long)it.getValue()).intValue())).map(IItemInfo.class::cast).toList();
                resourceManager.reserveItems(taskId, blockInfos);
            }
            RepairBuildingTask task = new RepairBuildingTask(taskId, building.getStart(), building.getEnd(), blocksToRepair);
            this.taskManager.addTask(task, this, this);
        }
        catch (RuntimeException exp) {
            LogManager.getLogger().error("Error while repairing building", (Throwable)exp);
            FortressServerNetworkHelper.send(player, "finish_task", new ClientboundTaskExecutedPacket(taskId));
        }
    }

    private double flatDistanceToCampfire(double x, double z) {
        int campfireX = this.fortressCenter.method_10263();
        int campfireZ = this.fortressCenter.method_10260();
        double deltaX = x - (double)campfireX;
        double deltaZ = z - (double)campfireZ;
        return Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
    }
}

