/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_2789;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IClientInfluenceManager;
import org.jetbrains.annotations.Nullable;
import org.minefortress.utils.ModUtils;

public final class FortressBorder
extends class_2784 {
    private boolean hasDynamicStage = false;
    private final Set<class_2784> additionalBorders = new HashSet<class_2784>();
    private final List<BoundPosition> uniqueBorders = new ArrayList<BoundPosition>();

    public void addAdditionalBorder(class_2784 worldBorder) {
        this.additionalBorders.add(worldBorder);
        this.recalculateUniqueBorders();
    }

    private void recalculateUniqueBorders() {
        this.uniqueBorders.clear();
        List<BoundPosition> thisBorderPositions = Arrays.asList(new BoundPosition(this.method_11976(), this.method_11980()), new BoundPosition(this.method_11963(), this.method_11980()), new BoundPosition(this.method_11964(), this.method_11958()), new BoundPosition(this.method_11964(), this.method_11977()));
        ArrayList<BoundPosition> nonUniqueBorders = new ArrayList<BoundPosition>(thisBorderPositions);
        for (class_2784 additionalBorder : this.additionalBorders) {
            nonUniqueBorders.add(new BoundPosition(additionalBorder.method_11976(), additionalBorder.method_11980()));
            nonUniqueBorders.add(new BoundPosition(additionalBorder.method_11963(), additionalBorder.method_11980()));
            nonUniqueBorders.add(new BoundPosition(additionalBorder.method_11964(), additionalBorder.method_11958()));
            nonUniqueBorders.add(new BoundPosition(additionalBorder.method_11964(), additionalBorder.method_11977()));
        }
        nonUniqueBorders.removeIf(it -> Collections.frequency(nonUniqueBorders, it) > 1);
        this.uniqueBorders.addAll(nonUniqueBorders);
    }

    public boolean shouldRenderBound(@Nullable Double boundX, @Nullable Double boundZ) {
        return this.additionalBorders.isEmpty() || boundX != null && boundZ != null && this.uniqueBorders.contains(new BoundPosition(boundX, boundZ));
    }

    public class_2789 method_11968() {
        if (!this.hasDynamicStage) {
            return super.method_11968();
        }
        IClientFortressManager fortressClientManager = ModUtils.getFortressClientManager();
        if (fortressClientManager.isCenterNotSet()) {
            return class_2789.field_12754;
        }
        IClientInfluenceManager influenceManager = ModUtils.getInfluenceManager();
        return influenceManager.getInfluencePosStateHolder().getWorldBorderStage();
    }

    public boolean method_11952(class_2338 pos) {
        if (super.method_11952(pos)) {
            return true;
        }
        Set<class_2784> ab = this.getAdditionalBorders();
        for (class_2784 additionalBorder : ab) {
            if (!additionalBorder.method_11952(pos)) continue;
            return true;
        }
        return false;
    }

    public void enableDynamicStage() {
        this.hasDynamicStage = true;
    }

    public Set<class_2784> getAdditionalBorders() {
        return Collections.unmodifiableSet(this.additionalBorders);
    }

    private record BoundPosition(double x, double z) {
    }
}

