/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fortress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_761;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.FortressGamemode;
import net.remmintan.mods.minefortress.core.FortressState;
import net.remmintan.mods.minefortress.core.dtos.buildings.BuildingHealthRenderInfo;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IEssentialBuildingInfo;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.client.IHoveredBlockProvider;
import net.remmintan.mods.minefortress.core.interfaces.combat.IClientFightManager;
import net.remmintan.mods.minefortress.core.interfaces.combat.IClientFightSelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.IClientProfessionManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.IHireInfo;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.networking.c2s.C2SJumpToCampfire;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundFortressCenterSetPacket;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundSetGamemodePacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.MineFortressMod;
import org.minefortress.fight.ClientFightManager;
import org.minefortress.fortress.FortressToast;
import org.minefortress.fortress.resources.client.ClientResourceManagerImpl;
import org.minefortress.professions.ClientProfessionManager;
import org.minefortress.professions.hire.ClientHireHandler;
import org.minefortress.renderer.gui.fortress.RepairBuildingScreen;
import org.minefortress.renderer.gui.hire.HirePawnScreen;
import org.minefortress.utils.BlockUtils;
import org.minefortress.utils.ModUtils;

public final class ClientFortressManager
implements IClientFortressManager {
    private static final Object KEY = new Object();
    private final IClientProfessionManager professionManager;
    private final IClientResourceManager resourceManager = new ClientResourceManagerImpl();
    private final IClientFightManager fightManager = new ClientFightManager();
    private boolean connectedToTheServer = false;
    private boolean initialized = false;
    private class_2338 fortressCenter = null;
    private int colonistsCount = 0;
    private int reservedColonistCount = 0;
    private IEssentialBuildingInfo hoveredBuilding = null;
    private volatile FortressToast setCenterToast;
    private class_2338 posAppropriateForCenter;
    private class_2338 oldPosAppropriateForCenter;
    private class_1309 selectedPawn;
    private List<IEssentialBuildingInfo> buildings = new ArrayList<IEssentialBuildingInfo>();
    private Map<class_2248, List<class_2338>> specialBlocks = new HashMap<class_2248, List<class_2338>>();
    private Map<class_2248, List<class_2338>> blueprintsSpecialBlocks = new HashMap<class_2248, List<class_2338>>();
    private FortressGamemode gamemode;
    private int maxColonistsCount;
    private FortressState state = FortressState.BUILD;
    private boolean campfireEnabled = true;
    private boolean borderEnabled = true;

    public ClientFortressManager() {
        this.professionManager = new ClientProfessionManager(() -> ((IClientManagersProvider)class_310.method_1551()).get_ClientFortressManager());
    }

    @Override
    public void select(class_1309 colonist) {
        if (this.state == FortressState.COMBAT) {
            class_312 mouse = class_310.method_1551().field_1729;
            IClientFightSelectionManager selectionManager = this.fightManager.getSelectionManager();
            selectionManager.startSelection(mouse.method_1603(), mouse.method_1604(), colonist.method_19538());
            selectionManager.updateSelection(mouse.method_1603(), mouse.method_1604(), colonist.method_19538());
            selectionManager.endSelection();
            this.selectedPawn = null;
            return;
        }
        this.selectedPawn = colonist;
    }

    @Override
    public void jumpToCampfire() {
        C2SJumpToCampfire packet = new C2SJumpToCampfire();
        FortressClientNetworkHelper.send("jump_to_campfire", packet);
    }

    @Override
    public void updateBuildings(List<IEssentialBuildingInfo> buildings) {
        this.buildings = buildings;
    }

    @Override
    public void setSpecialBlocks(Map<class_2248, List<class_2338>> specialBlocks, Map<class_2248, List<class_2338>> blueprintSpecialBlocks) {
        this.specialBlocks = specialBlocks;
        this.blueprintsSpecialBlocks = blueprintSpecialBlocks;
    }

    @Override
    public boolean isSelectingColonist() {
        return this.selectedPawn != null && this.state == FortressState.BUILD;
    }

    @Override
    public class_1309 getSelectedPawn() {
        return this.selectedPawn;
    }

    @Override
    public void stopSelectingColonist() {
        this.selectedPawn = null;
    }

    @Override
    public int getReservedPawnsCount() {
        return this.reservedColonistCount;
    }

    @Override
    public void sync(int colonistsCount, class_2338 fortressCenter, FortressGamemode gamemode, boolean connectedToTheServer, int maxColonistsCount, int reservedColonistCount, boolean campfireEnabled, boolean borderEnabled) {
        this.colonistsCount = colonistsCount;
        this.fortressCenter = fortressCenter;
        this.gamemode = gamemode;
        this.connectedToTheServer = connectedToTheServer;
        this.maxColonistsCount = maxColonistsCount;
        this.reservedColonistCount = reservedColonistCount;
        this.campfireEnabled = campfireEnabled;
        this.borderEnabled = borderEnabled;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(IHoveredBlockProvider fortressClient) {
        if (this.isSelectingColonist() && this.selectedPawn.method_29504()) {
            this.stopSelectingColonist();
        }
        class_310 client = (class_310)fortressClient;
        if (client.field_1687 == null || client.field_1761 == null || client.field_1761.method_2920() != MineFortressMod.FORTRESS) {
            Object object = KEY;
            synchronized (object) {
                if (this.setCenterToast != null) {
                    this.setCenterToast.hide();
                    this.setCenterToast = null;
                }
            }
            this.posAppropriateForCenter = null;
            return;
        }
        if (!this.initialized) {
            return;
        }
        if (this.isCenterNotSet()) {
            Object object = KEY;
            synchronized (object) {
                if (this.setCenterToast == null) {
                    this.setCenterToast = new FortressToast("Set up your Fortress", "Right-click to place", class_1802.field_17346);
                    client.method_1566().method_1999((class_368)this.setCenterToast);
                }
            }
            class_2338 hoveredBlockPos = fortressClient.get_HoveredBlockPos();
            if (hoveredBlockPos != null && !hoveredBlockPos.equals((Object)class_2338.field_10980)) {
                if (hoveredBlockPos.equals((Object)this.oldPosAppropriateForCenter)) {
                    return;
                }
                class_2338 cursor = hoveredBlockPos;
                while (!BuildingHelper.canPlaceBlock((class_1937)client.field_1687, cursor)) {
                    cursor = cursor.method_10084();
                }
                while (BuildingHelper.canPlaceBlock((class_1937)client.field_1687, cursor.method_10074())) {
                    cursor = cursor.method_10074();
                }
                this.posAppropriateForCenter = cursor.method_10062();
            }
        }
    }

    @Override
    public void open_HireScreen(class_310 client, String screenName, Map<String, IHireInfo> professions) {
        ClientHireHandler handler = new ClientHireHandler(screenName, professions);
        HirePawnScreen screen = new HirePawnScreen(handler);
        client.method_1507((class_437)screen);
    }

    @Override
    public boolean isConnectedToTheServer() {
        return this.initialized && this.connectedToTheServer;
    }

    @Override
    public class_2338 getPosAppropriateForCenter() {
        return this.posAppropriateForCenter;
    }

    @Override
    public boolean notInitialized() {
        return !this.initialized;
    }

    @Override
    public boolean isCenterNotSet() {
        return this.initialized && this.fortressCenter == null && this.gamemode != FortressGamemode.NONE;
    }

    @Override
    public void setupFortressCenter() {
        if (this.fortressCenter != null) {
            throw new IllegalStateException("Fortress center already set");
        }
        this.setCenterToast.hide();
        this.setCenterToast = null;
        this.fortressCenter = this.posAppropriateForCenter;
        this.posAppropriateForCenter = null;
        ServerboundFortressCenterSetPacket serverboundFortressCenterSetPacket = new ServerboundFortressCenterSetPacket(this.fortressCenter);
        FortressClientNetworkHelper.send("fortress_set_center", serverboundFortressCenterSetPacket);
        class_310 client = class_310.method_1551();
        class_761 worldRenderer = client.field_1769;
        if (worldRenderer != null) {
            worldRenderer.method_18145(this.fortressCenter.method_10263(), this.fortressCenter.method_10264(), this.fortressCenter.method_10260());
            worldRenderer.method_3292();
        }
    }

    @Override
    public void updateRenderer(class_761 worldRenderer) {
        if (this.oldPosAppropriateForCenter == this.posAppropriateForCenter) {
            return;
        }
        class_2338 posAppropriateForCenter = this.getPosAppropriateForCenter();
        if (posAppropriateForCenter != null) {
            this.oldPosAppropriateForCenter = posAppropriateForCenter;
            class_2338 start = posAppropriateForCenter.method_10069(-2, -2, -2);
            class_2338 end = posAppropriateForCenter.method_10069(2, 2, 2);
            worldRenderer.method_18146(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263(), end.method_10264(), end.method_10260());
            worldRenderer.method_3292();
        }
    }

    @Override
    public List<class_2338> getBuildingSelection(class_2338 pos) {
        for (IEssentialBuildingInfo building : this.buildings) {
            class_2338 end;
            class_2338 start = building.getStart();
            if (!BlockUtils.isPosBetween(pos, start, end = building.getEnd())) continue;
            this.hoveredBuilding = building;
            return StreamSupport.stream(class_2338.method_10097((class_2338)start, (class_2338)end).spliterator(), false).map(class_2338::method_10062).collect(Collectors.toList());
        }
        this.hoveredBuilding = null;
        return Collections.emptyList();
    }

    @Override
    public boolean isBuildingHovered() {
        return this.hoveredBuilding != null;
    }

    @Override
    public Optional<IEssentialBuildingInfo> getHoveredBuilding() {
        return Optional.ofNullable(this.hoveredBuilding);
    }

    @Override
    public Optional<String> getHoveredBuildingName() {
        return this.getHoveredBuilding().flatMap(IEssentialBuildingInfo::getBlueprintId).flatMap(it -> ModUtils.getBlueprintManager().getBlueprintMetadataManager().getByBlueprintId((String)it)).map(IBlueprintMetadata::getName);
    }

    @Override
    public IClientProfessionManager getProfessionManager() {
        return this.professionManager;
    }

    @Override
    public boolean hasRequiredBuilding(String requirementId, int minCount) {
        Stream<IEssentialBuildingInfo> requiredBuilding = this.buildings.stream().filter(b -> b.getRequirementId().equals(requirementId));
        if (requirementId.startsWith("miner") || requirementId.startsWith("lumberjack") || requirementId.startsWith("warrior")) {
            return requiredBuilding.mapToLong(it -> it.getBedsCount() * 10L).sum() > (long)minCount;
        }
        long count = requiredBuilding.count();
        if (requirementId.equals("shooting_gallery")) {
            return count * 10L > (long)minCount;
        }
        if (requirementId.startsWith("farm")) {
            return count * 5L > (long)minCount;
        }
        return count > (long)minCount;
    }

    @Override
    public int countBuildings(String requirementId) {
        return (int)this.buildings.stream().filter(b -> b.getRequirementId().equals(requirementId)).count();
    }

    @Override
    public boolean hasRequiredBlock(class_2248 block, boolean blueprint, int minCount) {
        if (blueprint) {
            return this.blueprintsSpecialBlocks.getOrDefault(block, Collections.emptyList()).size() > minCount;
        }
        return this.specialBlocks.getOrDefault(block, Collections.emptyList()).size() > minCount;
    }

    @Override
    public int getTotalColonistsCount() {
        return this.colonistsCount;
    }

    @Override
    public void setGamemode(FortressGamemode gamemode) {
        if (gamemode == null) {
            throw new IllegalArgumentException("Gamemode cannot be null");
        }
        if (gamemode == FortressGamemode.NONE) {
            throw new IllegalArgumentException("Gamemode cannot be NONE");
        }
        ServerboundSetGamemodePacket serverboundSetGamemodePacket = new ServerboundSetGamemodePacket(gamemode);
        FortressClientNetworkHelper.send("fortress_set_gamemode", serverboundSetGamemodePacket);
    }

    @Override
    public boolean gamemodeNeedsInitialization() {
        return this.initialized && this.gamemode == FortressGamemode.NONE;
    }

    @Override
    public boolean isCreative() {
        return this.gamemode == FortressGamemode.CREATIVE;
    }

    @Override
    public boolean isSurvival() {
        return this.gamemode != null && this.gamemode == FortressGamemode.SURVIVAL;
    }

    @Override
    public IClientResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public IClientFightManager getFightManager() {
        return this.fightManager;
    }

    @Override
    public int getMaxColonistsCount() {
        return this.maxColonistsCount;
    }

    @Override
    public void reset() {
        this.initialized = false;
        this.selectedPawn = null;
        this.state = FortressState.BUILD;
    }

    @Override
    public void setState(FortressState state) {
        this.state = state;
        if (state == FortressState.AREAS_SELECTION) {
            ModUtils.getAreasClientManager().getSavedAreasHolder().setNeedRebuild(true);
        }
        if (state == FortressState.BUILD) {
            ModUtils.getClientTasksHolder().ifPresent(it -> it.setNeedRebuild(true));
        }
    }

    @Override
    public FortressState getState() {
        return this.state;
    }

    @Override
    public List<BuildingHealthRenderInfo> getBuildingHealths() {
        return switch (this.getState()) {
            case FortressState.COMBAT -> this.buildings.stream().filter(it -> it.getHealth() < 100).map(this::buildingToHealthRenderInfo).toList();
            case FortressState.BUILD -> this.buildings.stream().filter(it -> it.getHealth() < 33).map(this::buildingToHealthRenderInfo).toList();
            default -> Collections.emptyList();
        };
    }

    private BuildingHealthRenderInfo buildingToHealthRenderInfo(IEssentialBuildingInfo buildingInfo) {
        class_2338 start = buildingInfo.getStart();
        class_2338 end = buildingInfo.getEnd();
        int maxY = Math.max(start.method_10264(), end.method_10264());
        int centerX = (start.method_10263() + end.method_10263()) / 2;
        int centerZ = (start.method_10260() + end.method_10260()) / 2;
        class_243 center = new class_243((double)centerX, (double)maxY, (double)centerZ);
        int health = buildingInfo.getHealth();
        return new BuildingHealthRenderInfo(center, health);
    }

    @Override
    public boolean isBorderEnabled() {
        return this.borderEnabled;
    }

    @Override
    public void openRepairBuildingScreen(UUID buildingId, Map<class_2338, class_2680> blocksToRepair) {
        class_310.method_1551().method_1507((class_437)new RepairBuildingScreen(buildingId, blocksToRepair, this.resourceManager));
    }
}

