/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fight.influence;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2789;
import net.minecraft.class_3222;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.infuence.ICaptureTask;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IServerInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;
import net.remmintan.mods.minefortress.networking.s2c.S2CSyncInfluence;
import net.remmintan.mods.minefortress.networking.s2c.S2CUpdateInfluenceBorderStage;
import org.jetbrains.annotations.Nullable;
import org.minefortress.fight.influence.InfluenceFlagBlockDataProvider;
import org.minefortress.fight.influence.ServerFortressBorderHolder;
import org.minefortress.fortress.ServerFortressManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfluenceManager
implements IServerInfluenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerInfluenceManager.class);
    private final Deque<ICaptureTask> captureTasksQueue = new ConcurrentLinkedDeque<ICaptureTask>();
    private final List<class_2338> allInfluencePositions = new ArrayList<class_2338>();
    private final Synchronizer synchronizer = new Synchronizer();
    private final InfluenceFlagBlockDataProvider influenceFlagBlockDataProvider = new InfluenceFlagBlockDataProvider();
    private final ServerFortressBorderHolder fortressBorderHolder = new ServerFortressBorderHolder();
    private final ServerFortressManager serverFortressManager;

    public ServerInfluenceManager(ServerFortressManager serverFortressManager) {
        this.serverFortressManager = serverFortressManager;
    }

    @Override
    public void addCapturePosition(UUID taskId, class_2338 pos, class_3222 player) {
        class_2789 stage = this.fortressBorderHolder.getStage(pos);
        IServerResourceManager resourceManager = this.serverFortressManager.getResourceManager();
        IStructureBlockData influenceFlag = this.influenceFlagBlockDataProvider.getBlockData("influence_flag", class_2470.field_11467);
        List<IItemInfo> stacks = influenceFlag.getStacks();
        if (stage == class_2789.field_12754 && (resourceManager.hasItems(stacks) || this.serverFortressManager.isCreative())) {
            if (this.serverFortressManager.isSurvival()) {
                resourceManager.reserveItems(taskId, stacks);
            }
            this.captureTasksQueue.add(new CaptureTask(taskId, pos));
            this.fortressBorderHolder.add(pos);
        } else {
            ClientboundTaskExecutedPacket packet = new ClientboundTaskExecutedPacket(taskId);
            FortressServerNetworkHelper.send(player, "finish_task", packet);
            LOGGER.warn("Player tried to capture influence flag without having the required items!");
        }
    }

    @Override
    public ICaptureTask getCaptureTask() {
        return this.captureTasksQueue.poll();
    }

    @Override
    public void failCaptureTask(ICaptureTask task) {
        this.captureTasksQueue.add(task);
    }

    @Override
    public IBlockDataProvider getBlockDataProvider() {
        return this.influenceFlagBlockDataProvider;
    }

    @Override
    public void addInfluencePosition(class_2338 pos) {
        this.allInfluencePositions.add(pos);
        this.synchronizer.scheduleSync();
    }

    @Override
    public void tick(@Nullable class_3222 player) {
        if (player == null) {
            return;
        }
        this.synchronizer.tick(player);
    }

    @Override
    public void sync() {
        this.synchronizer.scheduleSync();
    }

    @Override
    public void write(class_2487 tag) {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        for (class_2338 pos : this.allInfluencePositions) {
            class_2487 posTag = new class_2487();
            posTag.method_10544("pos", pos.method_10063());
            list.add((Object)posTag);
        }
        nbt.method_10566("positions", (class_2520)list);
        tag.method_10566("influenceManager", (class_2520)nbt);
    }

    @Override
    public void checkNewPositionAndUpdateClientState(class_2338 pos, class_3222 player) {
        S2CUpdateInfluenceBorderStage packet = new S2CUpdateInfluenceBorderStage(this.fortressBorderHolder.getStage(pos));
        FortressServerNetworkHelper.send(player, "update_influence_border_stage", packet);
    }

    @Override
    public void read(class_2487 tag) {
        if (!tag.method_10545("influenceManager")) {
            this.addCenterAsInfluencePosition();
            return;
        }
        class_2487 nbt = tag.method_10562("influenceManager");
        this.allInfluencePositions.clear();
        this.fortressBorderHolder.clear();
        class_2499 list = nbt.method_10554("positions", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 posTag = list.method_10602(i);
            class_2338 pos = class_2338.method_10092((long)posTag.method_10537("pos"));
            this.allInfluencePositions.add(pos);
            this.fortressBorderHolder.add(pos);
        }
        if (this.allInfluencePositions.isEmpty()) {
            this.addCenterAsInfluencePosition();
        }
        this.synchronizer.scheduleSync();
    }

    @Override
    public void addCenterAsInfluencePosition() {
        class_2338 fortressCenter = this.serverFortressManager.getFortressCenter();
        if (fortressCenter != null) {
            this.addInfluencePosition(fortressCenter);
            this.fortressBorderHolder.add(fortressCenter);
        }
    }

    private class Synchronizer {
        private boolean syncScheduled = false;

        private Synchronizer() {
        }

        public void scheduleSync() {
            if (this.syncScheduled) {
                return;
            }
            this.syncScheduled = true;
        }

        public void tick(class_3222 player) {
            if (!this.syncScheduled) {
                return;
            }
            S2CSyncInfluence s2CSyncInfluence = new S2CSyncInfluence(ServerInfluenceManager.this.allInfluencePositions);
            FortressServerNetworkHelper.send(player, "sync_influence", s2CSyncInfluence);
            this.syncScheduled = false;
        }
    }

    public record CaptureTask(UUID taskId, class_2338 pos) implements ICaptureTask
    {
    }
}

