/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fight.influence;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2789;
import net.minecraft.class_310;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IClientInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IInfluencePosStateHolder;
import net.remmintan.mods.minefortress.core.interfaces.professions.IClientProfessionManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionsHireTypes;
import net.remmintan.mods.minefortress.networking.c2s.C2SCaptureInfluencePositionPacket;
import net.remmintan.mods.minefortress.networking.c2s.C2SUpdateNewInfluencePosition;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.blueprints.manager.BaseClientStructureManager;
import org.minefortress.blueprints.manager.BlueprintMetadata;
import org.minefortress.fight.influence.BaseFortressBorderHolder;
import org.minefortress.fight.influence.ClientFortressBorderHolder;
import org.minefortress.fight.influence.InfluenceFlagBlockDataProvider;
import org.minefortress.utils.ModUtils;

public class ClientInfluenceManager
extends BaseClientStructureManager
implements IClientInfluenceManager {
    private static final IBlueprintMetadata INFLUENCE_FLAG_METADATA = new BlueprintMetadata("Influence Flag", "influence_flag", 0, null);
    private final InfluenceFlagBlockDataProvider blockDataProvider = new InfluenceFlagBlockDataProvider();
    private final ClientFortressBorderHolder clientFortressBorderHolder = new ClientFortressBorderHolder(this);
    private final IInfluencePosStateHolder influencePosStateHolder = new InfluencePosStateHolder();
    private boolean isSelectingInfluencePosition = false;

    public ClientInfluenceManager(class_310 client) {
        super(client);
    }

    public static boolean influenceEnabled() {
        IClientFortressManager fortressClientManager = ModUtils.getFortressClientManager();
        return fortressClientManager.isSurvival() && fortressClientManager.isBorderEnabled();
    }

    @Override
    public void tick() {
        super.tick();
        this.influencePosStateHolder.syncNewPos(this.getStructureBuildPos());
    }

    @Override
    public Optional<class_2784> getFortressBorder() {
        if (ClientInfluenceManager.influenceEnabled()) {
            return this.clientFortressBorderHolder.getFortressBorder();
        }
        return Optional.ofNullable(class_310.method_1551().field_1687).map(class_1937::method_8621);
    }

    @Override
    public void startSelectingInfluencePosition() {
        this.isSelectingInfluencePosition = true;
    }

    @Override
    public void cancelSelectingInfluencePosition() {
        super.reset();
        this.isSelectingInfluencePosition = false;
        this.influencePosStateHolder.reset();
    }

    @Override
    public void sync(List<class_2338> positions) {
        this.clientFortressBorderHolder.syncInfluencePositions(positions);
    }

    @Override
    public void selectInfluencePosition() {
        this.isSelectingInfluencePosition = false;
        class_2338 pos = this.getStructureBuildPos();
        if (pos != null) {
            String stageMessage;
            IStructureBlockData blockData = this.blockDataProvider.getBlockData(INFLUENCE_FLAG_METADATA.getId(), class_2470.field_11467);
            IClientFortressManager fortressClientManager = ModUtils.getFortressClientManager();
            switch (this.influencePosStateHolder.getWorldBorderStage()) {
                case field_12753: {
                    String string = "This influence point is already captured!";
                    break;
                }
                case field_12756: {
                    String string = "This influence point is too farm away from your fortress!";
                    break;
                }
                default: {
                    String string = stageMessage = null;
                }
            }
            if (stageMessage != null) {
                class_2561 message = class_2561.method_30163((String)stageMessage);
                class_310.method_1551().field_1705.method_1743().method_1812(message);
                super.reset();
                return;
            }
            if (!this.isEnoughResources()) {
                String msg = "You don't have the required items to capture this influence point!";
                class_2561 message = class_2561.method_30163((String)"You don't have the required items to capture this influence point!");
                class_310.method_1551().field_1705.method_1743().method_1812(message);
                super.reset();
                return;
            }
            boolean hasAnyWarrior = ClientInfluenceManager.isHasAnyWarrior(fortressClientManager);
            if (!hasAnyWarrior) {
                class_2561 message = class_2561.method_30163((String)"You don't have any warriors to  capture this influence point!");
                class_310.method_1551().field_1705.method_1743().method_1812(message);
                super.reset();
                return;
            }
            this.sendCaptureTaskPacket(pos, blockData);
        }
        this.influencePosStateHolder.reset();
    }

    private static boolean isHasAnyWarrior(IClientFortressManager clientFortressManager) {
        IClientProfessionManager professionManager = clientFortressManager.getProfessionManager();
        List<String> warriorIds = ProfessionsHireTypes.WARRIORS.getIds();
        boolean hasAnyWarrior = false;
        for (String warriorId : warriorIds) {
            if (hasAnyWarrior) break;
            hasAnyWarrior = professionManager.hasProfession(warriorId);
        }
        return hasAnyWarrior;
    }

    @Override
    public void sendCaptureTaskPacket(class_2338 pos, IStructureBlockData blockData) {
        UUID taskId = UUID.randomUUID();
        ModUtils.getClientTasksHolder().ifPresent(it -> {
            List<class_2338> blocks = blockData.getLayer(BlueprintDataLayer.GENERAL).entrySet().stream().filter(e -> e.getValue() != null && !((class_2680)e.getValue()).method_26215()).map(Map.Entry::getKey).filter(Objects::nonNull).map(class_2338::method_10062).map(p -> p.method_10081((class_2382)pos)).toList();
            it.addTask(taskId, blocks);
        });
        C2SCaptureInfluencePositionPacket packet = new C2SCaptureInfluencePositionPacket(taskId, pos);
        FortressClientNetworkHelper.send("capture_influence_position", packet);
        this.reset();
    }

    @Override
    public IBlockDataProvider getBlockDataProvider() {
        return this.blockDataProvider;
    }

    @Override
    public boolean isSelecting() {
        return this.isSelectingInfluencePosition;
    }

    @Override
    public IBlueprintMetadata getSelectedStructure() {
        return INFLUENCE_FLAG_METADATA;
    }

    @Override
    public boolean canBuild() {
        return this.getInfluencePosStateHolder().getWorldBorderStage() != class_2789.field_12756 && super.canBuild();
    }

    @Override
    public IInfluencePosStateHolder getInfluencePosStateHolder() {
        return this.influencePosStateHolder;
    }

    public static class InfluencePosStateHolder
    implements IInfluencePosStateHolder {
        private class_2789 worldBorderStage = class_2789.field_12753;
        private class_2338 lastPos = null;

        @Override
        public void syncNewPos(class_2338 newPos) {
            if (newPos == null) {
                this.setCorrect(class_2789.field_12753);
                this.lastPos = null;
                return;
            }
            class_2338 alignedPos = BaseFortressBorderHolder.alignToAGrid(newPos);
            if (Objects.equals(this.lastPos, alignedPos)) {
                return;
            }
            C2SUpdateNewInfluencePosition packet = new C2SUpdateNewInfluencePosition(alignedPos);
            FortressClientNetworkHelper.send("update_new_influence_position", packet);
            this.lastPos = alignedPos;
        }

        @Override
        public void setCorrect(class_2789 state) {
            this.worldBorderStage = state;
        }

        @Override
        public class_2789 getWorldBorderStage() {
            return this.worldBorderStage;
        }

        @Override
        public void reset() {
            this.worldBorderStage = class_2789.field_12753;
            this.lastPos = null;
        }
    }
}

