/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fight.influence;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import org.jetbrains.annotations.NotNull;
import org.minefortress.fight.influence.BaseFortressBorderHolder;
import org.minefortress.fight.influence.ClientInfluenceManager;
import org.minefortress.fortress.FortressBorder;
import org.minefortress.utils.ModUtils;

public class ClientFortressBorderHolder
extends BaseFortressBorderHolder {
    private final ClientInfluenceManager clientInfluenceManager;
    private final List<class_2338> allInfluencePositions = new ArrayList<class_2338>();
    private class_2784 fortressBorder;

    public ClientFortressBorderHolder(ClientInfluenceManager clientInfluenceManager) {
        this.clientInfluenceManager = clientInfluenceManager;
    }

    public void syncInfluencePositions(List<class_2338> positions) {
        this.allInfluencePositions.clear();
        this.allInfluencePositions.addAll(positions);
        this.rebuildFortressBorder();
    }

    public Optional<class_2784> getFortressBorder() {
        IClientFortressManager fortressClientManager = ModUtils.getFortressClientManager();
        if (fortressClientManager.isCenterNotSet()) {
            class_2338 posAppropriateForCenter = fortressClientManager.getPosAppropriateForCenter();
            if (posAppropriateForCenter == null) {
                return Optional.empty();
            }
            return ClientFortressBorderHolder.getWorldBorder(Collections.singletonList(posAppropriateForCenter), true);
        }
        boolean selecting = this.clientInfluenceManager.isSelecting();
        if (selecting) {
            return this.clientInfluenceManager.getStructureRenderPos().flatMap(it -> ClientFortressBorderHolder.getWorldBorder(Collections.singletonList(it), true));
        }
        return Optional.ofNullable(this.fortressBorder);
    }

    private void rebuildFortressBorder() {
        ArrayList<class_2338> positionsForBorder = new ArrayList<class_2338>(this.allInfluencePositions);
        this.fortressBorder = ClientFortressBorderHolder.getWorldBorder(positionsForBorder).orElse(null);
    }

    @NotNull
    private static Optional<class_2784> getWorldBorder(List<class_2338> pos) {
        return ClientFortressBorderHolder.getWorldBorder(pos, false);
    }

    @NotNull
    private static Optional<class_2784> getWorldBorder(List<class_2338> positions, boolean dynamicState) {
        if (positions != null && !positions.isEmpty()) {
            ArrayDeque<class_2338> posQueue = new ArrayDeque<class_2338>(positions);
            class_2338 mainPos = posQueue.poll();
            if (mainPos == null) {
                return Optional.empty();
            }
            FortressBorder border = new FortressBorder();
            ClientFortressBorderHolder.createBorder(border, mainPos);
            if (dynamicState) {
                border.enableDynamicStage();
            }
            posQueue.forEach(pos -> border.addAdditionalBorder(ClientFortressBorderHolder.createBorder(pos)));
            return Optional.of(border);
        }
        return Optional.empty();
    }

    private static class_2784 createBorder(class_2338 center) {
        class_2784 border = new class_2784();
        ClientFortressBorderHolder.createBorder(border, center);
        return border;
    }

    private static void createBorder(class_2784 border, class_2338 center) {
        class_2338 adjustedPos = ClientFortressBorderHolder.alignToAGrid(center);
        border.method_11978((double)adjustedPos.method_10263(), (double)adjustedPos.method_10260());
        border.method_11969(64.0);
    }
}

