/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.fight;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.remmintan.mods.minefortress.core.dtos.combat.MousePos;
import net.remmintan.mods.minefortress.core.interfaces.combat.IClientFightSelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IFortressAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.ITargetedPawn;
import org.jetbrains.annotations.Nullable;
import org.minefortress.registries.FortressEntities;
import org.minefortress.utils.ModUtils;

public class ClientFightSelectionManager
implements IClientFightSelectionManager {
    private MousePos selectionStartPos;
    private class_243 selectionStartBlock;
    private MousePos selectionCurPos;
    private class_243 selectionCurBlock;
    private final List<ITargetedPawn> selectedPawns = new ArrayList<ITargetedPawn>();
    private class_243 cachedBlockPos;

    @Override
    public void startSelection(double x, double y, class_243 startBlock) {
        this.resetSelection();
        this.selectionStartPos = new MousePos(x, y);
        this.selectionStartBlock = startBlock;
    }

    @Override
    public void endSelection() {
        this.selectionStartBlock = null;
        this.selectionStartPos = null;
        this.selectionCurBlock = null;
        this.selectionCurPos = null;
        if (!this.hasSelected()) {
            class_2561 message = class_2561.method_30163((String)"Only warriors and archers can be selected and controlled directly.");
            class_310.method_1551().field_1705.method_1743().method_1812(message);
        }
    }

    @Override
    public boolean hasSelected() {
        return !this.selectedPawns.isEmpty();
    }

    @Override
    public void updateSelection(class_312 mouse, class_3965 target) {
        class_243 pos = target.method_17784();
        this.updateSelection(mouse.method_1603(), mouse.method_1604(), pos);
    }

    @Override
    public void updateSelection(double x, double y, @Nullable class_243 endBlock) {
        if (endBlock == null) {
            return;
        }
        if (!this.isSelectionStarted()) {
            return;
        }
        this.selectionCurPos = new MousePos(x, y);
        this.selectionCurBlock = endBlock;
        if (!this.selectionCurBlock.equals((Object)this.cachedBlockPos)) {
            this.selectedPawns.clear();
            this.selectPawnsByType(FortressEntities.WARRIOR_PAWN_ENTITY_TYPE);
            this.selectPawnsByType(FortressEntities.ARCHER_PAWN_ENTITY_TYPE);
            this.cachedBlockPos = this.selectionCurBlock;
        }
    }

    private void selectPawnsByType(class_1299<? extends ITargetedPawn> type) {
        class_238 selectionBox = new class_238(this.selectionStartBlock.method_10216(), -64.0, this.selectionStartBlock.method_10215(), this.selectionCurBlock.method_10216(), 256.0, this.selectionCurBlock.method_10215());
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            UUID playerId = ModUtils.getCurrentPlayerUUID();
            List<ITargetedPawn> selectedPawns1 = world.method_18023(type, selectionBox, it -> ((IFortressAwareEntity)it).getMasterId().map(playerId::equals).orElse(false)).stream().map(arg_0 -> ClientFightSelectionManager.lambda$selectPawnsByType$1(ITargetedPawn.class, arg_0)).toList();
            this.selectedPawns.addAll(selectedPawns1);
        }
    }

    @Override
    public void resetSelection() {
        this.selectionStartPos = null;
        this.selectionStartBlock = null;
        this.selectionCurPos = null;
        this.selectionCurBlock = null;
        this.selectedPawns.clear();
    }

    @Override
    public boolean isSelecting() {
        return this.selectionStartPos != null && this.selectionStartBlock != null && this.selectionCurPos != null && this.selectionCurBlock != null;
    }

    @Override
    public boolean isSelectionStarted() {
        return this.selectionStartPos != null && this.selectionStartBlock != null;
    }

    @Override
    public void forEachSelected(Consumer<ITargetedPawn> action) {
        this.selectedPawns.forEach(action);
    }

    @Override
    public MousePos getSelectionStartPos() {
        return this.selectionStartPos;
    }

    @Override
    public MousePos getSelectionCurPos() {
        return this.selectionCurPos;
    }

    @Override
    public boolean isSelected(ITargetedPawn colonist) {
        return this.selectedPawns.contains(colonist);
    }

    private static /* synthetic */ ITargetedPawn lambda$selectPawnsByType$1(Class rec$, Object x$0) {
        return (ITargetedPawn)rec$.cast(x$0);
    }
}

