/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.renderer;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1934;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_636;
import net.minecraft.class_761;
import net.minecraft.class_909;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.ITargetedPawn;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.minefortress.MineFortressMod;
import org.minefortress.entity.BasePawnEntity;
import org.minefortress.entity.renderer.PawnClothesFeature;
import org.minefortress.entity.renderer.PawnModel;
import org.minefortress.interfaces.IFortressMinecraftClient;

public class PawnRenderer
extends class_909<BasePawnEntity, PawnModel> {
    private static final class_2960 GUY = new class_2960("minefortress", "textures/skins/guy.png");
    private static final class_2960 GUY2 = new class_2960("minefortress", "textures/skins/guy2.png");
    private static final class_2960 GUY3 = new class_2960("minefortress", "textures/skins/guy3.png");
    private static final class_2960 GUY4 = new class_2960("minefortress", "textures/skins/guy4.png");

    public PawnRenderer(class_5617.class_5618 context) {
        super(context, (class_572)new PawnModel(context), 0.5f);
        this.method_4046(new PawnClothesFeature((class_3883<BasePawnEntity, PawnModel>)this));
    }

    public class_2960 getTexture(BasePawnEntity pawn) {
        int bodyTextureId = pawn.getBodyTextureId();
        return switch (bodyTextureId) {
            case 0 -> GUY;
            case 1 -> GUY2;
            case 2 -> GUY3;
            default -> GUY4;
        };
    }

    protected boolean hasLabel(BasePawnEntity colonist) {
        return colonist.method_16914();
    }

    public void render(BasePawnEntity pawn, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        this.setClothesVilibility((class_1308)pawn);
        super.method_4072((class_1308)pawn, f, g, matrixStack, vertexConsumerProvider, i);
        class_310 client = this.getClient();
        class_1934 currentGamemode = Optional.ofNullable(client.field_1761).map(class_636::method_2920).orElse(class_1934.field_28045);
        if (currentGamemode == MineFortressMod.FORTRESS) {
            class_3966 entityHitResult;
            class_239 class_2392 = client.field_1765;
            boolean hovering = class_2392 instanceof class_3966 && (entityHitResult = (class_3966)class_2392).method_17782() == pawn;
            boolean fightSelecting = this.selectedAsTargeted(pawn);
            boolean selecting = this.getFortressClientManager().getSelectedPawn() == pawn;
            Vector3f color = this.getHealthFoodLevelColor(pawn);
            if (hovering || selecting || color != null || fightSelecting) {
                class_4588 buffer = vertexConsumerProvider.getBuffer(class_1921.method_23594());
                if (color != null && !hovering && !fightSelecting) {
                    color.mul(0.7f);
                }
                if (color == null) {
                    color = new Vector3f(selecting ? 0.7f : 0.0f, selecting ? 0.7f : 1.0f, selecting ? 0.7f : 0.0f);
                    if (fightSelecting) {
                        color = new Vector3f(0.0f, 1.0f, 0.0f);
                    }
                }
                PawnRenderer.renderRhombus(matrixStack, buffer, (class_1297)pawn, color);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean selectedAsTargeted(BasePawnEntity pawn) {
        if (!(pawn instanceof ITargetedPawn)) return false;
        ITargetedPawn tp = (ITargetedPawn)((Object)pawn);
        if (!this.getFortressClientManager().getFightManager().getSelectionManager().isSelected(tp)) return false;
        return true;
    }

    private float getHealthFoodLevel(BasePawnEntity colonist) {
        float health = colonist.method_6032();
        int foodLevel = colonist.getCurrentFoodLevel();
        return Math.min(health, (float)foodLevel);
    }

    @Nullable
    private Vector3f getHealthFoodLevelColor(BasePawnEntity colonist) {
        float healthFoodLevel = this.getHealthFoodLevel(colonist);
        float maxLevelOfEachColor = 255.0f;
        if (healthFoodLevel > 10.0f) {
            return null;
        }
        if (healthFoodLevel <= 10.0f && healthFoodLevel >= 5.0f) {
            float red = 1.0f;
            float green = 0.6666667f;
            float blue = 0.0f;
            return new Vector3f(1.0f, 0.6666667f, 0.0f);
        }
        float red = 1.0f;
        float green = 0.33333334f;
        float blue = 0.33333334f;
        return new Vector3f(1.0f, 0.33333334f, 0.33333334f);
    }

    @Nullable
    protected class_1921 getRenderLayer(BasePawnEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.method_24302((class_1309)entity, showBody, translucent, showOutline);
    }

    private class_310 getClient() {
        return class_310.method_1551();
    }

    private IFortressMinecraftClient getFortressClient() {
        return (IFortressMinecraftClient)this.getClient();
    }

    private IClientManagersProvider getManagersProvider() {
        return (IClientManagersProvider)this.getClient();
    }

    private IClientFortressManager getFortressClientManager() {
        return this.getManagersProvider().get_ClientFortressManager();
    }

    private void setClothesVilibility(class_1308 colonist) {
        class_591 colonistModel = (class_591)this.method_4038();
        colonistModel.field_3394.field_3665 = true;
        colonistModel.field_3483.field_3665 = !colonist.method_6113();
        colonistModel.field_3482.field_3665 = !colonist.method_6113();
        colonistModel.field_3479.field_3665 = !colonist.method_6113();
        colonistModel.field_3484.field_3665 = !colonist.method_6113();
        colonistModel.field_3486.field_3665 = !colonist.method_6113();
    }

    private static void renderRhombus(class_4587 matrices, class_4588 vertices, class_1297 entity, Vector3f color) {
        class_238 box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
        if (entity instanceof class_1309) {
            matrices.method_22903();
            double xCenter = (box.field_1323 + box.field_1320) / 2.0;
            double zCenter = (box.field_1321 + box.field_1324) / 2.0;
            matrices.method_22904(xCenter, box.field_1325 * 1.5, zCenter);
            float radians = (float)Math.toRadians(45.0);
            Quaternionf xRotation = new Quaternionf().set(new AxisAngle4f(radians, 1.0f, 0.0f, 0.0f));
            Quaternionf yRoation = new Quaternionf().set(new AxisAngle4f(radians, 0.0f, 1.0f, 0.0f));
            matrices.method_22907(xRotation);
            matrices.method_22907(yRoation);
            matrices.method_22905(0.3f, 0.3f, 0.3f);
            class_761.method_22980((class_4587)matrices, (class_4588)vertices, (double)-0.5, (double)-0.5, (double)-0.5, (double)0.5, (double)0.5, (double)0.5, (float)color.x(), (float)color.y(), (float)color.z(), (float)1.0f);
            matrices.method_22909();
        }
    }
}

