/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.professions;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationArea;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationBlockInfo;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.professions.ProfessionDailyTask;
import org.minefortress.tasks.block.info.DigTaskBlockInfo;

public class MinerDailyTask
implements ProfessionDailyTask {
    private long stopTime = 0L;
    private IAutomationArea currentMine;
    private Iterator<IAutomationBlockInfo> mineIterator;
    private IAutomationBlockInfo goal;

    @Override
    public boolean canStart(Colonist colonist) {
        return colonist.method_37908().method_8530() && this.isEnoughTimeSinceLastTimePassed(colonist);
    }

    @Override
    public void start(Colonist colonist) {
        colonist.resetControls();
        colonist.setCurrentTaskDesc("Mining");
        this.getMine(colonist).ifPresent(m -> {
            this.currentMine = m;
        });
        this.initIterator(colonist);
    }

    @Override
    public void tick(Colonist colonist) {
        if (this.currentMine == null) {
            return;
        }
        MovementHelper movementHelper = colonist.getMovementHelper();
        if (this.goal == null) {
            if (!this.mineIterator.hasNext()) {
                return;
            }
            this.goal = this.mineIterator.next();
        }
        if (this.goal != null && movementHelper.getWorkGoal() == null) {
            movementHelper.goTo(this.goal.pos().method_10084(), 0.15f);
        }
        if (movementHelper.hasReachedWorkGoal() && colonist.getPlaceControl().isDone() && colonist.getDigControl().isDone()) {
            this.doActionWithTheGoal(colonist);
        }
        if (movementHelper.getWorkGoal() != null && !movementHelper.hasReachedWorkGoal() && movementHelper.isStuck()) {
            class_2338 workGoal = movementHelper.getWorkGoal().method_10084();
            colonist.method_20620((double)workGoal.method_10263() + 0.5, workGoal.method_10264(), (double)workGoal.method_10260() + 0.5);
        }
    }

    private void doActionWithTheGoal(Colonist colonist) {
        class_2680 blockState = colonist.method_37908().method_8320(this.goal.pos());
        if (blockState.method_26215() || blockState.method_26227().method_15767(class_3486.field_15517)) {
            colonist.getMovementHelper().reset();
            this.goal = null;
        } else {
            colonist.setGoal(new DigTaskBlockInfo(this.goal.pos()));
        }
    }

    @Override
    public void stop(Colonist colonist) {
        this.currentMine = null;
        this.mineIterator = Collections.emptyIterator();
        this.stopTime = colonist.method_37908().method_8510();
        this.goal = null;
        colonist.resetControls();
    }

    @Override
    public boolean shouldContinue(Colonist colonist) {
        return colonist.method_37908().method_8530() && (this.mineIterator.hasNext() || this.goal != null);
    }

    private void initIterator(Colonist colonist) {
        if (this.currentMine == null) {
            this.mineIterator = Collections.emptyIterator();
        } else {
            this.currentMine.update();
            this.mineIterator = this.currentMine.iterator(colonist.method_37908());
        }
    }

    private Optional<IAutomationArea> getMine(Colonist colonist) {
        return colonist.getServerFortressManager().flatMap(it -> it.getAutomationAreaByRequirementId("miner"));
    }

    private boolean isEnoughTimeSinceLastTimePassed(Colonist colonist) {
        return colonist.method_37908().method_8510() - 100L >= this.stopTime;
    }
}

