/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.professions;

import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.professions.ProfessionDailyTask;
import org.minefortress.professions.ProfessionManager;

public class ForesterDailyTask
implements ProfessionDailyTask {
    private class_2338 goal;
    private int workingTicks;
    private int interactionsCount = 0;
    private long stopTime = 0L;

    @Override
    public boolean canStart(Colonist colonist) {
        return colonist.method_37908().method_8530() && colonist.method_37908().method_8510() - this.stopTime > 400L;
    }

    @Override
    public void start(Colonist colonist) {
        colonist.setCurrentTaskDesc("Looking for food");
        this.setGoal(colonist);
        colonist.getMovementHelper().goTo(this.goal, 0.15f);
    }

    @Override
    public void tick(Colonist colonist) {
        if (this.goal == null) {
            return;
        }
        MovementHelper movementHelper = colonist.getMovementHelper();
        if (movementHelper.hasReachedWorkGoal()) {
            if ((float)(this.workingTicks % 10) * colonist.getHungerMultiplier() == 0.0f) {
                colonist.method_6104(colonist.method_37908().field_9229.method_43057() < 0.5f ? class_1268.field_5808 : class_1268.field_5810);
                colonist.putItemInHand(class_1802.field_8167);
                colonist.addHunger(0.0035f);
                ++this.interactionsCount;
                this.gatherItemAndAddToInventory(colonist);
                if (this.interactionsCount > 2) {
                    this.setGoal(colonist);
                    colonist.getMovementHelper().goTo(this.goal, 0.15f);
                    this.interactionsCount = 0;
                }
            }
            colonist.lookAt(this.goal);
            ++this.workingTicks;
        }
        if (!movementHelper.hasReachedWorkGoal() && movementHelper.isStuck()) {
            colonist.method_20620(this.goal.method_10263(), this.goal.method_10264(), this.goal.method_10260());
        }
    }

    @Override
    public void stop(Colonist colonist) {
        this.workingTicks = 0;
        this.interactionsCount = 0;
        this.stopTime = colonist.method_37908().method_8510();
    }

    @Override
    public boolean shouldContinue(Colonist colonist) {
        return this.goal != null && this.workingTicks < 200;
    }

    private void gatherItemAndAddToInventory(Colonist colonist) {
        if (this.isSuccess(colonist)) {
            class_1792 item = this.getRandomForesterItem(colonist);
            colonist.getManagersProvider().ifPresent(it -> it.getResourceManager().increaseItemAmount(item, 1));
        }
    }

    private class_1792 getRandomForesterItem(Colonist colonist) {
        class_5819 random = colonist.method_37908().field_9229;
        return ProfessionManager.FORESTER_ITEMS.get(random.method_43048(ProfessionManager.FORESTER_ITEMS.size()));
    }

    private boolean isSuccess(Colonist colonist) {
        class_5819 random = colonist.method_37908().field_9229;
        return random.method_43048(100) < 18;
    }

    private void setGoal(Colonist colonist) {
        class_1937 world = colonist.method_37908();
        class_2338 fortressCenter = colonist.getServerFortressManager().map(IServerFortressManager::getFortressCenter).orElseThrow(() -> new IllegalStateException("No fortress center found"));
        int horizontalRange = 10;
        class_2338 randPointAroundCenter = (class_2338)class_2338.method_34848((class_5819)world.field_9229, (int)1, (class_2338)fortressCenter, (int)10).iterator().next();
        this.goal = (class_2338)class_2338.method_25997((class_2338)randPointAroundCenter, (int)10, (int)10, pos -> world.method_8320(pos).method_27852(class_2246.field_10479) || world.method_8320(pos).method_27852(class_2246.field_10214)).or(() -> class_2338.method_25997((class_2338)randPointAroundCenter, (int)10, (int)10, pos -> world.method_8320(pos).method_27852(class_2246.field_10219))).or(() -> class_2338.method_25997((class_2338)randPointAroundCenter, (int)10, (int)10, pos -> BuildingHelper.canStayOnBlock((class_1936)world, pos)).map(class_2338::method_10084)).orElseThrow(() -> new IllegalStateException("No block found for forester"));
    }
}

