/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.professions;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_5712;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.AutomationActionType;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationArea;
import net.remmintan.mods.minefortress.core.interfaces.automation.area.IAutomationBlockInfo;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.professions.ProfessionDailyTask;
import org.minefortress.fortress.automation.iterators.FarmAreaIterator;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.tasks.block.info.BlockStateTaskBlockInfo;
import org.minefortress.tasks.block.info.DigTaskBlockInfo;
import org.spongepowered.include.com.google.common.collect.Sets;

public class FarmerDailyTask
implements ProfessionDailyTask {
    private static final Set<class_1792> FARMER_SEEDS = Sets.newHashSet((Object[])new class_1792[]{class_1802.field_8317, class_1802.field_8309, class_1802.field_8179, class_1802.field_8567, class_1802.field_8706, class_1802.field_8188});
    private IAutomationArea currentFarm;
    private Iterator<IAutomationBlockInfo> farmIterator;
    private IAutomationBlockInfo goal;
    private long stopTime = 0L;

    @Override
    public boolean canStart(Colonist colonist) {
        return colonist.method_37908().method_8530() && this.isEnoughTimeSinceLastTimePassed(colonist);
    }

    @Override
    public void start(Colonist colonist) {
        colonist.resetControls();
        colonist.setCurrentTaskDesc("Farming");
        this.getFarm(colonist).ifPresent(f -> {
            this.currentFarm = f;
        });
        this.initIterator(colonist);
        colonist.getBaritone().settings().allowParkour.set((Object)false);
    }

    @Override
    public void tick(Colonist colonist) {
        if (this.currentFarm == null) {
            return;
        }
        MovementHelper movementHelper = colonist.getMovementHelper();
        if (this.goal == null) {
            do {
                if (!this.farmIterator.hasNext()) {
                    return;
                }
                this.goal = this.farmIterator.next();
            } while (this.goalAlreadyInCorrectState(colonist));
            movementHelper.goTo(this.goal.pos().method_10084(), 0.15f);
        }
        if (this.goal != null && movementHelper.getWorkGoal() == null) {
            movementHelper.goTo(this.goal.pos().method_10084(), 0.15f);
        }
        if (movementHelper.hasReachedWorkGoal() && colonist.getPlaceControl().isDone() && colonist.getDigControl().isDone()) {
            switch (this.goal.info()) {
                case FARM_CROPS: {
                    this.doFarmCrops(colonist);
                    break;
                }
                case FARM_WATER: {
                    this.doSetWater(colonist);
                }
            }
        }
        if (movementHelper.getWorkGoal() != null && !movementHelper.hasReachedWorkGoal() && movementHelper.isStuck()) {
            class_2338 workGoal = movementHelper.getWorkGoal().method_10084();
            colonist.method_20620(workGoal.method_10263(), workGoal.method_10264(), workGoal.method_10260());
        }
    }

    private void doFarmCrops(Colonist colonist) {
        MovementHelper movementHelper = colonist.getMovementHelper();
        class_2680 goalBlockState = colonist.method_37908().method_8320(this.goal.pos());
        class_2338 aboveBlockPos = this.goal.pos().method_10084();
        class_2680 aboveBlockState = colonist.method_37908().method_8320(aboveBlockPos);
        if (goalBlockState.method_27852(class_2246.field_10566) || goalBlockState.method_27852(class_2246.field_10219)) {
            if (FarmAreaIterator.blockCanBeRemovedToPlantCrops(aboveBlockState)) {
                colonist.setGoal(new DigTaskBlockInfo(aboveBlockPos));
            } else {
                colonist.putItemInHand(class_1802.field_8167);
                colonist.method_6104(class_1268.field_5808);
                colonist.method_37908().method_8652(this.goal.pos(), class_2246.field_10362.method_9564(), 3);
                colonist.method_37908().method_33596((class_1297)colonist, class_5712.field_28164, this.goal.pos());
            }
        } else if (goalBlockState.method_27852(class_2246.field_10362)) {
            class_2248 class_22482;
            if (aboveBlockState.method_26164(class_3481.field_20341) && (class_22482 = aboveBlockState.method_26204()) instanceof class_2302) {
                class_2302 cropBlock = (class_2302)class_22482;
                if (cropBlock.method_9829(aboveBlockState) == cropBlock.method_9827()) {
                    DigTaskBlockInfo digTaskBlockInfo = new DigTaskBlockInfo(aboveBlockPos);
                    colonist.setGoal(digTaskBlockInfo);
                } else {
                    this.goal = null;
                }
            } else if (aboveBlockState.method_26215()) {
                Optional<class_1747> seedsOpt = this.getSeeds(colonist);
                if (seedsOpt.isPresent()) {
                    class_1747 blockItem = seedsOpt.get();
                    BlockStateTaskBlockInfo bsTaskBlockInfo = new BlockStateTaskBlockInfo((class_1792)blockItem, aboveBlockPos, blockItem.method_7711().method_9564());
                    colonist.setGoal(bsTaskBlockInfo);
                    movementHelper.goTo(aboveBlockPos, 0.15f);
                } else {
                    this.goal = null;
                }
            } else if (FarmAreaIterator.blockCanBeRemovedToPlantCrops(aboveBlockState)) {
                colonist.setGoal(new DigTaskBlockInfo(aboveBlockPos));
            } else {
                this.goal = null;
            }
        } else {
            this.goal = null;
        }
    }

    private void doSetWater(Colonist colonist) {
        class_2680 goalBlockState = colonist.method_37908().method_8320(this.goal.pos());
        if (goalBlockState.method_26164(class_3481.field_33716)) {
            colonist.setGoal(new DigTaskBlockInfo(this.goal.pos()));
        } else if (goalBlockState.method_26215()) {
            colonist.putItemInHand(class_1802.field_8705);
            colonist.method_6104(class_1268.field_5808);
            colonist.method_37908().method_8652(this.goal.pos(), class_2246.field_10382.method_9564(), 3);
            colonist.method_37908().method_33596((class_1297)colonist, class_5712.field_28164, this.goal.pos());
        } else {
            this.goal = null;
        }
    }

    private boolean goalAlreadyInCorrectState(Colonist colonist) {
        class_2680 goalBlockState = colonist.method_37908().method_8320(this.goal.pos());
        class_2338 abovePos = this.goal.pos().method_10084();
        class_2680 aboveBlockState = colonist.method_37908().method_8320(abovePos);
        if (this.goal.info() == AutomationActionType.FARM_CROPS) {
            class_2302 crops;
            class_2248 class_22482;
            return goalBlockState.method_27852(class_2246.field_10362) && aboveBlockState.method_26164(class_3481.field_20341) && (class_22482 = aboveBlockState.method_26204()) instanceof class_2302 && (crops = (class_2302)class_22482).method_9829(aboveBlockState) < crops.method_9827();
        }
        if (this.goal.info() == AutomationActionType.FARM_WATER) {
            return goalBlockState.method_26227().method_15767(class_3486.field_15517);
        }
        return false;
    }

    @Override
    public void stop(Colonist colonist) {
        this.currentFarm = null;
        this.farmIterator = Collections.emptyIterator();
        this.stopTime = colonist.method_37908().method_8510();
        colonist.resetControls();
    }

    @Override
    public boolean shouldContinue(Colonist colonist) {
        return colonist.method_37908().method_8530() && (this.farmIterator.hasNext() || this.goal != null);
    }

    private Optional<IAutomationArea> getFarm(Colonist colonist) {
        return colonist.getServerFortressManager().flatMap(it -> it.getAutomationAreaByRequirementId("farmer"));
    }

    private boolean isEnoughTimeSinceLastTimePassed(Colonist colonist) {
        return colonist.method_37908().method_8510() - this.stopTime > 100L;
    }

    private void initIterator(Colonist pawn) {
        if (this.currentFarm == null) {
            this.farmIterator = Collections.emptyIterator();
        } else {
            this.currentFarm.update();
            this.farmIterator = this.currentFarm.iterator(pawn.method_37908());
        }
    }

    private Optional<class_1747> getSeeds(Colonist colonist) {
        if (FarmerDailyTask.isCreative(colonist)) {
            return Optional.of((class_1747)class_1802.field_8317);
        }
        IServerResourceManager serverResourceManager = ((IServerManagersProvider)colonist.getManagersProvider().orElseThrow()).getResourceManager();
        Optional<class_1792> itemOpt = serverResourceManager.getAllItems().stream().filter(it -> !it.method_7960()).map(class_1799::method_7909).filter(FARMER_SEEDS::contains).min(Comparator.comparingInt(it -> {
            if (it == class_1802.field_8317) {
                return 0;
            }
            if (it == class_1802.field_8567) {
                return 1;
            }
            if (it == class_1802.field_8179) {
                return 2;
            }
            return 3;
        }));
        itemOpt.ifPresent(it -> serverResourceManager.removeItems(Collections.singletonList(new ItemInfo((class_1792)it, 1))));
        return itemOpt.map(it -> (class_1747)it);
    }

    private static boolean isCreative(Colonist colonist) {
        return colonist.getServerFortressManager().map(IServerFortressManager::isCreative).orElse(false);
    }
}

