/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.professions;

import net.minecraft.class_2246;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.professions.AbstractStayNearBlockDailyTask;
import org.minefortress.fortress.resources.gui.craft.FortressCraftingScreenHandler;

public class CrafterDailyTask
extends AbstractStayNearBlockDailyTask {
    private int ticksAfterTableClose = 0;

    @Override
    public boolean canStart(Colonist colonist) {
        return this.craftingTableMenuOpened(colonist);
    }

    @Override
    public void start(Colonist colonist) {
        colonist.setCurrentTaskDesc("Crafting");
        super.start(colonist);
    }

    @Override
    public void tick(Colonist colonist) {
        super.tick(colonist);
        this.ticksAfterTableClose = this.craftingTableMenuOpened(colonist) ? 400 : --this.ticksAfterTableClose;
    }

    @Override
    public boolean shouldContinue(Colonist colonist) {
        return super.shouldContinue(colonist) && this.ticksAfterTableClose > 0 || this.craftingTableMenuOpened(colonist);
    }

    @Override
    public void stop(Colonist colonist) {
        super.stop(colonist);
        this.ticksAfterTableClose = 0;
    }

    @Override
    @Nullable
    protected class_2338 getBlockPos(Colonist colonist) {
        return colonist.getServerFortressManager().map(it -> it.getSpecialBlocksByType(class_2246.field_9980, true).stream().findFirst().orElseGet(() -> it.getSpecialBlocksByType(class_2246.field_9980, false).stream().findFirst().orElse(null))).orElse(null);
    }

    private boolean craftingTableMenuOpened(Colonist colonsit) {
        return colonsit.isScreenOpen(FortressCraftingScreenHandler.class);
    }
}

