/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.professions;

import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.professions.ProfessionDailyTask;

abstract class AbstractStayNearBlockDailyTask
implements ProfessionDailyTask {
    private class_2338 blockPos;
    private int workingTicks;

    AbstractStayNearBlockDailyTask() {
    }

    @Override
    public boolean canStart(Colonist colonist) {
        return colonist.method_37908().method_8530();
    }

    @Override
    public void start(Colonist colonist) {
        this.setupTablePos(colonist);
        colonist.getMovementHelper().goTo(this.blockPos, 0.15f);
    }

    @Override
    public void tick(Colonist colonist) {
        if (this.blockPos == null) {
            return;
        }
        MovementHelper movementHelper = colonist.getMovementHelper();
        if (movementHelper.hasReachedWorkGoal()) {
            if ((float)(this.workingTicks % 10) * colonist.getHungerMultiplier() == 0.0f) {
                colonist.method_6104(colonist.method_37908().field_9229.method_43057() < 0.5f ? class_1268.field_5808 : class_1268.field_5810);
                colonist.putItemInHand(this.getWorkingItem());
                colonist.addHunger(0.0035f);
            }
            colonist.lookAt(this.blockPos);
            ++this.workingTicks;
        }
        if (!movementHelper.hasReachedWorkGoal() && movementHelper.isStuck()) {
            colonist.method_20620(this.blockPos.method_10263(), this.blockPos.method_10264(), this.blockPos.method_10260());
        }
    }

    protected class_1792 getWorkingItem() {
        return class_1802.field_8600;
    }

    @Override
    public void stop(Colonist colonist) {
        this.blockPos = null;
        this.workingTicks = 0;
        colonist.getMovementHelper().reset();
    }

    @Override
    public boolean shouldContinue(Colonist colonist) {
        return this.blockPos != null && colonist.method_37908().method_8530();
    }

    private void setupTablePos(Colonist colonist) {
        class_2338 blockPos = this.getBlockPos(colonist);
        if (blockPos == null) {
            return;
        }
        this.blockPos = blockPos;
    }

    protected abstract class_2338 getBlockPos(Colonist var1);
}

