/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.goal.warrior;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.IBaritoneMoveControl;
import net.remmintan.mods.minefortress.core.interfaces.infuence.ICaptureTask;
import net.remmintan.mods.minefortress.core.interfaces.infuence.IServerInfluenceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.WarriorPawn;

public class CapturePositionGoal
extends class_1352 {
    private final WarriorPawn pawn;
    @Nullable
    private ICaptureTask target;

    public CapturePositionGoal(WarriorPawn pawn) {
        this.pawn = pawn;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        Optional fsmOpt = this.pawn.getManagersProvider();
        if (fsmOpt.isEmpty()) {
            return false;
        }
        IServerManagersProvider fsm = (IServerManagersProvider)fsmOpt.get();
        IServerInfluenceManager influenceManager = fsm.getInfluenceManager();
        this.target = influenceManager.getCaptureTask();
        return this.target != null;
    }

    public void method_6269() {
        if (this.target == null) {
            return;
        }
        this.pawn.resetTargets();
        IBaritoneMoveControl moveControl = this.pawn.getFortressMoveControl();
        moveControl.moveTo(this.target.pos());
    }

    public void method_6268() {
        if (this.target == null) {
            return;
        }
        IBaritoneMoveControl moveControl = this.pawn.getFortressMoveControl();
        if (moveControl.isStuck()) {
            this.teleportToGoal(moveControl);
        }
        if (this.hasReachedTarget()) {
            this.finish();
        }
    }

    private void teleportToGoal(IBaritoneMoveControl moveControl) {
        if (this.target == null) {
            return;
        }
        moveControl.reset();
        class_2338 pos = this.target.pos();
        this.pawn.method_20620(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
    }

    private void finish() {
        if (this.target == null) {
            return;
        }
        this.pawn.getManagersProvider().ifPresent(it -> {
            IServerResourceManager resourceManager = it.getResourceManager();
            IServerInfluenceManager influenceManager = it.getInfluenceManager();
            IBlockDataProvider flagDataProvider = influenceManager.getBlockDataProvider();
            IStructureBlockData influenceFlag = flagDataProvider.getBlockData("influence_flag", class_2470.field_11467);
            class_2338 targetPos = this.target.pos();
            influenceFlag.getLayer(BlueprintDataLayer.GENERAL).forEach((pos, state) -> {
                class_2338 realpos = pos.method_10081((class_2382)targetPos);
                this.pawn.method_37908().method_8652(realpos, state, 3);
                if (this.pawn.getServerFortressManager().map(IServerFortressManager::isSurvival).orElse(false).booleanValue()) {
                    resourceManager.removeReservedItem(this.target.taskId(), state.method_26204().method_8389());
                }
            });
            influenceManager.addInfluencePosition(this.target.pos());
        });
        this.pawn.getMasterPlayer().ifPresent(it -> {
            ClientboundTaskExecutedPacket packet = new ClientboundTaskExecutedPacket(this.target.taskId());
            FortressServerNetworkHelper.send(it, "finish_task", packet);
        });
        this.target = null;
    }

    public boolean method_6266() {
        return this.target != null;
    }

    public boolean method_6267() {
        return true;
    }

    public void method_6270() {
        if (this.target != null) {
            this.pawn.getManagersProvider().ifPresent(it -> it.getInfluenceManager().failCaptureTask(this.target));
            this.target = null;
        }
        this.pawn.getFortressMoveControl().reset();
    }

    private boolean hasReachedTarget() {
        return this.target != null && this.target.pos().method_19769((class_2374)this.pawn.method_19538(), this.pawn.getTargetMoveRange() + 1.0);
    }
}

