/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.goal.hostile;

import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_5134;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IFortressBuilding;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressModServerManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;

public final class AttackBuildingGoal
extends class_1352 {
    private static final int ATTACK_DISTANCE = 6;
    private final IFortressModServerManager modServerManager;
    private final class_1588 mob;
    private IFortressBuilding targetBuilding;
    private class_2338 targetPosition;
    private class_11 path;
    private long lastUpdateTime = 0L;
    private int cooldown = 0;

    public AttackBuildingGoal(class_1588 mob, IFortressModServerManager modServerManager) {
        this.mob = mob;
        this.modServerManager = modServerManager;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.lastUpdateTime + 20L > this.mob.method_37908().method_8510()) {
            return false;
        }
        if (!this.mob.method_37908().method_23886()) {
            return false;
        }
        this.lastUpdateTime = this.mob.method_37908().method_8510();
        class_2338 mobBlockPos = this.mob.method_24515();
        this.modServerManager.findReachableFortress(mobBlockPos, this.getFollowRange()).map(IServerManagersProvider::getBuildingsManager).flatMap(it -> it.findNearest(mobBlockPos)).ifPresent(building -> {
            this.targetBuilding = building;
        });
        if (this.targetBuilding != null) {
            this.targetPosition = this.targetBuilding.getNearestCornerXZ(mobBlockPos, this.mob.method_37908());
            this.path = this.mob.method_5942().method_6348(this.targetPosition, 6);
        }
        if (this.path != null) {
            return true;
        }
        this.method_6270();
        return false;
    }

    public void method_6269() {
        this.mob.method_5942().method_6334(this.path, 1.2);
    }

    public void method_6268() {
        class_1408 navigation = this.mob.method_5942();
        if (!navigation.method_23966() && this.didntReachTheTarget()) {
            this.path = navigation.method_6348(this.targetPosition, 6);
            if (this.path != null) {
                navigation.method_6334(this.path, 1.2);
            }
        }
        this.attack();
        --this.cooldown;
    }

    public boolean method_6266() {
        return this.mob.method_37908().method_23886() && this.path != null && this.targetBuilding.getHealth() > 0 && (this.mob.method_6065() == null || !this.mob.method_6065().method_5805());
    }

    public boolean method_6267() {
        return false;
    }

    public void method_6270() {
        this.targetBuilding = null;
        this.targetPosition = null;
        this.path = null;
    }

    private void attack() {
        if (this.targetBuilding == null) {
            return;
        }
        if (this.targetPosition == null) {
            return;
        }
        if (this.didntReachTheTarget()) {
            return;
        }
        this.mob.method_5988().method_6230((double)this.targetPosition.method_10263(), (double)this.targetPosition.method_10264(), (double)this.targetPosition.method_10260(), 30.0f, 30.0f);
        if (this.cooldown <= 0) {
            this.mob.method_6104(class_1268.field_5808);
            this.targetBuilding.attack(this.mob);
            this.cooldown = this.method_38847(20);
        }
    }

    private boolean didntReachTheTarget() {
        return this.targetPosition.method_19770((class_2374)this.mob.method_19538()) > 36.0;
    }

    private double getFollowRange() {
        return this.mob.method_26825(class_5134.field_23717);
    }
}

