/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.goal;

import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.buildings.IServerBuildingsManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import org.jetbrains.annotations.NotNull;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.goal.AbstractFortressGoal;

public class SleepOnTheBedGoal
extends AbstractFortressGoal {
    private class_2338 bedPos;

    public SleepOnTheBedGoal(Colonist colonist) {
        super(colonist);
    }

    public boolean method_6264() {
        if (!this.isNight() || this.colonist.getTaskControl().hasTask()) {
            return false;
        }
        class_1309 target = this.colonist.method_5968();
        if (target != null && target.method_5805()) {
            return false;
        }
        this.getFreeBed().ifPresent(it -> {
            this.bedPos = it;
        });
        return this.bedPos != null;
    }

    public void method_6269() {
        this.colonist.setCurrentTaskDesc("Going to sleep");
        this.moveToBed();
    }

    public void method_6268() {
        if (this.bedPos == null || this.colonist.method_6113()) {
            return;
        }
        MovementHelper movementHelper = this.colonist.getMovementHelper();
        if (movementHelper.stillTryingToReachGoal()) {
            return;
        }
        if (this.hasReachedTheBed()) {
            if (!this.colonist.method_6113() && this.colonist.method_37908().method_8320(this.bedPos).method_26164(class_3481.field_16443)) {
                this.colonist.method_18403(this.bedPos);
                this.colonist.putItemInHand(null);
            }
        } else if (movementHelper.isStuck()) {
            this.colonist.getServerFortressManager().flatMap(IServerFortressManager::getRandomPositionAroundCampfire).ifPresent(it -> {
                class_2338 pos = it.method_10084();
                this.colonist.resetControls();
                this.colonist.method_20620(pos.method_10263(), pos.method_10264(), pos.method_10260());
                this.moveToBed();
            });
        }
    }

    public boolean method_6266() {
        return this.isNight() && this.bedStillValid() && !this.colonist.getTaskControl().hasTask();
    }

    public void method_6270() {
        this.bedPos = null;
        this.colonist.getMovementHelper().reset();
        if (this.colonist.method_6113()) {
            this.colonist.method_18400();
        }
    }

    @NotNull
    private Optional<class_2338> getFreeBed() {
        return this.colonist.getManagersProvider().map(IServerManagersProvider::getBuildingsManager).flatMap(IServerBuildingsManager::getFreeBed);
    }

    private boolean isNight() {
        return this.colonist.method_37908().method_23886();
    }

    private boolean bedStillValid() {
        if (this.bedPos == null) {
            return false;
        }
        class_2680 blockState = this.colonist.method_37908().method_8320(this.bedPos);
        return blockState.method_26164(class_3481.field_16443) && ((Boolean)blockState.method_11654((class_2769)class_2244.field_9968) == false || this.colonist.method_6113());
    }

    private void moveToBed() {
        if (this.bedPos == null) {
            return;
        }
        this.colonist.getMovementHelper().goTo(this.bedPos, 0.05f);
    }

    private boolean hasReachedTheBed() {
        if (this.bedPos == null) {
            return false;
        }
        return this.bedPos.method_19769((class_2374)this.colonist.method_19538(), 3.0);
    }
}

