/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.goal;

import java.util.Map;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.ITaskControl;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.goal.AbstractFortressGoal;
import org.minefortress.entity.ai.professions.BlacksmithDailyTask;
import org.minefortress.entity.ai.professions.CrafterDailyTask;
import org.minefortress.entity.ai.professions.FarmerDailyTask;
import org.minefortress.entity.ai.professions.ForesterDailyTask;
import org.minefortress.entity.ai.professions.MinerDailyTask;
import org.minefortress.entity.ai.professions.ProfessionDailyTask;

public class DailyProfessionTasksGoal
extends AbstractFortressGoal {
    private final Map<String, ProfessionDailyTask> dailyTasks = Map.ofEntries(Map.entry("crafter", new CrafterDailyTask()), Map.entry("blacksmith", new BlacksmithDailyTask()), Map.entry("forester", new ForesterDailyTask()), Map.entry("farmer", new FarmerDailyTask()), Map.entry("miner", new MinerDailyTask()));
    private ProfessionDailyTask currentTask;

    public DailyProfessionTasksGoal(Colonist colonist) {
        super(colonist);
    }

    public boolean method_6264() {
        if (this.isStarving()) {
            return false;
        }
        ITaskControl taskControl = this.getTaskControl();
        if (taskControl.hasTask()) {
            return false;
        }
        String professionId = this.colonist.getProfessionId();
        for (String professionIdPart : this.dailyTasks.keySet()) {
            ProfessionDailyTask task;
            if (!professionId.startsWith(professionIdPart) || !(task = this.dailyTasks.get(professionIdPart)).canStart(this.colonist)) continue;
            this.currentTask = task;
            return true;
        }
        this.currentTask = this.dailyTasks.get(professionId);
        return this.currentTask != null && this.currentTask.canStart(this.colonist);
    }

    public void method_6269() {
        this.colonist.getTaskControl().setDoingEverydayTasks(true);
        this.currentTask.start(this.colonist);
    }

    public void method_6268() {
        this.currentTask.tick(this.colonist);
    }

    public boolean method_6266() {
        return !this.isStarving() && this.currentTask != null && this.currentTask.shouldContinue(this.colonist) && !this.getTaskControl().hasTask();
    }

    public void method_6270() {
        this.currentTask.stop(this.colonist);
        this.colonist.getTaskControl().setDoingEverydayTasks(false);
    }

    public boolean method_6267() {
        return this.isStarving();
    }

    private ITaskControl getTaskControl() {
        return this.colonist.getTaskControl();
    }
}

