/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.goal;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.ITaskControl;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskBlockInfo;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.goal.AbstractFortressGoal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColonistExecuteTaskGoal
extends AbstractFortressGoal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColonistExecuteTaskGoal.class);
    private final class_3218 world;
    private class_2338 workGoal = null;

    public ColonistExecuteTaskGoal(Colonist colonist) {
        super(colonist);
        class_3218 sw;
        class_1937 class_19372 = colonist.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            throw new IllegalStateException("AI should run on the server entities!");
        }
        this.world = sw = (class_3218)class_19372;
    }

    public boolean method_6264() {
        boolean hasTask = this.getTaskControl().hasTask();
        boolean notStarving = !super.isStarving();
        LOGGER.debug("{} can executeTask [ has task: {}, not starving: {}]", new Object[]{this.getColonistName(), hasTask, notStarving});
        return hasTask && notStarving;
    }

    public void method_6269() {
        LOGGER.debug("{} start executing task", (Object)this.getColonistName());
        if (this.colonist.method_6113()) {
            this.colonist.method_18400();
        }
        this.moveToNextBlock();
    }

    public void method_6268() {
        boolean hasTask = this.getTaskControl().hasTask();
        if (this.workGoal == null || !hasTask) {
            LOGGER.debug("{} don't have any work, but keep ticking [work goal {}, has task {}]", new Object[]{this.getColonistName(), this.workGoal, hasTask});
            return;
        }
        if (this.getMovementHelper().getWorkGoal() == null) {
            this.getMovementHelper().goTo(this.workGoal, 0.15f);
        }
        if (this.getMovementHelper().hasReachedWorkGoal()) {
            boolean placeSuccess;
            LOGGER.debug("{} reached work goal {} working", (Object)this.getColonistName(), (Object)this.workGoal);
            boolean digSuccess = this.getTaskControl().is(TaskType.REMOVE) && this.colonist.getDigControl().isDone();
            boolean bl = placeSuccess = this.getTaskControl().is(TaskType.BUILD) && this.colonist.getPlaceControl().isDone();
            if (digSuccess || placeSuccess) {
                LOGGER.debug("{} action successful moving to next block [digSuccess {}, placeSuccess {}]", new Object[]{this.getColonistName(), digSuccess, placeSuccess});
                this.moveToNextBlock();
            }
        }
        boolean movementHelperStuck = this.getMovementHelper().isStuck();
        boolean cantPlaceUnderMyself = this.colonist.getPlaceControl().isCantPlaceUnderMyself();
        if (movementHelperStuck || cantPlaceUnderMyself) {
            LOGGER.debug("{} stuck with moving or placing failing task [movement helper stuck: {}, cant place under myself: {}]", new Object[]{this.getColonistName(), movementHelperStuck, cantPlaceUnderMyself});
            this.getTaskControl().fail();
            this.colonist.resetControls();
        }
    }

    public boolean method_6266() {
        boolean notStarving = !super.isStarving();
        boolean hasTask = this.getTaskControl().hasTask();
        boolean hasGoalTryingToReachOrWorking = this.getMovementHelper().stillTryingToReachGoal() || this.workGoal != null || this.getTaskControl().partHasMoreBlocks() || this.colonist.diggingOrPlacing();
        boolean shouldContinue = notStarving && hasTask && hasGoalTryingToReachOrWorking;
        LOGGER.debug("{} should continue task execution {} [not starving {}, has task {}, has goal and working {}, digging or placing {}]", new Object[]{this.getColonistName(), shouldContinue, notStarving, hasTask, hasGoalTryingToReachOrWorking, this.colonist.diggingOrPlacing()});
        return shouldContinue;
    }

    public void method_6270() {
        LOGGER.debug("{} stopping the task execution", (Object)this.getColonistName());
        ITaskControl taskControl = this.getTaskControl();
        if (taskControl.hasTask()) {
            if (taskControl.partHasMoreBlocks()) {
                LOGGER.debug("{} failing task part", (Object)this.getColonistName());
                taskControl.fail();
            } else {
                LOGGER.debug("{} finishing task successfully", (Object)this.getColonistName());
                taskControl.success();
            }
        }
        this.colonist.resetControls();
        this.workGoal = null;
    }

    private void moveToNextBlock() {
        LOGGER.debug("{} moving to next block", (Object)this.getColonistName());
        this.getMovementHelper().reset();
        this.workGoal = null;
        ITaskBlockInfo taskBlockInfo = null;
        while (this.getTaskControl().partHasMoreBlocks()) {
            LOGGER.debug("{} task is not finished yet", (Object)this.getColonistName());
            taskBlockInfo = this.getTaskControl().getNextBlock();
            if (taskBlockInfo == null) {
                LOGGER.debug("{} next block is null. skipping", (Object)this.getColonistName());
                continue;
            }
            this.workGoal = taskBlockInfo.getPos();
            LOGGER.debug("{} set up new move goal {}", (Object)this.getColonistName(), (Object)this.workGoal);
            if (this.blockInCorrectState(this.workGoal)) {
                LOGGER.debug("{} block in in correct state, selecting it {}", (Object)this.getColonistName(), (Object)this.workGoal);
                break;
            }
            LOGGER.debug("{} block is not in correct state, skipping it {}", (Object)this.getColonistName(), (Object)this.workGoal);
        }
        if (!this.blockInCorrectState(this.workGoal)) {
            LOGGER.debug("{} task is finished and the last block is not in correct state {}", (Object)this.getColonistName(), (Object)this.workGoal);
            this.workGoal = null;
        }
        if (this.workGoal == null || taskBlockInfo == null) {
            LOGGER.debug("{} work goal [{}] or task block info [{}] is not set", new Object[]{this.getColonistName(), this.workGoal, taskBlockInfo});
            return;
        }
        LOGGER.debug("{} setting work goal {}", (Object)this.getColonistName(), (Object)taskBlockInfo);
        this.getMovementHelper().goTo(this.workGoal, 0.15f);
        LOGGER.debug("{} setting goal for colonist {}", (Object)this.getColonistName(), (Object)taskBlockInfo);
        this.colonist.setGoal(taskBlockInfo);
    }

    private boolean blockInCorrectState(class_2338 pos) {
        if (pos == null) {
            return false;
        }
        if (this.getTaskControl().is(TaskType.REMOVE)) {
            if (pos.equals((Object)((IServerFortressManager)this.colonist.getServerFortressManager().orElseThrow()).getFortressCenter())) {
                return false;
            }
            return BuildingHelper.canRemoveBlock((class_1937)this.world, pos);
        }
        if (this.getTaskControl().is(TaskType.BUILD)) {
            return BuildingHelper.canPlaceBlock((class_1937)this.world, pos);
        }
        throw new IllegalStateException();
    }

    private ITaskControl getTaskControl() {
        return this.colonist.getTaskControl();
    }

    private MovementHelper getMovementHelper() {
        return this.colonist.getMovementHelper();
    }
}

