/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.controls;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.ITaskControl;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskBlockInfo;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.Colonist;
import org.minefortress.tasks.BlueprintTask;
import org.minefortress.tasks.CutTreesTask;
import org.minefortress.tasks.RoadsTask;
import org.minefortress.tasks.SimpleSelectionTask;

public class TaskControl
implements ITaskControl {
    private final Colonist colonist;
    private final Cache<UUID, Boolean> returnedIds = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private boolean doingEverydayTasks = false;
    private ITask task;
    private ITaskPart taskPart;
    private Iterator<ITaskBlockInfo> blocks;
    private Consumer<ITaskPart> onTaskFailed;
    private Supplier<Boolean> cancelled;

    public TaskControl(Colonist colonist) {
        this.colonist = colonist;
    }

    @Override
    public boolean canStartTask(ITask task) {
        return !this.hasTask() && !this.returnedIds.asMap().containsKey(task.getId()) && this.colonist.getCurrentFoodLevel() > 0;
    }

    @Override
    public void setTask(@NotNull ITask task, ITaskPart taskPart, Consumer<ITaskPart> onTaskFailed, Supplier<Boolean> cancelled) {
        this.task = task;
        this.taskPart = taskPart;
        this.blocks = taskPart.getBlocks().iterator();
        this.onTaskFailed = onTaskFailed;
        this.cancelled = cancelled;
        this.updateCurrentTaskDesription();
    }

    private void updateCurrentTaskDesription() {
        if (this.task instanceof SimpleSelectionTask) {
            if (this.task.getTaskType() == TaskType.REMOVE) {
                this.colonist.setCurrentTaskDesc("Digging");
            } else {
                this.colonist.setCurrentTaskDesc("Building");
            }
        } else if (this.task instanceof BlueprintTask) {
            this.colonist.setCurrentTaskDesc("Building blueprint");
        } else if (this.task instanceof CutTreesTask) {
            this.colonist.setCurrentTaskDesc("Falling trees");
        } else if (this.task instanceof RoadsTask) {
            this.colonist.setCurrentTaskDesc("Building roads");
        }
    }

    @Override
    public void resetTask() {
        this.task = null;
        this.taskPart = null;
        this.blocks = null;
        this.onTaskFailed = null;
        this.cancelled = null;
    }

    @Override
    public void fail() {
        if (!this.hasTask()) {
            return;
        }
        this.onTaskFailed.accept(this.taskPart);
        this.returnedIds.put((Object)this.task.getId(), (Object)true);
        this.resetTask();
    }

    @Override
    public void success() {
        if (!this.hasTask()) {
            return;
        }
        this.task.finishPart(this.taskPart, this.colonist);
        this.resetTask();
    }

    @Override
    public boolean hasTask() {
        if (this.cancelled != null && this.cancelled.get().booleanValue()) {
            this.resetTask();
            this.colonist.resetControls();
        }
        return this.task != null;
    }

    @Override
    public void setDoingEverydayTasks(boolean doingEverydayTasks) {
        this.doingEverydayTasks = doingEverydayTasks;
    }

    @Override
    public boolean isDoingEverydayTasks() {
        return this.doingEverydayTasks;
    }

    @Override
    public boolean is(TaskType type) {
        if (!this.hasTask()) {
            return false;
        }
        return this.task.getTaskType() == type;
    }

    @Override
    public boolean partHasMoreBlocks() {
        if (!this.hasTask()) {
            return false;
        }
        return this.blocks.hasNext();
    }

    @Override
    public Optional<UUID> getTaskId() {
        return Optional.ofNullable(this.task).map(ITask::getId);
    }

    @Override
    @Nullable
    public ITaskBlockInfo getNextBlock() {
        return this.blocks.next();
    }

    @Override
    public boolean isBlueprintTask() {
        return this.task instanceof BlueprintTask;
    }
}

