/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.controls;

import baritone.api.minefortress.IBlockPosControl;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_5712;
import net.remmintan.mods.minefortress.building.FortressBlocks;
import org.minefortress.entity.Colonist;

public class ScaffoldsControl
implements IBlockPosControl {
    private final Colonist colonist;
    private static final class_2248 SCAFFOLD_BLOCK = FortressBlocks.SCAFFOLD_OAK_PLANKS;
    private final Queue<class_2338> results = new ConcurrentLinkedQueue<class_2338>();
    private final Queue<BlockTask> blockTasks = new ConcurrentLinkedQueue<BlockTask>();

    public ScaffoldsControl(Colonist colonist) {
        this.colonist = colonist;
    }

    public void tick() {
        this.blockTasks.removeIf(BlockTask::execute);
        if (!this.colonist.getTaskControl().hasTask() && !this.results.isEmpty()) {
            this.clearResults();
        }
    }

    public void addBlock(class_2338 placePosition) {
        if (!this.colonist.getTaskControl().hasTask()) {
            BlockTask blockTask = new BlockTask(() -> {
                class_1937 level = this.colonist.method_37908();
                if (level.method_8320(placePosition).method_27852(SCAFFOLD_BLOCK)) {
                    level.method_8650(placePosition, false);
                    level.method_33596((class_1297)this.colonist, class_5712.field_28165, placePosition);
                }
            });
            this.blockTasks.add(blockTask);
            return;
        }
        this.results.add(placePosition);
    }

    public void clearResults() {
        if (this.results.isEmpty()) {
            return;
        }
        class_1937 level = this.colonist.method_37908();
        for (class_2338 result : this.results) {
            if (!level.method_8320(result).method_27852(SCAFFOLD_BLOCK)) continue;
            level.method_8650(result, false);
            level.method_33596((class_1297)this.colonist, class_5712.field_28165, result);
        }
        this.results.clear();
    }

    private static class BlockTask {
        private static final int MAX_TICKS = 25;
        private int ticks = 0;
        private final Runnable action;

        private BlockTask(Runnable action) {
            this.action = action;
        }

        public boolean execute() {
            if (++this.ticks > 25) {
                this.action.run();
                return true;
            }
            return false;
        }
    }
}

