/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.controls;

import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5712;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.ITaskControl;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.controls.PositionedActionControl;
import org.minefortress.fortress.resources.SimilarItemsHelper;
import org.minefortress.tasks.block.info.BlockStateTaskBlockInfo;
import org.minefortress.tasks.block.info.ItemTaskBlockInfo;

public class PlaceControl
extends PositionedActionControl {
    private final Colonist colonist;
    private float placeCooldown = 0.0f;
    private int failedInteractions = 0;
    private boolean cantPlaceUnderMyself = false;

    public PlaceControl(Colonist colonist) {
        this.colonist = colonist;
    }

    @Override
    public void tick() {
        class_2338 blockPos;
        if (this.isDone()) {
            return;
        }
        if (!super.canReachTheGoal(this.colonist) || !this.colonist.method_5942().method_6357()) {
            return;
        }
        if (this.placeCooldown > 0.0f) {
            this.placeCooldown -= 1.0f / this.colonist.getHungerMultiplier();
        }
        if ((blockPos = this.colonist.method_24515()).equals((Object)this.goal)) {
            if (!this.colonist.isWallAboveTheHead()) {
                this.colonist.method_5993().method_6233();
            } else {
                this.cantPlaceUnderMyself = true;
            }
        } else {
            this.placeBlock();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.failedInteractions = 0;
        this.cantPlaceUnderMyself = false;
    }

    protected void placeBlock() {
        this.colonist.lookAtGoal();
        this.colonist.putItemInHand(this.item);
        if (this.placeCooldown <= 0.0f) {
            this.colonist.method_6104(class_1268.field_5808);
            this.colonist.addHunger(0.005f);
            if (this.taskBlockInfo instanceof ItemTaskBlockInfo) {
                this.place((ItemTaskBlockInfo)this.taskBlockInfo);
            }
            if (this.taskBlockInfo instanceof BlockStateTaskBlockInfo) {
                this.place((BlockStateTaskBlockInfo)this.taskBlockInfo);
            }
        }
    }

    private void place(ItemTaskBlockInfo blockInfo) {
        class_1838 context = blockInfo.getContext();
        class_1269 interactionResult = this.item.method_7884(context);
        if (interactionResult == class_1269.field_21466 || this.failedInteractions > 15) {
            if (interactionResult == class_1269.field_21466) {
                this.decreaseResourcesAndAddSpecialBlocksAmount();
            }
            this.reset();
            this.placeCooldown = 6.0f;
        } else {
            ++this.failedInteractions;
        }
    }

    private void place(BlockStateTaskBlockInfo blockInfo) {
        class_2680 stateForPlacement = blockInfo.getState();
        this.colonist.method_37908().method_8652(this.goal, stateForPlacement, 3);
        this.colonist.method_37908().method_33596((class_1297)this.colonist, class_5712.field_28164, this.goal);
        this.decreaseResourcesAndAddSpecialBlocksAmount();
        this.reset();
        this.placeCooldown = 6.0f;
    }

    private void decreaseResourcesAndAddSpecialBlocksAmount() {
        class_1747 blockItem;
        class_1792 class_17922;
        IServerManagersProvider provider = (IServerManagersProvider)this.colonist.getManagersProvider().orElseThrow();
        IServerFortressManager manager = (IServerFortressManager)this.colonist.getServerFortressManager().orElseThrow();
        ITaskControl taskControl = this.colonist.getTaskControl();
        if (manager.isSurvival()) {
            taskControl.getTaskId().ifPresent(it -> {
                IServerResourceManager resourceManager = provider.getResourceManager();
                if (SimilarItemsHelper.isIgnorable(this.item)) {
                    resourceManager.removeItemIfExists((UUID)it, this.item);
                } else {
                    resourceManager.removeReservedItem((UUID)it, this.item);
                }
            });
        }
        if ((class_17922 = this.item) instanceof class_1747 && manager.isBlockSpecial((blockItem = (class_1747)class_17922).method_7711())) {
            manager.addSpecialBlocks(blockItem.method_7711(), this.goal, taskControl.isBlueprintTask());
        }
    }

    public boolean isCantPlaceUnderMyself() {
        return this.cantPlaceUnderMyself;
    }
}

