/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.controls;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5712;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import org.minefortress.entity.Colonist;
import org.minefortress.entity.ai.controls.PositionedActionControl;

public class DigControl
extends PositionedActionControl {
    private final Colonist colonist;
    private final class_3218 level;
    private float destroyProgress = 0.0f;
    private int destroyTicks = 0;

    public DigControl(Colonist colonist, class_3218 level) {
        this.colonist = colonist;
        this.level = level;
    }

    @Override
    public void tick() {
        if (this.isDone()) {
            return;
        }
        if (!super.canReachTheGoal(this.colonist) || !this.colonist.method_5942().method_6357()) {
            return;
        }
        if (this.act()) {
            this.reset();
        }
    }

    private boolean act() {
        this.putProperItemInHand();
        this.colonist.addHunger(0.005f);
        if (this.destroyProgress >= 1.0f) {
            this.destroyProgress = 0.0f;
            DigControl.addDropToTheResourceManager(this.level, this.goal, this.colonist);
            this.level.method_8651(this.goal, false, (class_1297)this.colonist);
            this.level.method_33596((class_1297)this.colonist, class_5712.field_28165, this.goal);
            return true;
        }
        this.destroyProgress += this.getDestroyProgress(this.level.method_8320(this.goal), this.colonist, (class_5281)this.level, this.goal) / this.colonist.getHungerMultiplier();
        this.colonist.lookAtGoal();
        if ((float)(++this.destroyTicks) % (4.0f * this.colonist.getHungerMultiplier()) == 0.0f) {
            this.colonist.method_6104(class_1268.field_5808);
        }
        return false;
    }

    public static void addDropToTheResourceManager(class_3218 w, class_2338 g, Colonist c) {
        class_2586 class_25862;
        class_2680 blockState = w.method_8320(g);
        if (blockState instanceof class_2343) {
            class_2343 provider = (class_2343)blockState;
            class_25862 = provider.method_10123(g, blockState);
        } else {
            class_25862 = null;
        }
        class_2586 blockEntity = class_25862;
        List drop = class_2248.method_9562((class_2680)blockState, (class_3218)w, (class_2338)g, (class_2586)blockEntity);
        IServerManagersProvider provider = (IServerManagersProvider)c.getManagersProvider().orElseThrow();
        IServerFortressManager manager = (IServerFortressManager)c.getServerFortressManager().orElseThrow();
        if (manager.isSurvival()) {
            IServerResourceManager serverResourceManager = provider.getResourceManager();
            for (class_1799 itemStack : drop) {
                class_1792 item = itemStack.method_7909();
                int count = itemStack.method_7947();
                serverResourceManager.increaseItemAmount(item, count);
            }
        }
    }

    private void putProperItemInHand() {
        boolean creative = ((IServerFortressManager)this.colonist.getServerFortressManager().orElseThrow()).isCreative();
        class_2680 blockState = this.level.method_8320(this.goal);
        class_1792 item = null;
        String professionId = this.colonist.getProfessionId();
        if (blockState.method_26164(class_3481.field_33715)) {
            if (creative) {
                item = class_1802.field_8377;
            } else {
                item = switch (professionId) {
                    case "miner1" -> class_1802.field_8387;
                    case "miner2" -> class_1802.field_8403;
                    case "miner3" -> class_1802.field_8377;
                    default -> class_1802.field_8647;
                };
            }
        } else if (blockState.method_26164(class_3481.field_33716)) {
            if (creative) {
                item = class_1802.field_8250;
            } else {
                item = switch (professionId) {
                    case "miner1" -> class_1802.field_8776;
                    case "miner2" -> class_1802.field_8699;
                    case "miner3" -> class_1802.field_8250;
                    default -> class_1802.field_8876;
                };
            }
        } else if (blockState.method_26164(class_3481.field_33713)) {
            if (creative) {
                item = class_1802.field_8556;
            } else {
                item = switch (professionId) {
                    case "miner1", "lumberjack1" -> class_1802.field_8062;
                    case "miner2", "lumberjack2" -> class_1802.field_8475;
                    case "miner3", "lumberjack3" -> class_1802.field_8556;
                    default -> class_1802.field_8406;
                };
            }
        } else if (blockState.method_26164(class_3481.field_33714)) {
            item = creative ? class_1802.field_8527 : ("farmer".equals(professionId) ? class_1802.field_8609 : class_1802.field_8167);
        }
        this.colonist.putItemInHand(item);
    }

    private float getDestroyProgress(class_2680 state, Colonist pawn, class_5281 world, class_2338 pos) {
        boolean creative = this.colonist.getServerFortressManager().map(IServerFortressManager::isCreative).orElse(false);
        if (creative) {
            return 1.0f;
        }
        float f = state.method_26214((class_1922)world, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        return pawn.getDestroySpeed(state) / f / 100.0f;
    }

    @Override
    public void reset() {
        super.reset();
        this.destroyProgress = 0.0f;
        this.destroyTicks = 0;
    }
}

