/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai.controls;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.event.events.PathEvent;
import baritone.api.event.listener.AbstractGameEventListener;
import baritone.api.event.listener.IGameEventListener;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalNear;
import baritone.api.utils.BetterBlockPos;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_5134;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IFortressAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.ITargetedPawn;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWarrior;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.IBaritoneMoveControl;
import org.jetbrains.annotations.NotNull;
import org.minefortress.entity.BaritonableEntity;
import org.minefortress.entity.TargetedPawn;
import org.minefortress.entity.WarriorPawn;

public class BaritoneMoveControl
implements IBaritoneMoveControl {
    private final IBaritone baritone;
    private final BaritonableEntity entity;
    private class_2338 moveTarget;
    private class_1309 followTarget;
    private boolean stuck = false;
    private double currentReachRange = 0.0;

    public BaritoneMoveControl(BaritonableEntity entity) {
        this.entity = entity;
        this.baritone = BaritoneAPI.getProvider().getBaritone((class_1309)entity);
        this.baritone.getGameEventHandler().registerEventListener((IGameEventListener)new StuckOnFailEventListener());
    }

    @Override
    public void moveTo(@NotNull class_2338 pos) {
        this.reset(true);
        this.updateReachRange(false);
        this.entity.method_6125((float)this.entity.method_26825(class_5134.field_23719));
        this.moveTarget = pos;
        GoalNear goal = new GoalNear(pos, (int)Math.floor(this.currentReachRange));
        this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)goal);
    }

    @Override
    public void moveTo(@NotNull class_1309 entity) {
        this.reset(true);
        this.updateReachRange(true);
        this.baritone.settings().followRadius.set((Object)((int)Math.floor(this.currentReachRange)));
        this.followTarget = entity;
        this.entity.method_6125((float)this.entity.method_26825(class_5134.field_23719));
        this.baritone.getFollowProcess().follow(it -> it.equals((Object)entity));
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    private void reset(boolean startMoving) {
        if (startMoving && this.entity.method_6113()) {
            this.entity.method_18400();
        }
        this.baritone.getFollowProcess().cancel();
        this.baritone.getPathingBehavior().cancelEverything();
        this.moveTarget = null;
        this.followTarget = null;
        this.stuck = false;
        this.currentReachRange = 0.0;
    }

    @Override
    public boolean isStuck() {
        return this.stuck;
    }

    private Optional<class_2338> getTargetPos() {
        return Optional.ofNullable(this.moveTarget).or(() -> Optional.ofNullable(this.followTarget).map(class_1297::method_24515));
    }

    private boolean moveTargetInRange() {
        return this.getTargetPos().map(it -> it.method_19769((class_2374)this.entity.method_19538(), this.currentReachRange)).orElse(false);
    }

    private void updateReachRange(boolean follow) {
        BaritonableEntity baritonableEntity;
        if (follow && (baritonableEntity = this.entity) instanceof IWarrior) {
            IWarrior warrior = (IWarrior)((Object)baritonableEntity);
            this.currentReachRange = warrior.getAttackRange();
            return;
        }
        baritonableEntity = this.entity;
        if (baritonableEntity instanceof ITargetedPawn) {
            ITargetedPawn targeted = (ITargetedPawn)((Object)baritonableEntity);
            this.currentReachRange = targeted.getTargetMoveRange();
            return;
        }
        this.currentReachRange = this.entity.method_26825(class_5134.field_23717);
    }

    private class StuckOnFailEventListener
    implements AbstractGameEventListener {
        private class_2338 lastDestination;
        private int stuckCounter = 0;

        private StuckOnFailEventListener() {
        }

        public void onPathEvent(PathEvent pathEvent) {
            this.checkFalseAtGoal(pathEvent);
            this.checkStuckOnTheSamePlace(pathEvent);
            this.checkFailedToCalc(pathEvent);
        }

        private void checkFalseAtGoal(PathEvent pathEvent) {
            if (pathEvent == PathEvent.AT_GOAL && !BaritoneMoveControl.this.moveTargetInRange()) {
                BaritoneMoveControl.this.stuck = true;
            }
        }

        private void checkFailedToCalc(PathEvent pathEvent) {
            if (pathEvent == PathEvent.CALC_FAILED) {
                BaritonableEntity baritonableEntity = BaritoneMoveControl.this.entity;
                if (baritonableEntity instanceof IFortressAwareEntity) {
                    IFortressAwareEntity fae = (IFortressAwareEntity)((Object)baritonableEntity);
                    baritonableEntity = BaritoneMoveControl.this.entity;
                    if (baritonableEntity instanceof TargetedPawn) {
                        TargetedPawn targetedPawn = (TargetedPawn)baritonableEntity;
                        fae.sendMessageToMasterPlayer(StuckOnFailEventListener.getPawnType(fae) + " " + BaritoneMoveControl.this.entity.method_5477().getString() + " can't reach the target");
                        targetedPawn.resetTargets();
                    }
                }
                BaritoneMoveControl.this.stuck = true;
            }
        }

        private static String getPawnType(IFortressAwareEntity fae) {
            if (fae instanceof WarriorPawn) {
                return "Warrior";
            }
            return "Pawn";
        }

        private void checkStuckOnTheSamePlace(PathEvent pathEvent) {
            if (pathEvent == PathEvent.CALC_FINISHED_NOW_EXECUTING) {
                BetterBlockPos dest = BaritoneMoveControl.this.baritone.getPathingBehavior().getPath().map(IPath::getDest).orElse(BetterBlockPos.ORIGIN);
                if (this.lastDestination != null) {
                    if (!class_2338.field_10980.equals((Object)this.lastDestination) && dest.equals((Object)this.lastDestination)) {
                        ++this.stuckCounter;
                        if (this.stuckCounter > 1) {
                            BaritoneMoveControl.this.stuck = true;
                            this.stuckCounter = 0;
                            this.lastDestination = null;
                            BaritoneMoveControl.this.baritone.getPathingBehavior().cancelEverything();
                        }
                    } else {
                        this.stuckCounter = 0;
                    }
                }
                this.lastDestination = dest;
            }
        }
    }
}

