/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity.ai;

import baritone.api.IBaritone;
import baritone.api.event.events.PathEvent;
import baritone.api.event.listener.AbstractGameEventListener;
import baritone.api.event.listener.IGameEventListener;
import baritone.api.pathing.calc.IPath;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalNear;
import baritone.api.utils.BetterBlockPos;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.minefortress.entity.Colonist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovementHelper.class);
    private final Colonist colonist;
    private final IBaritone baritone;
    private class_2338 workGoal;
    private int stuckTicks = 0;
    private boolean stuck = false;
    private class_2338 lastPos = null;

    public MovementHelper(Colonist colonist) {
        this.colonist = colonist;
        this.baritone = colonist.getBaritone();
        this.baritone.getGameEventHandler().registerEventListener((IGameEventListener)new StuckOnFailEventListener());
    }

    public void reset() {
        boolean hasWorkGoal = this.workGoal != null;
        boolean tryingToReachGoal = this.stillTryingToReachGoal();
        LOGGER.debug("{} movement helper reset [has work goal: {}, trying to reach the goal {}]", new Object[]{this.getColonistName(), hasWorkGoal, tryingToReachGoal});
        this.workGoal = null;
        this.lastPos = null;
        this.stuckTicks = 0;
        this.stuck = false;
        this.colonist.method_5942().method_6340();
        this.baritone.getPathingBehavior().cancelEverything();
        this.baritone.getFollowProcess().cancel();
        this.colonist.setAllowToPlaceBlockFromFarAway(false);
        this.baritone.settings().allowParkour.set((Object)true);
    }

    private String getColonistName() {
        return this.colonist.method_5477().getString();
    }

    public class_2338 getWorkGoal() {
        return this.workGoal;
    }

    public void goTo(class_2338 goal, float speed) {
        if (this.workGoal != null && this.workGoal.equals((Object)goal)) {
            LOGGER.debug("{} trying to set new goal, but current goal is the same", (Object)this.getColonistName());
            return;
        }
        LOGGER.debug("{} set new goal {}. speed: {}", new Object[]{this.getColonistName(), goal, Float.valueOf(speed)});
        this.reset();
        this.workGoal = goal;
        if (this.workGoal == null) {
            return;
        }
        this.colonist.method_6125(speed);
        if (this.hasReachedWorkGoal()) {
            LOGGER.debug("{} the goal {} is already reached", (Object)this.getColonistName(), (Object)goal);
            return;
        }
        if (this.colonist.method_6113()) {
            this.colonist.method_18400();
        }
        this.baritone.getCustomGoalProcess().setGoalAndPath((Goal)new GoalNear(this.workGoal, 2));
    }

    public void follow(class_1309 entity, float speed) {
        this.reset();
        this.baritone.settings().followRadius.set((Object)1);
        this.colonist.method_6125(speed);
        this.baritone.getFollowProcess().follow(it -> it.equals((Object)entity));
    }

    public boolean hasReachedWorkGoal() {
        if (this.workGoal == null) {
            return false;
        }
        boolean withinDistance = this.workGoal.method_19771((class_2382)this.colonist.method_24515(), 3.0) || this.colonist.isAllowToPlaceBlockFromFarAway();
        return withinDistance && !this.baritone.getPathingBehavior().isPathing();
    }

    public void tick() {
        if (this.workGoal == null) {
            return;
        }
        class_2338 currentPos = this.colonist.method_24515();
        if (!this.hasReachedWorkGoal() && currentPos.equals((Object)this.lastPos)) {
            ++this.stuckTicks;
            LOGGER.debug("{} on the same place without reaching the goal for {} ticks. Goal: {}", new Object[]{this.getColonistName(), this.stuckTicks, this.workGoal});
            if (this.stuckTicks > 20) {
                LOGGER.debug("{} on the same place for too long. Setting stuck to true. Goal: {}", (Object)this.getColonistName(), (Object)this.workGoal);
                this.colonist.setAllowToPlaceBlockFromFarAway(true);
                this.stuckTicks = 0;
            }
        } else {
            this.stuck = false;
            this.stuckTicks = 0;
        }
        this.lastPos = currentPos;
    }

    public boolean stillTryingToReachGoal() {
        return this.baritone.getPathingBehavior().isPathing();
    }

    public boolean isStuck() {
        return this.stuck;
    }

    private class StuckOnFailEventListener
    implements AbstractGameEventListener {
        private class_2338 lastDestination;
        private int stuckCounter = 0;

        private StuckOnFailEventListener() {
        }

        public void onPathEvent(PathEvent pathEvent) {
            if (pathEvent == PathEvent.AT_GOAL && !MovementHelper.this.hasReachedWorkGoal()) {
                LOGGER.debug("{} signaling at goal without actually reaching the goal {}. Setting stuck to true", (Object)MovementHelper.this.getColonistName(), (Object)MovementHelper.this.workGoal);
                MovementHelper.this.stuck = true;
            }
            if (pathEvent == PathEvent.CALC_FINISHED_NOW_EXECUTING) {
                BetterBlockPos dest = MovementHelper.this.baritone.getPathingBehavior().getPath().map(IPath::getDest).orElse(BetterBlockPos.ORIGIN);
                if (this.lastDestination != null) {
                    if (dest.equals((Object)this.lastDestination)) {
                        ++this.stuckCounter;
                        LOGGER.debug("{} Calculated destination is the same as previous for {} ticks (going in circles). [Goal: {}]", new Object[]{MovementHelper.this.getColonistName(), this.stuckCounter, MovementHelper.this.workGoal});
                        if (this.stuckCounter > 1) {
                            LOGGER.debug("{} going in circles for too much time {} [goal: {}]", new Object[]{MovementHelper.this.getColonistName(), this.stuckCounter, MovementHelper.this.workGoal});
                            MovementHelper.this.stuck = true;
                            this.stuckCounter = 0;
                            this.lastDestination = null;
                            MovementHelper.this.baritone.getPathingBehavior().cancelEverything();
                        }
                    } else {
                        this.stuckCounter = 0;
                    }
                }
                this.lastDestination = dest;
            }
            if (pathEvent == PathEvent.CALC_FAILED) {
                LOGGER.debug("{} can't find path to {}", (Object)MovementHelper.this.getColonistName(), (Object)MovementHelper.this.workGoal);
                MovementHelper.this.colonist.setAllowToPlaceBlockFromFarAway(true);
            }
        }
    }
}

