/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.ITargetedPawn;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.IBaritoneMoveControl;
import net.remmintan.mods.minefortress.networking.c2s.C2SFollowTargetPacket;
import net.remmintan.mods.minefortress.networking.c2s.C2SMoveTargetPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.BasePawnEntity;
import org.minefortress.entity.NamedPawnEntity;
import org.minefortress.entity.ai.controls.BaritoneMoveControl;

public abstract class TargetedPawn
extends NamedPawnEntity
implements ITargetedPawn {
    protected final IBaritoneMoveControl moveControl;
    private class_2338 moveTarget;
    private class_1309 attackTarget;

    public TargetedPawn(class_1299<? extends BasePawnEntity> entityType, class_1937 world, boolean enableHunger) {
        super(entityType, world, enableHunger);
        this.moveControl = world instanceof class_3218 ? new BaritoneMoveControl(this) : null;
    }

    @Override
    public void setMoveTarget(@Nullable class_2338 pos) {
        if (pos != null) {
            if (this.method_37908().field_9236) {
                C2SMoveTargetPacket packet = new C2SMoveTargetPacket(pos, this.method_5628());
                FortressClientNetworkHelper.send("move_target", packet);
            } else {
                this.resetTargets();
                this.moveTarget = pos;
            }
        } else {
            throw new IllegalArgumentException("Move target cannot be null");
        }
    }

    @Override
    @Nullable
    public class_2338 getMoveTarget() {
        if (this.method_37908().field_9236) {
            throw new IllegalStateException("Cannot get move target on client");
        }
        return this.moveTarget;
    }

    @Override
    public void setAttackTarget(@Nullable class_1309 entity) {
        if (entity != null) {
            if (this.method_37908().field_9236) {
                C2SFollowTargetPacket followPacket = new C2SFollowTargetPacket(this.method_5628(), entity.method_5628());
                FortressClientNetworkHelper.send("follow_target", followPacket);
            } else {
                this.resetTargets();
                this.attackTarget = entity;
            }
        } else {
            throw new IllegalArgumentException("Attack target cannot be null");
        }
    }

    @Override
    @Nullable
    public class_1309 getAttackTarget() {
        if (this.method_37908().field_9236) {
            throw new IllegalStateException("Cannot get attack target on client");
        }
        return this.attackTarget;
    }

    @Override
    public IBaritoneMoveControl getFortressMoveControl() {
        return this.moveControl;
    }

    @Override
    public void resetTargets() {
        this.moveTarget = null;
        this.attackTarget = null;
    }

    @Override
    public class_243 method_19538() {
        return super.method_19538();
    }

    @Override
    public int method_5628() {
        return super.method_5628();
    }

    @Override
    @Nullable
    public class_1309 method_5968() {
        return super.method_5968();
    }
}

