/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity;

import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IFortressAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IHungerAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.IEatControl;
import org.minefortress.entity.BaritonableEntity;
import org.minefortress.entity.NamedPawnEntity;
import org.minefortress.entity.ai.controls.EatControl;
import org.minefortress.entity.ai.goal.EatGoal;
import org.minefortress.entity.colonist.FakeHungerManager;
import org.minefortress.entity.colonist.FortressHungerManager;
import org.minefortress.entity.colonist.IFortressHungerManager;

public abstract class HungryEntity
extends BaritonableEntity
implements IHungerAwareEntity {
    private static final class_2940<Integer> CURRENT_FOOD_LEVEL = class_2945.method_12791(HungryEntity.class, (class_2941)class_2943.field_13327);
    private static final String HUNGER_MANAGER_NBT_KEY = "hunger";
    private final IFortressHungerManager hungerManager;
    private final IEatControl eatControl;

    protected HungryEntity(class_1299<? extends class_1314> entityType, class_1937 world, boolean enableHunger) {
        super(entityType, world);
        this.hungerManager = enableHunger ? new FortressHungerManager() : new FakeHungerManager();
        this.eatControl = world instanceof class_3218 ? new EatControl(this) : null;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CURRENT_FOOD_LEVEL, (Object)20);
    }

    protected void method_5959() {
        super.method_5959();
        if (!(this.hungerManager instanceof FakeHungerManager)) {
            this.field_6201.method_6277(7, (class_1352)new EatGoal(this));
        }
    }

    protected void method_5958() {
        super.method_5958();
        if (this.eatControl != null) {
            this.eatControl.tick();
        }
        this.hungerManager.update((class_1309)this);
        if (this.getCurrentFoodLevel() != this.getHungerManager().method_7586()) {
            this.sendHungerMessage();
            this.updateCurrentFoodLevel();
        }
    }

    @Override
    public float method_6032() {
        return super.method_6032();
    }

    @Override
    public final class_1702 getHungerManager() {
        return this.hungerManager.toHungerManager();
    }

    @Override
    public final int getCurrentFoodLevel() {
        return (Integer)this.field_6011.method_12789(CURRENT_FOOD_LEVEL);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2487 nbtCompound = new class_2487();
        this.getHungerManager().method_7582(nbtCompound);
        nbt.method_10566(HUNGER_MANAGER_NBT_KEY, (class_2520)nbtCompound);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2487 nbtCompound = nbt.method_10562(HUNGER_MANAGER_NBT_KEY);
        this.getHungerManager().method_7584(nbtCompound);
    }

    public final class_1799 method_18866(class_1937 world, class_1799 stack) {
        this.getHungerManager().method_7579(stack.method_7909(), stack);
        return super.method_18866(world, stack);
    }

    private void sendHungerMessage() {
        HungryEntity hungryEntity = this;
        if (hungryEntity instanceof IFortressAwareEntity) {
            IFortressAwareEntity fae = (IFortressAwareEntity)((Object)hungryEntity);
            hungryEntity = this;
            if (hungryEntity instanceof NamedPawnEntity) {
                NamedPawnEntity npe = (NamedPawnEntity)hungryEntity;
                class_1702 hungerManager = this.getHungerManager();
                String pawnName = npe.method_5477().getString();
                if (hungerManager.field_7754 > 0 && hungerManager.method_7586() <= 0) {
                    fae.sendMessageToMasterPlayer(pawnName + " is starving! Do something!");
                } else if (hungerManager.field_7754 >= 5 && hungerManager.field_7756 < 5) {
                    fae.sendMessageToMasterPlayer(pawnName + " is very hungry! Bring some food to the village!");
                } else if (hungerManager.field_7754 >= 10 && hungerManager.field_7756 < 10) {
                    fae.sendMessageToMasterPlayer(pawnName + " is hungry. It's time to eat something!");
                }
            }
        }
    }

    @Override
    public Optional<IEatControl> getEatControl() {
        return Optional.ofNullable(this.eatControl);
    }

    private void updateCurrentFoodLevel() {
        this.field_6011.method_12778(CURRENT_FOOD_LEVEL, (Object)this.hungerManager.toHungerManager().method_7586());
    }

    @Override
    public class_1799 method_6030() {
        return super.method_6030();
    }

    @Override
    public int method_6014() {
        return super.method_6014();
    }

    @Override
    public boolean method_6115() {
        return super.method_6115();
    }

    @Override
    public void method_6019(class_1268 hand) {
        super.method_6019(hand);
    }

    @Override
    public class_1799 method_5998(class_1268 hand) {
        return super.method_5998(hand);
    }

    @Override
    public void method_6122(class_1268 hand, class_1799 stack) {
        super.method_6122(hand, stack);
    }
}

