/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity;

import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.minefortress.IFortressColonist;
import baritone.api.minefortress.IMinefortressEntity;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1548;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IWorkerPawn;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.IEatControl;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.controls.ITaskControl;
import net.remmintan.mods.minefortress.core.interfaces.professions.IServerProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITaskBlockInfo;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.BasePawnEntity;
import org.minefortress.entity.NamedPawnEntity;
import org.minefortress.entity.ai.MovementHelper;
import org.minefortress.entity.ai.controls.DigControl;
import org.minefortress.entity.ai.controls.PlaceControl;
import org.minefortress.entity.ai.controls.ScaffoldsControl;
import org.minefortress.entity.ai.controls.TaskControl;
import org.minefortress.entity.ai.goal.BuildingAttackerTargetGoal;
import org.minefortress.entity.ai.goal.ColonistExecuteTaskGoal;
import org.minefortress.entity.ai.goal.ColonistMeleeAttackGoal;
import org.minefortress.entity.ai.goal.DailyProfessionTasksGoal;
import org.minefortress.entity.ai.goal.FollowFortressAttackTargetGoal;
import org.minefortress.entity.ai.goal.FortressColonistActiveTargetGoal;
import org.minefortress.entity.ai.goal.FortressRevengeGoal;
import org.minefortress.entity.ai.goal.ReturnToFireGoal;
import org.minefortress.entity.ai.goal.SleepOnTheBedGoal;
import org.minefortress.entity.ai.goal.WanderAroundTheFortressGoal;
import org.minefortress.registries.FortressEntities;

public final class Colonist
extends NamedPawnEntity
implements IMinefortressEntity,
IFortressColonist,
IWorkerPawn {
    public static final float FAST_MOVEMENT_SPEED = 0.15f;
    public static final float SLOW_MOVEMENT_SPEED = 0.05f;
    private static final class_2940<String> CURRENT_TASK_DESCRIPTION = class_2945.method_12791(Colonist.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> PROFESSION_ID = class_2945.method_12791(Colonist.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> HAS_TASK = class_2945.method_12791(Colonist.class, (class_2941)class_2943.field_13323);
    public static final String DEFAULT_PROFESSION_ID = "colonist";
    public static final String RESERVE_PROFESSION_ID = "reserve";
    public static final float WORK_REACH_DISTANCE = 3.0f;
    private final DigControl digControl;
    private final PlaceControl placeControl;
    private final ScaffoldsControl scaffoldsControl;
    private final ITaskControl taskControl;
    private final MovementHelper movementHelper;
    private final IBaritone baritone;
    private boolean allowToPlaceBlockFromFarAway = false;
    private class_2338 goal;

    public Colonist(class_1299<? extends Colonist> entityType, class_1937 world) {
        super((class_1299<? extends BasePawnEntity>)entityType, world, true);
        if (world instanceof class_3218) {
            this.digControl = new DigControl(this, (class_3218)world);
            this.placeControl = new PlaceControl(this);
            this.scaffoldsControl = new ScaffoldsControl(this);
            this.taskControl = new TaskControl(this);
            this.baritone = BaritoneAPI.getProvider().getBaritone((class_1309)this);
            this.movementHelper = new MovementHelper(this);
        } else {
            this.digControl = null;
            this.placeControl = null;
            this.scaffoldsControl = null;
            this.taskControl = null;
            this.baritone = null;
            this.movementHelper = null;
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CURRENT_TASK_DESCRIPTION, (Object)"");
        this.field_6011.method_12784(PROFESSION_ID, (Object)DEFAULT_PROFESSION_ID);
        this.field_6011.method_12784(HAS_TASK, (Object)false);
    }

    public IBaritone getBaritone() {
        return this.baritone;
    }

    @Override
    public class_3218 getServerWorld() {
        return (class_3218)this.method_37908();
    }

    @Override
    public String getClothingId() {
        return this.getProfessionId();
    }

    public MovementHelper getMovementHelper() {
        return this.movementHelper;
    }

    public float getDestroySpeed(class_2680 state) {
        float f = this.method_5998(class_1268.field_5808).method_7924(state);
        if (f > 1.0f) {
            int i = class_1890.method_8234((class_1309)this);
            class_1799 itemstack = this.method_6047();
            if (i > 0 && !itemstack.method_7960()) {
                f += (float)(i * i + 1);
            }
        }
        if (class_1292.method_5576((class_1309)this)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)this) + 1) * 0.2f;
        }
        if (this.method_6059(class_1294.field_5901)) {
            float f1 = switch (Optional.ofNullable(this.method_6112(class_1294.field_5901)).map(class_1293::method_5578).orElse(3)) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= f1;
        }
        if (this.method_5777(class_3486.field_15517) && !class_1890.method_8200((class_1309)this)) {
            f /= 5.0f;
        }
        if (!this.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new ColonistMeleeAttackGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1548.class, 5.0f, 1.5, 2.1));
        this.field_6201.method_6277(4, (class_1352)new FollowFortressAttackTargetGoal(this, 0.15f, 3.0f));
        this.field_6201.method_6277(5, (class_1352)new DailyProfessionTasksGoal(this));
        this.field_6201.method_6277(6, (class_1352)new ColonistExecuteTaskGoal(this));
        this.field_6201.method_6277(8, (class_1352)new WanderAroundTheFortressGoal(this));
        this.field_6201.method_6277(8, (class_1352)new SleepOnTheBedGoal(this));
        this.field_6201.method_6277(9, (class_1352)new ReturnToFireGoal(this));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new FortressRevengeGoal(this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new FortressColonistActiveTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new BuildingAttackerTargetGoal(this));
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26867(class_5134.field_23716).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23722, 0.0).method_26868(class_5134.field_23723, 2.0).method_26867(class_5134.field_23726);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (this.taskControl.hasTask()) {
            this.taskControl.fail();
        }
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        this.tickProfessionCheck();
        class_1309 target = this.method_5968();
        if (target != null && !target.method_5805()) {
            this.method_5980(null);
        }
    }

    private void tickProfessionCheck() {
        String professionId = (String)this.field_6011.method_12789(PROFESSION_ID);
        if (DEFAULT_PROFESSION_ID.equals(professionId) || RESERVE_PROFESSION_ID.equals(professionId)) {
            this.getManagersProvider().map(IServerManagersProvider::getProfessionsManager).flatMap(it -> it.getProfessionsWithAvailablePlaces(RESERVE_PROFESSION_ID.equals(professionId))).ifPresent(this::setProfession);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.taskControl != null) {
            this.setHasTask(this.taskControl.hasTask() || this.taskControl.isDoingEverydayTasks());
        }
        if ((this.isHalfInWall() || this.isEyesInTheWall()) && !this.method_6113()) {
            this.method_5993().method_6233();
        }
        this.tickAllControls();
    }

    private void tickAllControls() {
        if (this.getEatControl().map(IEatControl::isEating).orElse(false).booleanValue()) {
            return;
        }
        if (this.getDigControl() != null) {
            this.getDigControl().tick();
        }
        if (this.getPlaceControl() != null) {
            this.getPlaceControl().tick();
        }
        if (this.getScaffoldsControl() != null) {
            this.getScaffoldsControl().tick();
        }
        if (this.getMovementHelper() != null) {
            this.getMovementHelper().tick();
        }
    }

    private boolean isHalfInWall() {
        if (this.field_5960) {
            return false;
        }
        class_243 eyePosition = this.method_33571();
        class_243 legsPos = new class_243(eyePosition.field_1352, eyePosition.field_1351 - 1.0, eyePosition.field_1350);
        class_238 aabb = class_238.method_30048((class_243)legsPos, (double)this.method_17681(), (double)1.0E-6, (double)this.method_17681());
        return this.method_37908().method_20812((class_1297)this, aabb).iterator().hasNext();
    }

    public boolean isWallAboveTheHead() {
        if (this.field_5960) {
            return false;
        }
        class_238 legsBox = class_238.method_30048((class_243)this.method_19538(), (double)((double)this.method_17681() / 1.4), (double)0.5, (double)((double)this.method_17681() / 1.4));
        class_238 aboveTheHeadBox = legsBox.method_989(0.0, 2.5, 0.0);
        return this.method_37908().method_20812((class_1297)this, aboveTheHeadBox).iterator().hasNext();
    }

    public boolean isEyesInTheWall() {
        if (this.field_5960) {
            return false;
        }
        class_238 aabb = class_238.method_30048((class_243)this.method_33571(), (double)this.method_17681(), (double)1.0E-6, (double)this.method_17681());
        return this.method_37908().method_20812((class_1297)this, aabb).iterator().hasNext();
    }

    public DigControl getDigControl() {
        return this.digControl;
    }

    public PlaceControl getPlaceControl() {
        return this.placeControl;
    }

    public ScaffoldsControl getScaffoldsControl() {
        return this.scaffoldsControl;
    }

    public void resetControls() {
        this.digControl.reset();
        this.placeControl.reset();
        this.scaffoldsControl.clearResults();
        this.movementHelper.reset();
    }

    public boolean diggingOrPlacing() {
        return this.placeControl != null && this.placeControl.isWorking() || this.digControl != null && this.digControl.isWorking();
    }

    public void setGoal(ITaskBlockInfo taskBlockInfo) {
        this.goal = taskBlockInfo.getPos();
        class_1792 placingItem = taskBlockInfo.getPlacingItem();
        if (placingItem != null) {
            this.method_6122(class_1268.field_5808, new class_1799((class_1935)placingItem));
            this.placeControl.set(taskBlockInfo);
        } else {
            this.digControl.set(taskBlockInfo);
        }
    }

    public void lookAtGoal() {
        this.lookAt(this.goal);
    }

    public void lookAt(class_2338 pos) {
        if (pos == null) {
            return;
        }
        this.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public boolean method_5675() {
        return !this.hasTask();
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        String professionId = this.getProfessionId();
        if (!DEFAULT_PROFESSION_ID.equals(professionId)) {
            nbt.method_10582("professionId", professionId);
        }
    }

    @Override
    public String getProfessionId() {
        return (String)this.field_6011.method_12789(PROFESSION_ID);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("professionId")) {
            String professionId = nbt.method_10558("professionId");
            this.setProfession(professionId);
        }
    }

    public boolean isAllowToPlaceBlockFromFarAway() {
        return this.allowToPlaceBlockFromFarAway;
    }

    public void setAllowToPlaceBlockFromFarAway(boolean allowToPlaceBlockFromFarAway) {
        this.allowToPlaceBlockFromFarAway = allowToPlaceBlockFromFarAway;
    }

    public void setCurrentTaskDesc(String currentTaskDesc) {
        this.field_6011.method_12778(CURRENT_TASK_DESCRIPTION, (Object)currentTaskDesc);
    }

    public String getCurrentTaskDesc() {
        return (String)this.field_6011.method_12789(CURRENT_TASK_DESCRIPTION);
    }

    public void reserveColonist() {
        if (!this.getProfessionId().equals(DEFAULT_PROFESSION_ID)) {
            throw new IllegalStateException("Colonist cannot be reserved because it is already assigned to a profession");
        }
        this.setProfession(RESERVE_PROFESSION_ID);
    }

    public void setProfession(String professionId) {
        this.getManagersProvider().ifPresent(it -> {
            IServerProfessionsManager spm = it.getProfessionsManager();
            class_1299<? extends class_1309> type = spm.getEntityTypeForProfession(professionId);
            if (type == FortressEntities.COLONIST_ENTITY_TYPE) {
                this.field_6011.method_12778(PROFESSION_ID, (Object)professionId);
            } else if (type == FortressEntities.WARRIOR_PAWN_ENTITY_TYPE || type == FortressEntities.ARCHER_PAWN_ENTITY_TYPE) {
                this.getServerFortressManager().ifPresent(m -> m.replaceColonistWithTypedPawn((class_1309)this, professionId, type));
            }
            this.getServerFortressManager().ifPresent(IServerFortressManager::scheduleSync);
        });
    }

    @Override
    public void resetProfession() {
        this.setProfession(DEFAULT_PROFESSION_ID);
    }

    @Override
    public ITaskControl getTaskControl() {
        return this.taskControl;
    }

    private void setHasTask(boolean hasTask) {
        this.field_6011.method_12778(HAS_TASK, (Object)hasTask);
    }

    public boolean hasTask() {
        return (Boolean)this.field_6011.method_12789(HAS_TASK);
    }
}

