/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.entity;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IFortressAwareEntity;
import net.remmintan.mods.minefortress.core.interfaces.entities.pawns.IProfessional;
import org.jetbrains.annotations.Nullable;
import org.minefortress.entity.HungryEntity;
import org.minefortress.interfaces.FortressSlimeEntity;

public abstract class BasePawnEntity
extends HungryEntity
implements IFortressAwareEntity {
    public static final String FORTRESS_ID_NBT_KEY = "fortress_id";
    private static final String BODY_TEXTURE_ID_NBT_KEY = "body_texture_id";
    private static final class_2940<Optional<UUID>> MASTER_ID = class_2945.method_12791(BasePawnEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> BODY_TEXTURE_ID = class_2945.method_12791(BasePawnEntity.class, (class_2941)class_2943.field_13327);

    protected BasePawnEntity(class_1299<? extends BasePawnEntity> entityType, class_1937 world, boolean enableHunger) {
        super(entityType, world, enableHunger);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MASTER_ID, Optional.empty());
        this.field_6011.method_12784(BODY_TEXTURE_ID, (Object)new Random().nextInt(4));
    }

    public int getBodyTextureId() {
        return (Integer)this.field_6011.method_12789(BODY_TEXTURE_ID);
    }

    public String getClothingId() {
        BasePawnEntity basePawnEntity = this;
        if (basePawnEntity instanceof IProfessional) {
            IProfessional prof = (IProfessional)((Object)basePawnEntity);
            return prof.getProfessionId();
        }
        return "colonist";
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (entityNbt == null) {
            throw new IllegalStateException("Entity nbt cannot be null");
        }
        UUID masterPlayerId = entityNbt.method_25926(FORTRESS_ID_NBT_KEY);
        this.setMasterId(masterPlayerId);
        this.addThisPawnToFortress();
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private void addThisPawnToFortress() {
        this.getServerFortressManager().ifPresent(fsm -> fsm.addColonist((class_1309)this));
    }

    private void setMasterId(UUID fortressId) {
        this.field_6011.method_12778(MASTER_ID, Optional.ofNullable(fortressId));
    }

    @Override
    public Optional<UUID> getMasterId() {
        return (Optional)this.field_6011.method_12789(MASTER_ID);
    }

    @Nullable
    public final class_1657 getPlayer() {
        return this.getMasterPlayer().orElse(null);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.getMasterId().ifPresent(it -> nbt.method_25927(FORTRESS_ID_NBT_KEY, it));
        nbt.method_10569(BODY_TEXTURE_ID_NBT_KEY, this.getBodyTextureId());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(FORTRESS_ID_NBT_KEY)) {
            UUID fortressId = nbt.method_25926(FORTRESS_ID_NBT_KEY);
            this.setMasterId(fortressId);
            this.addThisPawnToFortress();
        }
        if (nbt.method_10545(BODY_TEXTURE_ID_NBT_KEY)) {
            int bodyTexId = nbt.method_10550(BODY_TEXTURE_ID_NBT_KEY);
            this.field_6011.method_12778(BODY_TEXTURE_ID, (Object)bodyTexId);
        }
    }

    public final boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_49708(class_8111.field_42345)) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public boolean method_17326() {
        return true;
    }

    public void method_6007() {
        super.method_6119();
        super.method_6007();
        class_238 boundingBox = this.method_5829();
        List touchingSlimes = this.method_37908().method_8390(class_1621.class, boundingBox, slimeEntity -> true);
        touchingSlimes.forEach(s -> ((FortressSlimeEntity)s).touch_Pawn(this));
    }

    @Override
    @Nullable
    public MinecraftServer method_5682() {
        return super.method_5682();
    }

    public int getAttackCooldown() {
        return 15;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1309.method_26827().method_26867(class_5134.field_23716).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23717, 2.0).method_26867(class_5134.field_23722).method_26867(class_5134.field_23723).method_26867(class_5134.field_23726);
    }
}

