/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.world;

import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2761;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_3222;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_3324;
import net.minecraft.class_3481;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7712;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.world.IBlueprintsWorld;
import net.remmintan.mods.minefortress.core.interfaces.server.IBlueprintEditingWorld;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressServer;
import net.remmintan.mods.minefortress.core.utils.ModPathUtils;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;
import org.minefortress.blueprints.world.FortressServerWorld;

public class BlueprintsWorld
implements IBlueprintsWorld {
    private static final class_1928 EDIT_BLUEPRINT_RULES = (class_1928)class_156.method_654((Object)new class_1928(), gameRules -> {
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19390)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19406)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19396)).method_20758(false, null);
    });
    private static final class_1940 EDIT_BLUEPRINT_LEVEL = new class_1940("Edit Blueprint Level", class_1934.field_9220, false, class_1267.field_5801, false, EDIT_BLUEPRINT_RULES, class_7712.field_40260);
    private static final class_2960 BLUEPRINTS_WORLD_ID = new class_2960("blueprints");
    public static final class_5321<class_1937> BLUEPRINTS_WORLD_REGISTRY_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)BLUEPRINTS_WORLD_ID);
    private static final class_2874 BLUEPRINT_DIMENSION_TYPE = new class_2874(OptionalLong.of(10000L), true, false, false, false, 1.0, false, true, 0, 32, 16, class_3481.field_25588, BLUEPRINTS_WORLD_ID, 0.0f, new class_2874.class_7512(false, false, (class_6017)class_6019.method_35017((int)0, (int)7), 0));
    private FortressServerWorld world;
    private final MinecraftServer server;
    private Map<class_2338, class_2680> preparedBlueprintData;
    private class_32.class_5143 fortressSession = null;

    public BlueprintsWorld(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public IBlueprintEditingWorld getWorld() {
        if (this.world == null) {
            this.create();
        }
        return this.world;
    }

    public void tick(BooleanSupplier shouldKeepTicking) {
        if (this.world != null) {
            this.world.method_18765(shouldKeepTicking);
        }
    }

    public void sendToDimension(class_3324 playerManager) {
        if (this.world != null) {
            playerManager.method_14589((class_2596)new class_2761(this.world.method_8510(), this.world.method_8532(), this.world.method_8450().method_8355(class_1928.field_19396)), this.world.method_27983());
        }
    }

    private void create() {
        ExecutorService executor = class_156.method_18349();
        class_5455.class_6890 dynamicRegistryManager = this.server.method_30611();
        this.fortressSession = ModPathUtils.getInstance().getBlueprintsWorldSession();
        class_2378 biomeRegistry = dynamicRegistryManager.method_30530(class_7924.field_41236);
        class_2378 dimensionTypeRegistry = dynamicRegistryManager.method_30530(class_7924.field_41241);
        class_2897 chunkGenerator = new class_2897(BlueprintsWorld.getGeneratorConfig((class_2378<class_1959>)biomeRegistry));
        class_5285 generatorOptions = new class_5285(0L, false, false);
        class_31 levelProperties = new class_31(EDIT_BLUEPRINT_LEVEL, generatorOptions, class_31.class_7729.field_40374, Lifecycle.stable());
        this.world = new FortressServerWorld(this.server, executor, this.fortressSession, levelProperties, BLUEPRINTS_WORLD_REGISTRY_KEY, new class_5363((class_6880)dimensionTypeRegistry.method_40264(class_7134.field_37666).orElseThrow(), (class_2794)chunkGenerator), ((IFortressServer)this.server).get_WorldGenerationProgressListener());
    }

    public static class_3232 getGeneratorConfig(class_2378<class_1959> biomeRegistry) {
        List<class_3229> flatChunkGeneratorLayers = Arrays.asList(new class_3229(1, class_2246.field_9987), new class_3229(14, class_2246.field_10566), new class_3229(1, class_2246.field_10219));
        return new class_3232(Optional.empty(), (class_6880)biomeRegistry.method_40264(class_1972.field_9451).orElseThrow(), Collections.emptyList()).method_46727(flatChunkGeneratorLayers, Optional.empty(), (class_6880)biomeRegistry.method_40264(class_1972.field_9451).orElseThrow());
    }

    @Override
    public void prepareBlueprint(Map<class_2338, class_2680> blueprintData, String blueprintFileName, int floorLevel, BlueprintGroup group) {
        this.preparedBlueprintData = blueprintData;
        IBlueprintEditingWorld world = this.getWorld();
        world.setFileName(blueprintFileName);
        world.setFloorLevel(floorLevel);
        world.setBlueprintGroup(group);
    }

    @Override
    public void clearBlueprint(class_3222 player) {
        this.preparedBlueprintData = new HashMap<class_2338, class_2680>();
        this.putBlueprintInAWorld(player, new class_2382(1, 1, 1));
    }

    @Override
    public void putBlueprintInAWorld(class_3222 player, class_2382 blueprintSize) {
        class_2680 borderBlockState = class_2246.field_10314.method_9564();
        int xOffset = (16 - blueprintSize.method_10263()) / 2;
        int zOffset = (16 - blueprintSize.method_10260()) / 2;
        int defaultFloorLevel = 16;
        class_2338.method_10097((class_2338)new class_2338(-32, 0, -32), (class_2338)new class_2338(32, 32, 32)).forEach(pos -> {
            class_2338 offsetPos = pos.method_10087(16 - this.getWorld().getFloorLevel()).method_10069(-xOffset, 0, -zOffset);
            class_2680 blockState = this.preparedBlueprintData.containsKey(offsetPos) ? this.preparedBlueprintData.get(offsetPos) : (pos.method_10264() >= 16 ? class_2246.field_10124.method_9564() : (pos.method_10264() == 0 ? class_2246.field_9987.method_9564() : (pos.method_10264() > 0 && pos.method_10264() < 14 ? class_2246.field_10566.method_9564() : class_2246.field_10219.method_9564())));
            this.world.method_8501((class_2338)pos, blockState);
            this.world.method_33596((class_1297)player, class_5712.field_28164, (class_2338)pos);
        });
        class_2338.method_10097((class_2338)new class_2338(-1, 15, -1), (class_2338)new class_2338(16, 15, 16)).forEach(pos -> {
            if (pos.method_10260() == -1 || pos.method_10260() == 16 || pos.method_10263() == -1 || pos.method_10263() == 16) {
                this.world.method_8501((class_2338)pos, borderBlockState);
                this.world.method_33596((class_1297)player, class_5712.field_28164, (class_2338)pos);
            }
        });
        class_2338.method_10097((class_2338)new class_2338(16, 15, 16), (class_2338)new class_2338(16, 31, 16)).forEach(pos -> {
            this.world.method_8501((class_2338)pos, borderBlockState);
            this.world.method_33596((class_1297)player, class_5712.field_28164, (class_2338)pos);
        });
    }

    @Override
    public void closeSession() {
        if (this.fortressSession != null) {
            try {
                this.fortressSession.close();
            }
            catch (IOException e) {
                LogManager.getLogger().error("Failed to unlock level {}", (Object)this.fortressSession.method_27005(), (Object)e);
            }
        }
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public static boolean isBlueprintsWorld(@Nullable class_1937 world) {
        return world != null && world.method_27983().equals(BLUEPRINTS_WORLD_REGISTRY_KEY);
    }
}

