/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.manager;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IServerBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IServerStructureBlockDataManager;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundAddBlueprintPacket;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundResetBlueprintPacket;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundUpdateBlueprintPacket;
import org.minefortress.blueprints.data.ServerStructureBlockDataManager;
import org.minefortress.blueprints.manager.BlueprintMetadataReader;
import org.minefortress.blueprints.world.FortressServerWorld;
import org.minefortress.tasks.BlueprintDigTask;
import org.minefortress.tasks.BlueprintTask;
import org.minefortress.tasks.SimpleSelectionTask;

public class ServerBlueprintManager
implements IServerBlueprintManager {
    private boolean initialized = false;
    private final ServerStructureBlockDataManager blockDataManager;
    private final BlueprintMetadataReader blueprintMetadataReader;
    private final Queue<FortressS2CPacket> scheduledEdits = new ArrayDeque<FortressS2CPacket>();

    public ServerBlueprintManager(MinecraftServer server, Supplier<UUID> userIdProvider) {
        this.blueprintMetadataReader = new BlueprintMetadataReader(server);
        this.blockDataManager = new ServerStructureBlockDataManager(server, this.blueprintMetadataReader::convertFilenameToGroup, userIdProvider);
    }

    @Override
    public void tick(class_3222 player) {
        if (!this.initialized) {
            this.blueprintMetadataReader.read();
            this.scheduledEdits.clear();
            ClientboundResetBlueprintPacket resetpacket = new ClientboundResetBlueprintPacket();
            FortressServerNetworkHelper.send(player, "fortress_reset_blueprint", resetpacket);
            for (Map.Entry<BlueprintGroup, List<IBlueprintMetadata>> entry : this.blueprintMetadataReader.getPredefinedBlueprints().entrySet()) {
                for (IBlueprintMetadata blueprintMetadata : entry.getValue()) {
                    String file = blueprintMetadata.getId();
                    this.blockDataManager.getStructureNbt(file).ifPresent(it -> {
                        int floorLevel = this.blockDataManager.getFloorLevel(file).orElse(blueprintMetadata.getFloorLevel());
                        ClientboundAddBlueprintPacket packet = new ClientboundAddBlueprintPacket((BlueprintGroup)((Object)((Object)entry.getKey())), blueprintMetadata.getName(), file, floorLevel, blueprintMetadata.getRequirementId(), (class_2487)it);
                        FortressServerNetworkHelper.send(player, "fortress_add_blueprint", packet);
                    });
                }
            }
            List<FortressS2CPacket> initPackets = this.blockDataManager.getInitPackets();
            this.scheduledEdits.addAll(initPackets);
            this.initialized = true;
        }
        if (!this.scheduledEdits.isEmpty()) {
            FortressS2CPacket packet = this.scheduledEdits.remove();
            if (packet instanceof ClientboundUpdateBlueprintPacket) {
                FortressServerNetworkHelper.send(player, "fortress_update_blueprint", packet);
            } else if (packet instanceof ClientboundAddBlueprintPacket) {
                FortressServerNetworkHelper.send(player, "fortress_add_blueprint", packet);
            } else {
                throw new IllegalStateException("Wrong blueprint update packet type: " + packet.getClass());
            }
        }
    }

    @Override
    public void update(String fileName, class_2487 updatedStructure, int newFloorLevel, BlueprintGroup group) {
        boolean existed = this.blockDataManager.update(fileName, updatedStructure, newFloorLevel, group);
        FortressS2CPacket packet = existed ? ClientboundUpdateBlueprintPacket.edit(fileName, newFloorLevel, updatedStructure) : new ClientboundAddBlueprintPacket(group, fileName, fileName, newFloorLevel, "custom", updatedStructure);
        this.scheduledEdits.add(packet);
    }

    @Override
    public void remove(String name) {
        this.blockDataManager.remove(name);
        ClientboundUpdateBlueprintPacket remove = ClientboundUpdateBlueprintPacket.remove(name);
        this.scheduledEdits.add(remove);
    }

    @Override
    public IServerStructureBlockDataManager getBlockDataManager() {
        return this.blockDataManager;
    }

    @Override
    public BlueprintTask createTask(UUID taskId, String blueprintId, class_2338 startPos, class_2470 rotation, int floorLevel) {
        String requirementId = this.findRequirementById(blueprintId).orElse("custom");
        IStructureBlockData serverStructureInfo = this.blockDataManager.getBlockData(blueprintId, rotation, floorLevel);
        class_2382 size = serverStructureInfo.getSize();
        startPos = startPos.method_10087(floorLevel);
        class_2338 endPos = ServerBlueprintManager.getEndPos(startPos, size);
        Map<class_2338, class_2680> manualLayer = serverStructureInfo.getLayer(BlueprintDataLayer.MANUAL);
        Map<class_2338, class_2680> automatic = serverStructureInfo.getLayer(BlueprintDataLayer.AUTOMATIC);
        Map<class_2338, class_2680> entityLayer = serverStructureInfo.getLayer(BlueprintDataLayer.ENTITY);
        return new BlueprintTask(taskId, startPos, endPos, manualLayer, automatic, entityLayer, floorLevel, requirementId, blueprintId);
    }

    @Override
    public SimpleSelectionTask createDigTask(UUID uuid, class_2338 startPos, int floorLevel, String structureFile, class_2470 rotation) {
        IStructureBlockData serverStructureInfo = this.blockDataManager.getBlockData(structureFile, rotation);
        class_2382 size = serverStructureInfo.getSize();
        startPos = startPos.method_10087(floorLevel);
        class_2338 endPos = ServerBlueprintManager.getEndPos(startPos, size);
        return new BlueprintDigTask(uuid, startPos, endPos);
    }

    private static class_2338 getEndPos(class_2338 startPos, class_2382 size) {
        return startPos.method_10081(new class_2382(size.method_10263() - 1, size.method_10264() - 1, size.method_10260() - 1));
    }

    @Override
    public void write() {
        this.blockDataManager.writeBlockDataManager();
    }

    @Override
    public void read() {
        this.read(null);
        this.initialized = false;
    }

    @Override
    public void read(class_2487 compound) {
        this.blockDataManager.readBlockDataManager(compound);
    }

    @Override
    public void finishBlueprintEdit(boolean shouldSave, MinecraftServer server, class_3222 player) {
        FortressServerWorld fortressServerWorld = (FortressServerWorld)player.method_37908();
        String fileName = fortressServerWorld.getFileName();
        class_2960 updatedStructureIdentifier = new class_2960("minefortress", fileName.replaceAll("[^a-z0-9/._-]", "_"));
        class_3485 structureManager = server.method_27727();
        class_3499 structureToUpdate = structureManager.method_15091(updatedStructureIdentifier);
        fortressServerWorld.enableSaveStructureMode();
        class_2338 start = new class_2338(0, 1, 0);
        class_2338 end = new class_2338(15, 32, 15);
        Iterable allPositions = class_2338.method_10097((class_2338)start, (class_2338)end);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : allPositions) {
            int y;
            class_2680 blockState = fortressServerWorld.method_8320(pos);
            if (!this.isStateWasChanged(blockState, y = pos.method_10264())) continue;
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        class_2338 min = new class_2338(minX, minY, minZ);
        class_2338 max = new class_2338(maxX, maxY, maxZ);
        class_2338 dimensions = max.method_10059((class_2382)min).method_10069(1, 1, 1);
        structureToUpdate.method_15174((class_1937)fortressServerWorld, min, (class_2382)dimensions, true, class_2246.field_10243);
        fortressServerWorld.disableSaveStructureMode();
        int newFloorLevel = 16 - min.method_10264();
        class_2487 updatedStructure = new class_2487();
        structureToUpdate.method_15175(updatedStructure);
        this.update(fileName, updatedStructure, newFloorLevel, fortressServerWorld.getBlueprintGroup());
    }

    private boolean isStateWasChanged(class_2680 blockState, int y) {
        if (blockState.method_27852(class_2246.field_10243)) {
            return false;
        }
        if (y > 15) {
            return !blockState.method_26215();
        }
        if (y == 15) {
            return !blockState.method_27852(class_2246.field_10219);
        }
        return !blockState.method_27852(class_2246.field_10566);
    }

    private Optional<String> findRequirementById(String blueprintId) {
        return this.blueprintMetadataReader.getPredefinedBlueprints().values().stream().flatMap(Collection::stream).filter(blueprintMetadata -> blueprintMetadata.getId().equals(blueprintId)).findFirst().map(IBlueprintMetadata::getRequirementId);
    }
}

