/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.manager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadataManager;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IClientBlueprintManager;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundBlueprintTaskPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;
import org.minefortress.blueprints.data.ClientStructureBlockDataProvider;
import org.minefortress.blueprints.manager.BaseClientStructureManager;
import org.minefortress.blueprints.manager.BlueprintMetadataManager;
import org.minefortress.interfaces.IFortressMinecraftClient;
import org.minefortress.renderer.gui.blueprints.BlueprintsScreen;
import org.minefortress.renderer.gui.blueprints.ImportExportBlueprintsScreen;
import org.minefortress.utils.ModUtils;
import org.slf4j.LoggerFactory;

public final class ClientBlueprintManager
extends BaseClientStructureManager
implements IClientBlueprintManager {
    private final class_310 client;
    private final ClientStructureBlockDataProvider blockDataManager = new ClientStructureBlockDataProvider();
    private final IBlueprintMetadataManager blueprintMetadataManager = new BlueprintMetadataManager();
    private IBlueprintMetadata selectedStructure;

    public ClientBlueprintManager(class_310 client) {
        super(client);
        this.client = client;
    }

    @Override
    public boolean isSelecting() {
        return this.selectedStructure != null;
    }

    @Override
    public void handleBlueprintsImport() {
        this.success();
    }

    @Override
    public void handleBlueprintsExport(String name, byte[] bytes) {
        Path path;
        File file;
        Path blueprintsFolder = ModUtils.getBlueprintsFolder();
        if (!blueprintsFolder.toFile().exists()) {
            blueprintsFolder.toFile().mkdirs();
        }
        if (!(file = (path = blueprintsFolder.resolve(name)).toFile()).exists()) {
            try {
                file.createNewFile();
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.handleImportExportFailure();
                return;
            }
        }
        this.success();
    }

    @Override
    public void handleImportExportFailure() {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof ImportExportBlueprintsScreen) {
            ImportExportBlueprintsScreen iebs = (ImportExportBlueprintsScreen)currentScreen;
            iebs.fail();
        }
    }

    private void success() {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof ImportExportBlueprintsScreen) {
            ImportExportBlueprintsScreen iebs = (ImportExportBlueprintsScreen)currentScreen;
            iebs.success();
        }
    }

    @Override
    public void select(IBlueprintMetadata blueprintMetadata) {
        this.selectedStructure = blueprintMetadata;
        this.blueprintMetadataManager.select(blueprintMetadata);
    }

    @Override
    public void selectNext() {
        if (!this.isSelecting()) {
            return;
        }
        this.selectedStructure = this.blueprintMetadataManager.selectNext();
    }

    @Override
    public List<IBlueprintMetadata> getAllBlueprints(BlueprintGroup group) {
        return this.blueprintMetadataManager.getAllForGroup(group);
    }

    @Override
    public void buildCurrentStructure() {
        if (this.selectedStructure == null) {
            LoggerFactory.getLogger(ClientBlueprintManager.class).error("No structure selected");
            return;
        }
        if (super.getStructureRenderPos().isEmpty()) {
            LoggerFactory.getLogger(ClientBlueprintManager.class).error("No position selected");
            return;
        }
        if (!super.canBuild()) {
            return;
        }
        UUID taskId = UUID.randomUUID();
        this.addTaskToTasksHolder(taskId);
        ServerboundBlueprintTaskPacket serverboundBlueprintTaskPacket = new ServerboundBlueprintTaskPacket(taskId, this.selectedStructure.getId(), this.getStructureBuildPos(), this.selectedStructure.getRotation(), this.getSelectedStructure().getFloorLevel());
        FortressClientNetworkHelper.send("new_blueprint_task", serverboundBlueprintTaskPacket);
        if (!this.client.field_1690.field_1867.method_1434()) {
            this.clearStructure();
        }
    }

    @Override
    public void clearStructure() {
        this.selectedStructure = null;
    }

    @Override
    public IBlueprintMetadata getSelectedStructure() {
        return this.selectedStructure;
    }

    @Override
    public IBlueprintMetadataManager getBlueprintMetadataManager() {
        return this.blueprintMetadataManager;
    }

    @Override
    public void rotateSelectedStructureClockwise() {
        if (this.selectedStructure == null) {
            throw new IllegalStateException("No blueprint selected");
        }
        this.selectedStructure.rotateRight();
    }

    @Override
    public void rotateSelectedStructureCounterClockwise() {
        if (this.selectedStructure == null) {
            throw new IllegalStateException("No blueprint selected");
        }
        this.selectedStructure.rotateLeft();
    }

    @Override
    public IBlockDataProvider getBlockDataProvider() {
        return this.blockDataManager;
    }

    @Override
    public void add(BlueprintGroup group, String name, String file, int floorLevel, String requirementId, class_2487 tag) {
        IBlueprintMetadata metadata = this.blueprintMetadataManager.add(group, name, file, floorLevel, requirementId);
        this.blockDataManager.setBlueprint(metadata.getId(), tag);
        this.blockDataManager.invalidateBlueprint(metadata.getId());
    }

    @Override
    public void update(String fileName, class_2487 tag, int newFloorLevel) {
        this.blueprintMetadataManager.update(fileName, newFloorLevel);
        this.blockDataManager.setBlueprint(fileName, tag);
        this.blockDataManager.invalidateBlueprint(fileName);
        class_310 class_3102 = this.client;
        if (class_3102 instanceof IFortressMinecraftClient) {
            IFortressMinecraftClient fortressClient = (IFortressMinecraftClient)class_3102;
            fortressClient.get_BlueprintRenderer().getBlueprintsModelBuilder().invalidateBlueprint(fileName);
        }
    }

    @Override
    public void remove(String filename) {
        this.blueprintMetadataManager.remove(filename);
        this.blockDataManager.removeBlueprint(filename);
        this.blockDataManager.invalidateBlueprint(filename);
    }

    @Override
    public void reset() {
        this.clearStructure();
        this.blueprintMetadataManager.reset();
        this.blockDataManager.reset();
        class_310 class_3102 = this.client;
        if (class_3102 instanceof IFortressMinecraftClient) {
            IFortressMinecraftClient fortressClient = (IFortressMinecraftClient)class_3102;
            try {
                fortressClient.get_BlueprintRenderer().getBlueprintsModelBuilder().reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateSlotsInBlueprintsScreen() {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof BlueprintsScreen) {
            BlueprintsScreen bps = (BlueprintsScreen)currentScreen;
            bps.updateSlots();
        }
    }
}

