/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.manager;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import org.minefortress.blueprints.manager.BlueprintMetadata;

public class BlueprintMetadataReader {
    private static final class_2960 PREDEFINED_BLUEPRINTS_ID = new class_2960("minefortress", "predefined_blueprints.json");
    private final Map<BlueprintGroup, List<IBlueprintMetadata>> predefinedBlueprints = new HashMap<BlueprintGroup, List<IBlueprintMetadata>>();
    private final MinecraftServer server;

    public BlueprintMetadataReader(MinecraftServer server) {
        this.server = server;
    }

    void read() {
        this.predefinedBlueprints.clear();
        class_3300 resourceManager = this.server.method_34864();
        class_3298 resource = (class_3298)resourceManager.method_14486(PREDEFINED_BLUEPRINTS_ID).orElseThrow();
        try (InputStreamReader isr = new InputStreamReader(resource.method_14482());
             JsonReader jsonReader = new JsonReader((Reader)isr);){
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                BlueprintGroup blueprintGroup = BlueprintGroup.valueOf(jsonReader.nextName());
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    IBlueprintMetadata blueprintMetadata = this.readBlueprintMetadata(jsonReader);
                    this.predefinedBlueprints.computeIfAbsent(blueprintGroup, k -> new ArrayList()).add(blueprintMetadata);
                }
                jsonReader.endArray();
            }
            jsonReader.endObject();
        }
        catch (IOException exp) {
            throw new RuntimeException("Failed to read predefined blueprints", exp);
        }
    }

    Map<BlueprintGroup, List<IBlueprintMetadata>> getPredefinedBlueprints() {
        return Map.copyOf(this.predefinedBlueprints);
    }

    private IBlueprintMetadata readBlueprintMetadata(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        String name = null;
        String file = null;
        String requirementId = null;
        int floorLevel = 0;
        block12: while (jsonReader.hasNext()) {
            String propertyName;
            switch (propertyName = jsonReader.nextName()) {
                case "name": {
                    name = jsonReader.nextString();
                    continue block12;
                }
                case "file": {
                    file = jsonReader.nextString();
                    continue block12;
                }
                case "floorLevel": {
                    floorLevel = jsonReader.nextInt();
                    continue block12;
                }
                case "requirementId": {
                    requirementId = jsonReader.nextString();
                    continue block12;
                }
            }
            throw new RuntimeException("Unknown property " + propertyName);
        }
        jsonReader.endObject();
        return new BlueprintMetadata(name, file, floorLevel, requirementId);
    }

    public Optional<BlueprintGroup> convertFilenameToGroup(String filename) {
        for (Map.Entry<BlueprintGroup, List<IBlueprintMetadata>> entry : this.predefinedBlueprints.entrySet()) {
            if (!entry.getValue().stream().anyMatch(it -> it.getId().equals(filename))) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }
}

