/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadataManager;
import org.minefortress.blueprints.manager.BlueprintMetadata;

public final class BlueprintMetadataManager
implements IBlueprintMetadataManager {
    private final Map<BlueprintGroup, List<IBlueprintMetadata>> blueprintsMap = new HashMap<BlueprintGroup, List<IBlueprintMetadata>>();
    private int index = 0;

    @Override
    public void select(IBlueprintMetadata metadata) {
        this.index = this.flatBlueprints().indexOf(metadata);
    }

    @Override
    public IBlueprintMetadata selectNext() {
        ++this.index;
        if (this.index >= this.flatBlueprints().size()) {
            this.index = 0;
        }
        return this.flatBlueprints().get(this.index);
    }

    @Override
    public List<IBlueprintMetadata> getAllForGroup(BlueprintGroup group) {
        return this.blueprintsMap.getOrDefault((Object)group, Collections.emptyList());
    }

    @Override
    public IBlueprintMetadata add(BlueprintGroup group, String name, String file, int floorLevel, String requirementId) {
        if (this.isContainsBlueprint(name, file)) {
            throw new IllegalArgumentException("Blueprint with areaType " + name + " and file " + file + " already exists");
        }
        BlueprintMetadata metadata = new BlueprintMetadata(name, file, floorLevel, requirementId);
        this.blueprintsMap.computeIfAbsent(group, k -> new ArrayList()).add(metadata);
        return metadata;
    }

    @Override
    public void reset() {
        this.blueprintsMap.clear();
        this.index = 0;
    }

    @Override
    public void remove(String filename) {
        this.blueprintsMap.forEach((k, v) -> v.removeIf(it -> it.getId().equals(filename)));
    }

    @Override
    public void update(String fileName, int newFloorLevel) {
        this.flatBlueprints().stream().filter(b -> b.getId().equals(fileName)).forEach(b -> b.setFloorLevel(newFloorLevel));
    }

    private boolean isContainsBlueprint(String name, String file) {
        return this.flatBlueprints().stream().anyMatch(b -> b.getName().equals(name) && b.getId().equals(file));
    }

    private List<IBlueprintMetadata> flatBlueprints() {
        return this.blueprintsMap.values().stream().flatMap(Collection::stream).toList();
    }

    @Override
    public Optional<IBlueprintMetadata> getByBlueprintId(String blueprintId) {
        if (blueprintId == null) {
            return Optional.empty();
        }
        return this.flatBlueprints().stream().filter(b -> b.getId().equals(blueprintId)).findFirst();
    }
}

