/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.manager;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureRenderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import org.jetbrains.annotations.Nullable;
import org.minefortress.utils.ModUtils;

public abstract class BaseClientStructureManager
implements IStructureRenderInfoProvider {
    private final class_310 client;
    private boolean enoughResources = true;
    private boolean cantBuild = false;
    private class_2338 structureBuildPos = null;

    protected BaseClientStructureManager(class_310 client) {
        this.client = client;
    }

    protected abstract IBlockDataProvider getBlockDataProvider();

    @Override
    public abstract IBlueprintMetadata getSelectedStructure();

    public void tick() {
        if (!this.isSelecting()) {
            return;
        }
        this.structureBuildPos = this.getSelectedPos();
        if (this.structureBuildPos == null) {
            return;
        }
        this.checkNotEnoughResources();
        this.checkCantBuild();
    }

    protected class_2338 getStructureBuildPos() {
        return this.structureBuildPos;
    }

    private void checkNotEnoughResources() {
        IClientFortressManager fortressClientManager = ((IClientManagersProvider)this.client).get_ClientFortressManager();
        if (fortressClientManager.isSurvival()) {
            IClientResourceManager resourceManager = fortressClientManager.getResourceManager();
            List<IItemInfo> stacks = this.getBlockData().getStacks();
            this.enoughResources = resourceManager.hasItems(stacks);
        } else {
            this.enoughResources = true;
        }
    }

    protected boolean isEnoughResources() {
        return this.enoughResources;
    }

    private void checkCantBuild() {
        if (!this.enoughResources) {
            this.cantBuild = true;
            return;
        }
        IStructureBlockData blockData = this.getBlockData();
        Set blueprintDataPositions = blockData.getLayer(BlueprintDataLayer.GENERAL).entrySet().stream().filter(entry -> !((class_2680)entry.getValue()).method_26215()).map(Map.Entry::getKey).collect(Collectors.toSet());
        int floorLevel = this.getSelectedStructure().getFloorLevel();
        Optional<class_2784> fortressBorder = ModUtils.getInfluenceManager().getFortressBorder();
        boolean blueprintPartInTheSurface = blueprintDataPositions.stream().filter(blockPos -> blockPos.method_10264() >= floorLevel).map(pos -> pos.method_10081((class_2382)this.structureBuildPos.method_10087(floorLevel))).anyMatch(pos -> !BuildingHelper.canPlaceBlock((class_1937)this.client.field_1687, pos) || fortressBorder.map(border -> !border.method_11952(pos)).orElse(false) != false);
        boolean blueprintPartInTheAir = blueprintDataPositions.stream().filter(blockPos -> {
            int y = blockPos.method_10264();
            return y <= floorLevel;
        }).map(pos -> pos.method_10081((class_2382)this.structureBuildPos.method_10087(floorLevel))).anyMatch(pos -> BuildingHelper.canPlaceBlock((class_1937)this.client.field_1687, pos.method_10074()) || fortressBorder.map(border -> !border.method_11952(pos)).orElse(false) != false);
        this.cantBuild = blueprintPartInTheSurface || blueprintPartInTheAir;
    }

    private IStructureBlockData getBlockData() {
        IBlockDataProvider blockDataProvider = this.getBlockDataProvider();
        IBlueprintMetadata selectedStructure = this.getSelectedStructure();
        return blockDataProvider.getBlockData(selectedStructure.getId(), selectedStructure.getRotation());
    }

    @Nullable
    private class_2338 getSelectedPos() {
        class_239 class_2392 = this.client.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 crosshairTarget = (class_3965)class_2392;
            class_2338 originalPos = crosshairTarget.method_17777();
            if (this.client.field_1687 != null && originalPos != null && this.client.field_1687.method_8320(originalPos).method_26215()) {
                return null;
            }
            if (originalPos != null) {
                return this.moveToStructureSize(originalPos);
            }
        }
        return null;
    }

    private class_2338 moveToStructureSize(class_2338 pos) {
        if (this.getSelectedStructure() == null) {
            return pos;
        }
        boolean posSolid = !BuildingHelper.doesNotHaveCollisions((class_1936)this.client.field_1687, pos);
        IStructureBlockData blockData = this.getBlockData();
        class_2382 size = blockData.getSize();
        class_2382 halfSize = new class_2382(size.method_10263() / 2, 0, size.method_10260() / 2);
        class_2338 movedPos = pos.method_10059(halfSize);
        movedPos = posSolid ? movedPos.method_10084() : movedPos;
        return movedPos;
    }

    @Override
    public final Optional<class_2338> getStructureRenderPos() {
        Integer floorLevel = Optional.ofNullable(this.getSelectedStructure()).map(IBlueprintMetadata::getFloorLevel).orElse(0);
        return Optional.ofNullable(this.structureBuildPos).map(it -> it.method_10087(floorLevel.intValue()));
    }

    @Override
    public boolean canBuild() {
        return !this.cantBuild;
    }

    protected void addTaskToTasksHolder(UUID taskId) {
        ITasksInformationHolder world = (ITasksInformationHolder)this.client.field_1687;
        if (world != null) {
            IStructureBlockData blockData = this.getBlockData();
            Map<class_2338, class_2680> structureData = blockData.getLayer(BlueprintDataLayer.GENERAL);
            int floorLevel = this.getSelectedStructure().getFloorLevel();
            List<class_2338> blocks = structureData.entrySet().stream().filter(entry -> !((class_2680)entry.getValue()).method_26215()).map(Map.Entry::getKey).map(it -> it.method_10081((class_2382)this.structureBuildPos.method_10087(floorLevel))).collect(Collectors.toList());
            world.get_ClientTasksHolder().addTask(taskId, blocks);
        }
    }

    protected void reset() {
        this.structureBuildPos = null;
        this.cantBuild = false;
        this.enoughResources = true;
        this.getBlockDataProvider().reset();
    }
}

