/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import org.jetbrains.annotations.NotNull;
import org.minefortress.fortress.resources.ItemInfo;
import org.minefortress.fortress.resources.SimilarItemsHelper;
import org.spongepowered.include.com.google.common.collect.Sets;

public final class StructureBlockData
implements IStructureBlockData {
    public static final Set<class_1792> IGNORED_ITEMS;
    private final class_2382 size;
    private final Map<BlueprintDataLayer, Map<class_2338, class_2680>> layers = new HashMap<BlueprintDataLayer, Map<class_2338, class_2680>>();
    private List<IItemInfo> stacks;

    private StructureBlockData(class_2382 size) {
        this.size = size;
    }

    @Override
    public boolean hasLayer(BlueprintDataLayer layer) {
        return this.layers.containsKey((Object)layer);
    }

    @Override
    public Map<class_2338, class_2680> getLayer(BlueprintDataLayer layer) {
        return this.layers.get((Object)layer);
    }

    @Override
    public class_2382 getSize() {
        return this.size;
    }

    @Override
    public List<IItemInfo> getStacks() {
        return this.stacks;
    }

    static Builder withBlueprintSize(class_2382 blueprintSize) {
        return new Builder(blueprintSize);
    }

    static {
        HashSet items = Sets.newHashSet((Object[])new class_1792[]{class_1802.field_8162, class_1802.field_8615, class_1802.field_8077, class_1802.field_8831, class_1802.field_8270, class_1802.field_8519, class_1802.field_8258, class_1802.field_8059, class_1802.field_8349, class_1802.field_8286, class_1802.field_8863, class_1802.field_8679, class_1802.field_8417, class_1802.field_8754, class_1802.field_8146, class_1802.field_8390, class_1802.field_8262, class_1802.field_8893, class_1802.field_8464, class_1802.field_8368, class_1802.field_8789, class_1802.field_8112, class_1802.field_8602, class_1802.field_8256, class_1802.field_17507, class_1802.field_17505, class_1802.field_17508, class_1802.field_17506, class_1802.field_17503, class_1802.field_17504, class_1802.field_8072, class_1802.field_8767, class_1802.field_8808, class_1802.field_8334, class_1802.field_8415, class_1802.field_8624, class_1802.field_21984, class_1802.field_21983});
        items.addAll(SimilarItemsHelper.getItems((class_6862<class_1792>)class_3489.field_20344));
        items.addAll(SimilarItemsHelper.getItems((class_6862<class_1792>)class_3489.field_15556));
        IGNORED_ITEMS = items;
    }

    static final class Builder {
        private final StructureBlockData instance;

        private Builder(class_2382 blueprintSize) {
            this.instance = new StructureBlockData(blueprintSize);
        }

        Builder setLayer(BlueprintDataLayer layer, Map<class_2338, class_2680> layerData) {
            this.instance.layers.put(layer, Collections.unmodifiableMap(layerData));
            return this;
        }

        IStructureBlockData build() {
            Map layerBlockByItems = this.instance.layers.containsKey((Object)BlueprintDataLayer.GENERAL) ? this.instance.layers.get((Object)BlueprintDataLayer.GENERAL).values().stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(it -> it.method_26204().method_8389(), Collectors.counting()), Collections::unmodifiableMap)) : this.instance.layers.values().stream().flatMap(it -> it.values().stream()).collect(Collectors.collectingAndThen(Collectors.groupingBy(it -> it.method_26204().method_8389(), Collectors.counting()), Collections::unmodifiableMap));
            this.instance.stacks = layerBlockByItems.entrySet().stream().filter(it -> (Long)it.getValue() > 0L && !IGNORED_ITEMS.contains(it.getKey())).map(this::getItemInfo).toList();
            return this.instance;
        }

        @NotNull
        private IItemInfo getItemInfo(Map.Entry<class_1792, Long> it) {
            return new ItemInfo(it.getKey(), this.getItemAmount(it));
        }

        private int getItemAmount(Map.Entry<class_1792, Long> entry) {
            class_1799 defaultStack = entry.getKey().method_7854();
            int count = entry.getValue().intValue();
            boolean shouldBeDivided = defaultStack.method_31573(class_3489.field_16444) || defaultStack.method_31573(class_3489.field_15553);
            return shouldBeDivided ? count / 2 : count;
        }
    }
}

