/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_151;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IServerStructureBlockDataManager;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;
import net.remmintan.mods.minefortress.core.utils.ModPathUtils;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundAddBlueprintPacket;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundUpdateBlueprintPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minefortress.blueprints.data.AbstractStructureBlockDataManager;
import org.minefortress.blueprints.data.StructureBlockData;

public final class ServerStructureBlockDataManager
extends AbstractStructureBlockDataManager
implements IServerStructureBlockDataManager {
    private static final String BLUEPRINTS_FOLDER = "blueprints";
    private static final String REMOVED_BLUEPRINTS_FILENAME = "removed_blueprints.nbt";
    private final MinecraftServer server;
    private final Map<String, Blueprint> updatedStructures = new HashMap<String, Blueprint>();
    private final Set<String> removedDefaultStructures = new HashSet<String>();
    private final Function<String, Optional<BlueprintGroup>> filenameToGroupConverter;
    private final Supplier<UUID> userIdProvider;

    public ServerStructureBlockDataManager(MinecraftServer server, Function<String, Optional<BlueprintGroup>> filenameToGroupConverter, Supplier<UUID> userIdProvider) {
        this.server = server;
        this.filenameToGroupConverter = filenameToGroupConverter;
        this.userIdProvider = userIdProvider;
    }

    @Override
    public Optional<Integer> getFloorLevel(String filename) {
        return Optional.ofNullable(this.updatedStructures.get(filename)).map(Blueprint::floorLevel);
    }

    @Override
    public Optional<class_2487> getStructureNbt(String fileName) {
        return this.getStructure(fileName).map(it -> {
            class_2487 compound = new class_2487();
            it.method_15175(compound);
            return compound;
        });
    }

    @Override
    public boolean update(String fileName, class_2487 tag, int newFloorLevel, BlueprintGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Group can't be null");
        }
        boolean alreadyIn = this.updatedStructures.containsKey(fileName);
        this.updatedStructures.put(fileName, new Blueprint(fileName, newFloorLevel, tag, group));
        this.removedDefaultStructures.remove(fileName);
        this.invalidateBlueprint(fileName);
        boolean defaultStructure = this.filenameToGroupConverter.apply(fileName).isPresent();
        return alreadyIn || defaultStructure;
    }

    @Override
    public List<FortressS2CPacket> getInitPackets() {
        return this.updatedStructures.values().stream().map(it -> {
            Optional<BlueprintGroup> group = this.filenameToGroupConverter.apply(it.filename);
            if (group.isPresent()) {
                return ClientboundUpdateBlueprintPacket.edit(it.filename, it.floorLevel, it.tag);
            }
            return new ClientboundAddBlueprintPacket(it.group, it.filename, it.filename, it.floorLevel, "custom", it.tag);
        }).toList();
    }

    @Override
    public void remove(String fileName) {
        this.updatedStructures.remove(fileName);
        if (this.filenameToGroupConverter.apply(fileName).isPresent()) {
            this.removedDefaultStructures.add(fileName);
        }
    }

    @Override
    protected Optional<class_3499> getStructure(String blueprintFileName) {
        if (this.removedDefaultStructures.contains(blueprintFileName)) {
            return Optional.empty();
        }
        if (this.updatedStructures.containsKey(blueprintFileName)) {
            class_2487 structureTag = this.updatedStructures.get(blueprintFileName).tag();
            class_3499 structure = new class_3499();
            structure.method_15183((class_7871)class_7923.field_41175.method_46771(), structureTag);
            return Optional.of(structure);
        }
        return this.getDefaultStructure(blueprintFileName);
    }

    private Optional<class_3499> getDefaultStructure(String blueprintFileName) {
        class_2960 id;
        try {
            id = new class_2960("minefortress", blueprintFileName);
        }
        catch (class_151 exp) {
            return Optional.empty();
        }
        return this.server.method_27727().method_15094(id);
    }

    @Override
    protected IStructureBlockData buildStructure(class_3499 structure, class_2470 rotation, int floorLevel) {
        AbstractStructureBlockDataManager.SizeAndPivot sizeAndPivot = ServerStructureBlockDataManager.getSizeAndPivot(structure, rotation);
        class_2382 size = sizeAndPivot.size();
        class_2338 pivot = sizeAndPivot.pivot();
        Map<class_2338, class_2680> structureData = ServerStructureBlockDataManager.getStrcutureData(structure, rotation, pivot);
        Map<class_2338, class_2680> structureEntityData = structureData.entrySet().stream().filter(entry -> ((class_2680)entry.getValue()).method_26204() instanceof class_2343 || !((class_2680)entry.getValue()).method_26227().method_15769() || ((class_2680)entry.getValue()).method_26164(class_3481.field_15487)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<class_2338, class_2680> allBlocksWithoutEntities = structureData.entrySet().stream().filter(entry -> {
            class_2680 state = (class_2680)entry.getValue();
            return !(state.method_26204() instanceof class_2343) && state.method_26227().method_15769() && !state.method_26164(class_3481.field_15487);
        }).filter(entry -> {
            class_2338 pos = (class_2338)entry.getKey();
            class_2680 state = (class_2680)entry.getValue();
            return pos.method_10264() < floorLevel || !state.method_26215();
        }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<class_2338, class_2680> manualData = new HashMap<class_2338, class_2680>();
        HashMap<class_2338, class_2680> automaticData = new HashMap<class_2338, class_2680>();
        for (int x = 0; x < size.method_10263(); ++x) {
            for (int z = 0; z < size.method_10260(); ++z) {
                boolean isManual = true;
                for (int y = 0; y < size.method_10264(); ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    boolean contains = allBlocksWithoutEntities.containsKey(pos);
                    if (!contains && y >= floorLevel) {
                        isManual = false;
                        continue;
                    }
                    if (isManual) {
                        if (contains) {
                            manualData.put(pos, allBlocksWithoutEntities.get(pos));
                            continue;
                        }
                        if (!structureEntityData.containsKey(pos)) continue;
                        manualData.put(pos, class_2246.field_10124.method_9564());
                        continue;
                    }
                    automaticData.put(pos, allBlocksWithoutEntities.get(pos));
                }
            }
        }
        return StructureBlockData.withBlueprintSize(size).setLayer(BlueprintDataLayer.GENERAL, structureData).setLayer(BlueprintDataLayer.MANUAL, manualData).setLayer(BlueprintDataLayer.AUTOMATIC, automaticData).setLayer(BlueprintDataLayer.ENTITY, structureEntityData).build();
    }

    @Override
    public void writeBlockDataManager() {
        ModPathUtils.clearFolder(this.getBlueprintsFolder(), this.server.field_23784);
        ModPathUtils.createFolder(this.getBlueprintsFolder(), this.server.field_23784);
        this.saveRemovedBlueprints();
        if (this.updatedStructures.isEmpty()) {
            return;
        }
        HashMap<String, class_2487> tags = new HashMap<String, class_2487>();
        this.updatedStructures.forEach((k, v) -> {
            String tagFileName = this.getBlueprintsFolder() + "/" + k + ".nbt";
            class_2487 tag = v.toNbt();
            tags.put(tagFileName, tag);
        });
        ModPathUtils.writeAllTags(tags, this.server.field_23784);
    }

    @Override
    @NotNull
    public String getBlueprintsFolder() {
        return "blueprints/" + this.userIdProvider.get();
    }

    private void saveRemovedBlueprints() {
        class_2487 removedBlueprintsTag = new class_2487();
        String removedStructs = String.join((CharSequence)":", this.removedDefaultStructures);
        removedBlueprintsTag.method_10582("removedDefaultBlueprints", removedStructs);
        ModPathUtils.saveNbt(removedBlueprintsTag, this.getRemovedBlueprintsDefaultFileName(), this.server.field_23784);
    }

    @NotNull
    private String getRemovedBlueprintsDefaultFileName() {
        return this.getBlueprintsFolder() + "/removed_blueprints.nbt";
    }

    @Override
    public void readBlockDataManager(@Nullable class_2487 tag) {
        if (ModPathUtils.exists(this.getBlueprintsFolder(), this.server.field_23784)) {
            this.updatedStructures.clear();
            this.removedDefaultStructures.clear();
            ModPathUtils.readAllTags(this.getBlueprintsFolder(), this.server.field_23784, Collections.singletonList(REMOVED_BLUEPRINTS_FILENAME)).stream().map(Blueprint::fromNbt).forEach(it -> this.updatedStructures.put(it.filename, (Blueprint)it));
            this.readRemovedBlueprints();
        } else {
            if (tag == null) {
                throw new IllegalStateException("Blueprints folder does not exist and no default data is provided");
            }
            this.readLegacy(tag);
        }
    }

    private void readRemovedBlueprints() {
        class_2487 removedBlueprintsTag = ModPathUtils.readNbt(this.getRemovedBlueprintsDefaultFileName(), this.server.field_23784);
        if (removedBlueprintsTag.method_10545("removedDefaultBlueprints")) {
            String remBlueprints = removedBlueprintsTag.method_10558("removedDefaultBlueprints");
            this.removedDefaultStructures.addAll(Arrays.asList(remBlueprints.split(":")));
        }
    }

    private void readLegacy(class_2487 tag) {
        if (!tag.method_10545("updatedStructures")) {
            return;
        }
        this.updatedStructures.clear();
        HashMap<String, class_2487> structuresMap = new HashMap<String, class_2487>();
        class_2499 nbtElements = tag.method_10554("updatedStructures", 10);
        for (int i = 0; i < nbtElements.size(); ++i) {
            class_2487 mapEntry = nbtElements.method_10602(i);
            String fileName = mapEntry.method_10558("fileName");
            class_2487 structure = mapEntry.method_10562("structure");
            structuresMap.put(fileName, structure);
        }
        HashMap<String, Integer> floorLevelsMap = new HashMap<String, Integer>();
        if (tag.method_10545("floorLevel")) {
            class_2487 floorLevel = tag.method_10562("floorLevel");
            for (String key2 : floorLevel.method_10541()) {
                floorLevelsMap.put(key2, floorLevel.method_10550(key2));
            }
        }
        structuresMap.forEach((key, value) -> {
            Optional<BlueprintGroup> groupOpt = this.filenameToGroupConverter.apply((String)key);
            BlueprintGroup group = groupOpt.orElseThrow(() -> new IllegalStateException("Can't find group for blueprint " + key));
            Blueprint bp = new Blueprint((String)key, floorLevelsMap.getOrDefault(key, 0), (class_2487)value, group);
            this.updatedStructures.put((String)key, bp);
        });
    }

    private record Blueprint(String filename, int floorLevel, class_2487 tag, BlueprintGroup group) {
        class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("filename", this.filename);
            nbt.method_10566("tag", (class_2520)this.tag);
            nbt.method_10569("floorLevel", this.floorLevel);
            nbt.method_10582("group", this.group.toString());
            return nbt;
        }

        static Blueprint fromNbt(class_2487 nbt) {
            String filename = nbt.method_10558("filename");
            class_2487 tag = nbt.method_10562("tag");
            int floorLevel = nbt.method_10550("floorLevel");
            String groupStr = nbt.method_10558("group");
            BlueprintGroup group = BlueprintGroup.valueOf(groupStr);
            return new Blueprint(filename, floorLevel, tag, group);
        }
    }
}

