/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintsTagsKeeper;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import org.minefortress.blueprints.data.AbstractStructureBlockDataManager;
import org.minefortress.blueprints.data.StructureBlockData;

public final class ClientStructureBlockDataProvider
extends AbstractStructureBlockDataManager
implements BlueprintsTagsKeeper {
    private final Map<String, class_2487> blueprintTags = new HashMap<String, class_2487>();

    @Override
    protected Optional<class_3499> getStructure(String blueprintFileName) {
        if (!this.blueprintTags.containsKey(blueprintFileName)) {
            return Optional.empty();
        }
        class_2487 blueprintTag = this.blueprintTags.get(blueprintFileName);
        class_3499 structure = new class_3499();
        structure.method_15183((class_7871)class_7923.field_41175.method_46771(), blueprintTag);
        return Optional.of(structure);
    }

    @Override
    protected IStructureBlockData buildStructure(class_3499 structure, class_2470 rotation, int floorLevel) {
        return ClientStructureBlockDataProvider.buildStructureForClient(structure, rotation);
    }

    public static IStructureBlockData buildStructureForClient(class_3499 structure, class_2470 rotation) {
        AbstractStructureBlockDataManager.SizeAndPivot sizeAndPivot = ClientStructureBlockDataProvider.getSizeAndPivot(structure, rotation);
        class_2382 size = sizeAndPivot.size();
        class_2338 pivot = sizeAndPivot.pivot();
        Map<class_2338, class_2680> structureData = ClientStructureBlockDataProvider.getStrcutureData(structure, rotation, pivot);
        return StructureBlockData.withBlueprintSize(size).setLayer(BlueprintDataLayer.GENERAL, structureData).build();
    }

    @Override
    public void setBlueprint(String blueprintFileName, class_2487 tag) {
        this.blueprintTags.put(blueprintFileName, tag);
    }

    @Override
    public void removeBlueprint(String blueprintFileName) {
        this.blueprintTags.remove(blueprintFileName);
    }

    @Override
    public void reset() {
        super.reset();
        this.blueprintTags.clear();
    }
}

