/*
 * Decompiled with CFR 0.152.
 */
package org.minefortress.blueprints.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import org.jetbrains.annotations.NotNull;

abstract class AbstractStructureBlockDataManager
implements IBlockDataProvider {
    private final Map<String, IStructureBlockData> blueprints = new HashMap<String, IStructureBlockData>();

    AbstractStructureBlockDataManager() {
    }

    @Override
    public IStructureBlockData getBlockData(String blueprintId, class_2470 rotation) {
        return this.getBlockData(blueprintId, rotation, 0);
    }

    public IStructureBlockData getBlockData(String blueprintId, class_2470 rotation, int floorLevel) {
        String key = AbstractStructureBlockDataManager.getKey(blueprintId, rotation);
        if (!this.blueprints.containsKey(key)) {
            class_3499 structure = this.getStructure(blueprintId).orElseThrow(() -> new IllegalStateException("Blueprint not found " + blueprintId));
            IStructureBlockData blueprintBlockData = this.buildStructure(structure, rotation, floorLevel);
            this.blueprints.put(key, blueprintBlockData);
        }
        return this.blueprints.get(key);
    }

    public void invalidateBlueprint(String fileName) {
        new HashSet<String>(this.blueprints.keySet()).stream().filter(key -> key.startsWith(fileName)).forEach(this.blueprints::remove);
    }

    protected abstract Optional<class_3499> getStructure(String var1);

    protected abstract IStructureBlockData buildStructure(class_3499 var1, class_2470 var2, int var3);

    @NotNull
    protected static Map<class_2338, class_2680> getStrcutureData(class_3499 structure, class_2470 rotation, class_2338 pivot) {
        class_3492 placementData = new class_3492().method_15123(rotation);
        List blockInfos = placementData.method_15121(structure.field_15586, pivot).method_27125();
        placementData.method_15119(pivot);
        List<class_3499.class_3501> convertedStructureBlocks = blockInfos.stream().map(AbstractStructureBlockDataManager::convertJigsawBlock).toList();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (class_3499.class_3501 structureBlock : convertedStructureBlocks) {
            class_2338 transformedPos = class_3499.method_15171((class_3492)placementData, (class_2338)structureBlock.comp_1341);
            if (transformedPos.method_10263() < minX) {
                minX = transformedPos.method_10263();
            }
            if (transformedPos.method_10264() < minY) {
                minY = transformedPos.method_10264();
            }
            if (transformedPos.method_10260() >= minZ) continue;
            minZ = transformedPos.method_10260();
        }
        class_2338 minPos = new class_2338(minX, minY, minZ);
        return convertedStructureBlocks.stream().collect(Collectors.toMap(inf -> class_3499.method_15171((class_3492)placementData, (class_2338)inf.comp_1341).method_10059((class_2382)minPos), inf -> inf.comp_1342.method_26186(rotation)));
    }

    @NotNull
    private static String getKey(String id, class_2470 rotation) {
        return id + ":" + rotation.name();
    }

    protected static class_3499.class_3501 convertJigsawBlock(class_3499.class_3501 inf) {
        class_2520 final_state;
        if (inf.comp_1342.method_27852(class_2246.field_16540) && (final_state = inf.comp_1343.method_10580("final_state")) != null) {
            String stateString = final_state.method_10714();
            class_2680 blockState = null;
            try {
                blockState = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(stateString), (boolean)false).comp_622();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            if (blockState != null) {
                return new class_3499.class_3501(inf.comp_1341, blockState, inf.comp_1343);
            }
        }
        return inf;
    }

    @Override
    public void reset() {
        this.blueprints.clear();
    }

    protected static SizeAndPivot getSizeAndPivot(class_3499 structure, class_2470 rotation) {
        class_2382 size = structure.method_15166(rotation);
        class_2338 pivot = class_2338.field_10980.method_10069(size.method_10263() / 2, 0, size.method_10260() / 2);
        size = new class_2382(size.method_10263(), size.method_10264(), size.method_10260());
        return new SizeAndPivot(size, pivot);
    }

    protected record SizeAndPivot(class_2382 size, class_2338 pivot) {
    }
}

