/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.panama.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_284;
import net.minecraft.class_291;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_750;
import net.remmintan.mods.minefortress.core.FortressState;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlueprintMetadata;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureRenderInfoProvider;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import net.remmintan.panama.model.BuiltBlueprint;
import net.remmintan.panama.model.BuiltModel;
import net.remmintan.panama.model.builder.BlueprintsModelBuilder;
import net.remmintan.panama.renderer.AbstractCustomRenderer;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class BlueprintRenderer
extends AbstractCustomRenderer {
    private static final Vector3f WRONG_PLACEMENT_COLOR = new Vector3f(1.0f, 0.5f, 0.5f);
    private static final Vector3f CORRECT_PLACEMENT_COLOR = new Vector3f(1.0f, 1.0f, 1.0f);
    private final BlueprintsModelBuilder blueprintsModelBuilder;

    public BlueprintRenderer(Supplier<IBlockDataProvider> blockDataProviderSupplier, class_310 client, class_750 blockBufferBuilderStorage) {
        super(client);
        this.blueprintsModelBuilder = new BlueprintsModelBuilder(blockBufferBuilderStorage, blockDataProviderSupplier);
    }

    @Override
    public void prepareForRender() {
        IStructureRenderInfoProvider clientBlueprintManager = BlueprintRenderer.getStructureRenderInfoProvider();
        if (clientBlueprintManager.isSelecting()) {
            IBlueprintMetadata selectedStructure = clientBlueprintManager.getSelectedStructure();
            class_2470 blockRotation = selectedStructure.getRotation();
            String fileName = selectedStructure.getId();
            this.blueprintsModelBuilder.getOrBuildBlueprint(fileName, blockRotation);
        }
    }

    @Override
    public void close() {
        this.blueprintsModelBuilder.reset();
    }

    @Override
    protected boolean shouldRender() {
        return BlueprintRenderer.getStructureRenderInfoProvider().isSelecting();
    }

    @Override
    protected Vector3f getColorModulator() {
        return BlueprintRenderer.getStructureRenderInfoProvider().canBuild() ? CORRECT_PLACEMENT_COLOR : WRONG_PLACEMENT_COLOR;
    }

    @Override
    protected Optional<class_2338> getRenderTargetPosition() {
        return BlueprintRenderer.getStructureRenderInfoProvider().getStructureRenderPos();
    }

    public void renderBlueprintPreview(class_4587 matrices, String fileName, class_2470 blockRotation) {
        BuiltBlueprint builtBlueprint = this.getBuiltBlueprint(fileName, blockRotation);
        class_2382 size = builtBlueprint.getSize();
        int biggestSideSize = Math.max(Math.max(size.method_10263(), size.method_10264()), size.method_10260());
        float scale = 80.0f / (float)biggestSideSize;
        float scaleFactor = 2.0f / scale;
        float x = 130.0f * scaleFactor;
        float y = -60.0f * scaleFactor;
        float z = 45.0f * scaleFactor;
        this.renderBlueprintInGui(matrices, builtBlueprint, scale, x, y, z, true);
    }

    public void renderBlueprintInGui(class_4587 matrices, String fileName, class_2470 blockRotation, int slotColumn, int slotRow, boolean isEnoughResources) {
        BuiltBlueprint builtBlueprint = this.getBuiltBlueprint(fileName, blockRotation);
        class_2382 size = builtBlueprint.getSize();
        int biggestSideSize = Math.max(Math.max(size.method_10263(), size.method_10264()), size.method_10260());
        float scale = 11.2f / (float)biggestSideSize;
        float scaleFactor = 2.0f / scale;
        float x = 8.5f * scaleFactor + 11.25f * (float)slotColumn * scaleFactor / 1.25f;
        float y = -17.0f * scaleFactor - 11.25f * (float)slotRow * scaleFactor / 1.25f;
        float z = 22.0f * scaleFactor;
        this.renderBlueprintInGui(matrices, builtBlueprint, scale, x, y, z, isEnoughResources);
    }

    public BlueprintsModelBuilder getBlueprintsModelBuilder() {
        return this.blueprintsModelBuilder;
    }

    private void renderBlueprintInGui(class_4587 ignoredMatrices, BuiltBlueprint builtBlueprint, float scale, float x, float y, float z, boolean isEnoughResources) {
        this.client.method_16011().method_15396("blueprint_render_model");
        class_308.method_24211();
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        class_4587 matrices = RenderSystem.getModelViewStack();
        Vector3f cameraMove = new Vector3f(x, y, z);
        matrices.method_22903();
        this.rotateScene(matrices, cameraMove);
        matrices.method_22905(scale, -scale, scale);
        matrices.method_46416(cameraMove.x(), cameraMove.y(), cameraMove.z());
        this.renderLayer(class_1921.method_23577(), builtBlueprint, matrices, projectionMatrix, isEnoughResources);
        this.renderLayer(class_1921.method_23581(), builtBlueprint, matrices, projectionMatrix, isEnoughResources);
        this.renderLayer(class_1921.method_23579(), builtBlueprint, matrices, projectionMatrix, isEnoughResources);
        this.renderLayer(class_1921.method_23583(), builtBlueprint, matrices, projectionMatrix, isEnoughResources);
        matrices.method_22909();
        this.client.method_16011().method_15407();
    }

    @Override
    protected Optional<BuiltModel> getBuiltModel() {
        IBlueprintMetadata selectedStructure = BlueprintRenderer.getStructureRenderInfoProvider().getSelectedStructure();
        BuiltBlueprint nullableBlueprint = this.blueprintsModelBuilder.getOrBuildBlueprint(selectedStructure.getId(), selectedStructure.getRotation());
        return Optional.ofNullable(nullableBlueprint);
    }

    private BuiltBlueprint getBuiltBlueprint(String fileName, class_2470 blockRotation) {
        this.client.method_16011().method_15396("blueprint_build_model");
        BuiltBlueprint builtBlueprint = this.blueprintsModelBuilder.getOrBuildBlueprint(fileName, blockRotation);
        this.client.method_16011().method_15407();
        return builtBlueprint;
    }

    private void rotateScene(class_4587 matrices, Vector3f cameraMove) {
        float yaw = 135.0f;
        float pitch = -30.0f;
        float radiansYaw = (float)Math.toRadians(135.0);
        float radiansPitch = (float)Math.toRadians(-30.0);
        Quaternionf yawSceneRotation = new Quaternionf().set(new AxisAngle4f(radiansYaw, 0.0f, 1.0f, 0.0f));
        Quaternionf yawMoveRotation = new Quaternionf().set(new AxisAngle4f(radiansYaw, 0.0f, -1.0f, 0.0f));
        Vector3f pitchSceneRotationAxis = new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)yawMoveRotation);
        Vector3f pitchMoveRotationAxis = new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)yawMoveRotation);
        Quaternionf pitchSceneRotation = new Quaternionf().set(new AxisAngle4f(radiansPitch, (Vector3fc)pitchSceneRotationAxis));
        Quaternionf pitchMoveRotation = new Quaternionf().set(new AxisAngle4f(radiansPitch, (Vector3fc)pitchMoveRotationAxis));
        cameraMove.rotate((Quaternionfc)yawMoveRotation);
        cameraMove.rotate((Quaternionfc)pitchMoveRotation);
        matrices.method_22907(yawSceneRotation);
        matrices.method_22907(pitchSceneRotation);
    }

    private void renderLayer(class_1921 renderLayer, BuiltBlueprint builtBlueprint, class_4587 matrices, Matrix4f matrix4f, boolean isEnoughResources) {
        RenderSystem.assertOnRenderThread();
        renderLayer.method_23516();
        class_5944 shader = RenderSystem.getShader();
        if (shader == null) {
            throw new IllegalStateException("Shader is null while rendering blueprint");
        }
        for (int i = 0; i < 12; ++i) {
            int textureReference = RenderSystem.getShaderTexture((int)i);
            shader.method_34583("Sampler" + i, (Object)textureReference);
        }
        if (shader.field_29470 != null) {
            shader.field_29470.method_1250(matrices.method_23760().method_23761());
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(matrix4f);
        }
        if (shader.field_29474 != null) {
            shader.field_29474.method_34413(isEnoughResources ? CORRECT_PLACEMENT_COLOR : WRONG_PLACEMENT_COLOR);
        }
        if (shader.field_42231 != null) {
            shader.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        if (shader.field_29477 != null && shader.field_29478 != null && shader.field_29479 != null && shader.field_36373 != null) {
            shader.field_29477.method_1251(RenderSystem.getShaderFogStart());
            shader.field_29478.method_1251(RenderSystem.getShaderFogEnd());
            shader.field_29479.method_1253(RenderSystem.getShaderFogColor());
            shader.field_36373.method_35649(0);
        }
        if (shader.field_29472 != null) {
            shader.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shader.field_29481 != null) {
            shader.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        RenderSystem.setupShaderLights((class_5944)shader);
        shader.method_34586();
        class_284 chunkOffset = shader.field_29482;
        boolean hasLayer = builtBlueprint.hasLayer(renderLayer);
        if (hasLayer) {
            if (chunkOffset != null) {
                chunkOffset.method_34413(new Vector3f());
                chunkOffset.method_1300();
            }
            class_291 buffer = builtBlueprint.getBuffer(renderLayer);
            buffer.method_1353();
            buffer.method_35665();
        }
        if (chunkOffset != null) {
            chunkOffset.method_34413(new Vector3f());
        }
        shader.method_34585();
        class_291.method_1354();
        renderLayer.method_23518();
    }

    @NotNull
    private static IStructureRenderInfoProvider getStructureRenderInfoProvider() {
        IClientManagersProvider provider = CoreModUtils.getMineFortressManagersProvider();
        IClientFortressManager manager = provider.get_ClientFortressManager();
        FortressState state = manager.getState();
        if (state == FortressState.COMBAT) {
            return provider.get_InfluenceManager();
        }
        return provider.get_BlueprintManager();
    }
}

