/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.panama.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_284;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.panama.model.BuiltModel;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AbstractCustomRenderer {
    protected final class_310 client;

    protected AbstractCustomRenderer(class_310 client) {
        this.client = client;
    }

    public void render(class_4587 matrices, double cameraX, double cameraY, double cameraZ, Matrix4f projectionMatrix) {
        if (this.shouldRender()) {
            for (class_1921 layer : this.getRenderLayers()) {
                this.renderLayer(layer, matrices, cameraX, cameraY, cameraZ, projectionMatrix);
            }
        }
    }

    public void renderTranslucent(class_4587 matrices, double cameraX, double cameraY, double cameraZ, Matrix4f projectionMatrix) {
        if (this.shouldRender()) {
            this.renderLayer(class_1921.method_23583(), matrices, cameraX, cameraY, cameraZ, projectionMatrix);
        }
    }

    protected List<class_1921> getRenderLayers() {
        return Arrays.asList(class_1921.method_23577(), class_1921.method_23581(), class_1921.method_23579());
    }

    protected void renderLayer(class_1921 layer, class_4587 matrices, double cameraX, double cameraY, double cameraZ, Matrix4f projectionMatrix) {
        Optional<BuiltModel> builtModelOpt = this.getBuiltModel();
        if (!builtModelOpt.map(it -> it.hasLayer(layer)).orElse(false).booleanValue()) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        layer.method_23516();
        class_5944 shader = RenderSystem.getShader();
        if (shader == null) {
            throw new IllegalStateException("Shader is null");
        }
        for (int i = 0; i < 12; ++i) {
            int textureReference = RenderSystem.getShaderTexture((int)i);
            shader.method_34583("Sampler" + i, (Object)textureReference);
        }
        if (shader.field_29470 != null) {
            matrices.method_22903();
            Matrix4f modelViewMatrix = matrices.method_23760().method_23761();
            modelViewMatrix.translate((float)(-cameraX), (float)(-cameraY), (float)(-cameraZ));
            shader.field_29470.method_1250(modelViewMatrix);
            matrices.method_22909();
        }
        if (shader.field_29471 != null) {
            shader.field_29471.method_1250(projectionMatrix);
        }
        if (shader.field_29474 != null) {
            shader.field_29474.method_34413(this.getColorModulator());
        }
        if (shader.field_42231 != null) {
            shader.field_42231.method_1251(RenderSystem.getShaderGlintAlpha());
        }
        if (shader.field_29477 != null && shader.field_29478 != null && shader.field_29479 != null && shader.field_36373 != null) {
            shader.field_29477.method_1251(RenderSystem.getShaderFogStart());
            shader.field_29478.method_1251(RenderSystem.getShaderFogEnd());
            shader.field_29479.method_1253(RenderSystem.getShaderFogColor());
            shader.field_36373.method_35649(0);
        }
        if (shader.field_29472 != null) {
            shader.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shader.field_29481 != null) {
            shader.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        RenderSystem.setupShaderLights((class_5944)shader);
        shader.method_34586();
        class_284 offset = shader.field_29482;
        Optional<class_2338> renderTargetPositionOpt = this.getRenderTargetPosition();
        if (renderTargetPositionOpt.isPresent()) {
            class_2338 renderTargetPosition = renderTargetPositionOpt.get();
            BuiltModel builtModel = builtModelOpt.get();
            if (offset != null) {
                Vector3f targetOffset = new Vector3f((float)renderTargetPosition.method_10263(), (float)renderTargetPosition.method_10264(), (float)renderTargetPosition.method_10260());
                offset.method_34413(targetOffset);
                offset.method_1300();
            }
            class_291 buffer = builtModel.getBuffer(layer);
            buffer.method_1353();
            buffer.method_35665();
        }
        if (offset != null) {
            offset.method_34413(new Vector3f());
        }
        shader.method_34585();
        class_291.method_1354();
        layer.method_23518();
    }

    protected Optional<class_2338> getRenderTargetPosition() {
        if (this.shouldRender()) {
            return Optional.of(class_2338.field_10980);
        }
        return Optional.empty();
    }

    protected abstract Optional<BuiltModel> getBuiltModel();

    protected abstract boolean shouldRender();

    public abstract void prepareForRender();

    public abstract void close();

    protected Vector3f getColorModulator() {
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    protected IClientFortressManager getClientManager() {
        return ((IClientManagersProvider)this.client).get_ClientFortressManager();
    }
}

