/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.panama.model.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_750;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IBlockDataProvider;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.panama.model.BuiltBlueprint;
import org.jetbrains.annotations.NotNull;

public class BlueprintsModelBuilder {
    private final class_750 blockBufferBuilders;
    private final Supplier<IBlockDataProvider> blockDataManagerSupplier;
    private final Map<String, BuiltBlueprint> builtBlueprints = new HashMap<String, BuiltBlueprint>();
    private final HashSet<BuiltBlueprint> blueprintsToClose = new HashSet();

    public BlueprintsModelBuilder(class_750 blockBufferBuilders, Supplier<IBlockDataProvider> blockDataProviderSupplier) {
        this.blockBufferBuilders = blockBufferBuilders;
        this.blockDataManagerSupplier = blockDataProviderSupplier;
    }

    public BuiltBlueprint getOrBuildBlueprint(String fileName, class_2470 rotation) {
        this.buildBlueprint(fileName, rotation);
        return this.builtBlueprints.get(this.getKey(fileName, rotation));
    }

    private void buildBlueprint(String fileName, class_2470 rotation) {
        for (BuiltBlueprint blueprint : this.blueprintsToClose) {
            blueprint.close();
        }
        this.blueprintsToClose.clear();
        String key = this.getKey(fileName, rotation);
        if (!this.builtBlueprints.containsKey(key)) {
            IStructureBlockData blockData = this.blockDataManagerSupplier.get().getBlockData(fileName, rotation);
            BuiltBlueprint builtBlueprint = new BuiltBlueprint(blockData, (p, c) -> this.getWorld().method_23752(this.getBlockPos(), c));
            builtBlueprint.build(this.blockBufferBuilders);
            this.builtBlueprints.put(key, builtBlueprint);
        }
    }

    @NotNull
    private String getKey(String fileName, class_2470 rotation) {
        return fileName + rotation.name();
    }

    public void invalidateBlueprint(String fileName) {
        List<Map.Entry> toRemove = this.builtBlueprints.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(fileName)).toList();
        for (Map.Entry entry : toRemove) {
            String key = (String)entry.getKey();
            BuiltBlueprint blueprint = (BuiltBlueprint)entry.getValue();
            this.blueprintsToClose.add(blueprint);
            this.builtBlueprints.remove(key);
        }
    }

    public void reset() {
        this.blueprintsToClose.addAll(this.builtBlueprints.values());
        this.builtBlueprints.clear();
    }

    public class_638 getWorld() {
        return class_310.method_1551().field_1687;
    }

    public class_746 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    private class_2338 getBlockPos() {
        return this.getPlayer() != null ? this.getPlayer().method_24515() : this.getWorld().method_43126();
    }
}

