/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.panama.model;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_750;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.remmintan.gobi.renderer.selection.SelectionRenderInfo;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.panama.RenderHelper;
import net.remmintan.panama.model.BuiltModel;
import net.remmintan.panama.renderer.FortressRenderLayer;
import net.remmintan.panama.view.SelectionBlockRenderView;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;

public class BuiltSelection
implements BuiltModel {
    private static final class_238 BOX = class_238.method_29968((class_243)new class_243(0.0, 0.0, 0.0));
    private final SelectionBlockRenderView selectionBlockRenderView;
    private final Set<class_1921> initializedLayers = new HashSet<class_1921>();
    private final Set<class_1921> nonEmptyLayers = new HashSet<class_1921>();
    private final Map<class_1921, class_291> vertexBuffers = new HashMap<class_1921, class_291>();
    private final Map<class_1921, class_287.class_7433> builtBufferMap = new HashMap<class_1921, class_287.class_7433>();
    private CompletableFuture<Void> upload;
    private final SelectionRenderInfo selection;

    public BuiltSelection(SelectionRenderInfo selection) {
        this.selectionBlockRenderView = new SelectionBlockRenderView((p, c) -> this.getWorld().method_23752(this.getBlockPos(), c));
        this.selection = selection;
        for (class_1921 layer : class_1921.method_22720()) {
            this.vertexBuffers.put(layer, new class_291(class_291.class_8555.field_44793));
        }
        this.vertexBuffers.put(class_1921.method_23594(), new class_291(class_291.class_8555.field_44793));
        this.vertexBuffers.put((class_1921)FortressRenderLayer.getLinesNoDepth(), new class_291(class_291.class_8555.field_44793));
    }

    private class_2338 getBlockPos() {
        return Optional.ofNullable(this.getClient().field_1724).map(class_1297::method_24515).orElse(this.getWorld().method_43126());
    }

    public void build(Map<class_1921, class_287> lineBufferBuilderStorage, class_750 blockBufferBuilderStorage) {
        this.render(lineBufferBuilderStorage, blockBufferBuilderStorage);
        this.uploadBuffers();
    }

    private void render(Map<class_1921, class_287> lineBufferBuilderStorage, class_750 blockBufferBuilderStorage) {
        class_4587 matrices = new class_4587();
        class_1921 lines = class_1921.method_23594();
        class_287 linesBufferBuilder = lineBufferBuilderStorage.get(lines);
        this.init(lines, linesBufferBuilder);
        ClickType clickType = this.selection.clickType();
        Vector4f color = this.selection.color();
        List<class_2338> positions = this.selection.positions().stream().filter(this.getShouldRenderPosPredicate(clickType)).toList();
        class_2680 blockState = this.selection.blockState();
        this.selectionBlockRenderView.setBlockStateSupplier(blockPos -> positions.contains(blockPos) ? blockState : class_2246.field_10124.method_9564());
        for (class_2338 pos : positions) {
            matrices.method_22903();
            matrices.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            class_761.method_22982((class_4587)matrices, (class_4588)linesBufferBuilder, (class_238)BOX, (float)color.x(), (float)color.y(), (float)color.z(), (float)color.w());
            if (clickType == ClickType.BUILD || clickType == ClickType.ROADS) {
                this.renderFluid(blockBufferBuilderStorage, pos, blockState);
                this.renderBlock(blockBufferBuilderStorage, matrices, pos, blockState);
            }
            matrices.method_22909();
            this.nonEmptyLayers.add(class_1921.method_23594());
        }
        if (clickType == ClickType.REMOVE) {
            class_1921.class_4687 linesNoDepth = FortressRenderLayer.getLinesNoDepth();
            class_287 linesNoDepthBufferBuilder = lineBufferBuilderStorage.get(linesNoDepth);
            this.init((class_1921)linesNoDepth, linesNoDepthBufferBuilder);
            List<Pair<class_2382, class_2382>> selectionDimensions = this.selection.selectionDimensions();
            for (Pair<class_2382, class_2382> dimension : selectionDimensions) {
                class_2382 size = (class_2382)dimension.getFirst();
                class_2382 start = (class_2382)dimension.getSecond();
                class_238 sizeBox = new class_238(0.0, 0.0, 0.0, (double)size.method_10263(), (double)size.method_10264(), (double)size.method_10260());
                matrices.method_22903();
                matrices.method_46416((float)start.method_10263(), (float)start.method_10264(), (float)start.method_10260());
                class_761.method_22982((class_4587)matrices, (class_4588)linesNoDepthBufferBuilder, (class_238)sizeBox, (float)color.x(), (float)color.y(), (float)color.z(), (float)color.w());
                matrices.method_22909();
                this.nonEmptyLayers.add((class_1921)FortressRenderLayer.getLinesNoDepth());
            }
        }
        for (class_1921 layer : this.initializedLayers) {
            class_287.class_7433 builtBuffer = layer == class_1921.method_23594() || layer == FortressRenderLayer.getLinesNoDepth() ? lineBufferBuilderStorage.get(layer).method_1326() : blockBufferBuilderStorage.method_3154(layer).method_1326();
            this.builtBufferMap.put(layer, builtBuffer);
        }
    }

    @NotNull
    private Predicate<class_2338> getShouldRenderPosPredicate(ClickType clickType) {
        return pos -> clickType == ClickType.BUILD && BuildingHelper.canPlaceBlock((class_1937)this.getWorld(), pos) || (clickType == ClickType.REMOVE || clickType == ClickType.ROADS) && BuildingHelper.canRemoveBlock((class_1937)this.getWorld(), pos);
    }

    private void renderFluid(class_750 blockBufferBuilderStorage, class_2338 pos, class_2680 blockState) {
        class_3610 fluidState = blockState.method_26227();
        if (!fluidState.method_15769()) {
            class_1921 fluidRenderLayer = class_4696.method_23680((class_3610)fluidState);
            class_287 fluidBufferBuilder = blockBufferBuilderStorage.method_3154(fluidRenderLayer);
            this.init(fluidRenderLayer, fluidBufferBuilder);
            this.getBlockRenderManager().method_3352(pos, (class_1920)this.selectionBlockRenderView, (class_4588)fluidBufferBuilder, blockState, fluidState);
        }
    }

    private void renderBlock(class_750 blockBufferBuilderStorage, class_4587 matrices, class_2338 pos, class_2680 blockState) {
        if (blockState.method_26217() != class_2464.field_11455) {
            class_1921 blockLayer = class_4696.method_23679((class_2680)blockState);
            class_287 blockBufferBuilder = blockBufferBuilderStorage.method_3154(blockLayer);
            this.init(blockLayer, blockBufferBuilder);
            class_776 blockRenderer = this.getBlockRenderManager();
            blockRenderer.method_3355(blockState, pos, (class_1920)this.selectionBlockRenderView, matrices, (class_4588)blockBufferBuilder, true, this.getWorld().field_9229);
            this.nonEmptyLayers.add(blockLayer);
        }
    }

    private void init(class_1921 layer, class_287 bufferBuilder) {
        if (this.initializedLayers.add(layer)) {
            if (layer == class_1921.field_21695 || layer == FortressRenderLayer.LINES_NO_DEPTH) {
                bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
            } else {
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
            }
        }
    }

    private void uploadBuffers() {
        CompletableFuture[] uploads = (CompletableFuture[])this.initializedLayers.stream().map(layer -> {
            class_291 vertexBuffer = this.vertexBuffers.get(layer);
            class_287.class_7433 builtBuffer = this.builtBufferMap.get(layer);
            return RenderHelper.scheduleUpload(builtBuffer, vertexBuffer);
        }).toArray(CompletableFuture[]::new);
        this.upload = CompletableFuture.allOf(uploads);
    }

    @Override
    public boolean hasLayer(class_1921 layer) {
        if (this.upload.isCompletedExceptionally()) {
            throw new IllegalStateException("Render buffers uploads failed");
        }
        return this.upload.isDone() && this.nonEmptyLayers.contains(layer);
    }

    @Override
    public class_291 getBuffer(class_1921 layer) {
        return this.vertexBuffers.get(layer);
    }

    @Override
    public void close() {
        this.vertexBuffers.values().forEach(class_291::close);
    }

    private class_638 getWorld() {
        return this.getClient().field_1687;
    }

    private class_776 getBlockRenderManager() {
        return this.getClient().method_1541();
    }

    private class_310 getClient() {
        return class_310.method_1551();
    }
}

