/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.panama.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.remmintan.panama.RenderHelper;
import net.remmintan.panama.model.BuiltModel;
import net.remmintan.panama.view.CampfireRenderView;
import org.jetbrains.annotations.NotNull;

public class BuiltCampfire
implements BuiltModel {
    private final Set<class_1921> initializedLayers = new HashSet<class_1921>();
    private final Set<class_1921> nonEmptyLayers = new HashSet<class_1921>();
    private final CampfireRenderView blueprintData = new CampfireRenderView();
    private final Map<class_1921, class_287.class_7433> builtBuffers = new HashMap<class_1921, class_287.class_7433>();
    private final Map<class_1921, class_291> vertexBuffers = class_1921.method_22720().stream().collect(Collectors.toMap(Function.identity(), it -> new class_291(class_291.class_8555.field_44793)));
    private CompletableFuture<Void> uploadsFuture;

    public void build(class_750 blockBufferBuilders) {
        this.render(blockBufferBuilders);
        this.uploadBuffers();
    }

    @Override
    public boolean hasLayer(class_1921 layer) {
        if (this.uploadsFuture.isCompletedExceptionally()) {
            throw new IllegalStateException("Render buffers uploads failed");
        }
        return this.uploadsFuture.isDone() && this.nonEmptyLayers.contains(layer);
    }

    @Override
    public class_291 getBuffer(class_1921 layer) {
        return this.vertexBuffers.get(layer);
    }

    @Override
    public void close() {
        this.vertexBuffers.values().forEach(class_291::close);
    }

    private void render(class_750 blockBufferBuilders) {
        class_638 world = this.getClient().field_1687;
        if (world == null) {
            throw new IllegalStateException("World is null");
        }
        class_2338 pos = class_2338.field_10980;
        class_776 blockRenderManager = this.getClient().method_1541();
        class_778.method_20544();
        class_2680 blockState = this.blueprintData.method_8320(pos);
        class_1921 blockLayer = class_4696.method_23679((class_2680)blockState);
        class_287 bufferBuilder = blockBufferBuilders.method_3154(blockLayer);
        this.initLayer(blockLayer, bufferBuilder);
        blockRenderManager.method_3355(blockState, pos, (class_1920)this.blueprintData, new class_4587(), (class_4588)bufferBuilder, false, world.field_9229);
        this.nonEmptyLayers.add(blockLayer);
        this.builtBuffers.put(blockLayer, bufferBuilder.method_1326());
        class_778.method_20545();
    }

    private void uploadBuffers() {
        CompletableFuture[] uploadFutures = (CompletableFuture[])this.initializedLayers.stream().map(layer -> {
            class_287.class_7433 builtBuffer = this.builtBuffers.get(layer);
            class_291 vertexBuffer = this.vertexBuffers.get(layer);
            return RenderHelper.scheduleUpload(builtBuffer, vertexBuffer);
        }).toArray(CompletableFuture[]::new);
        this.uploadsFuture = CompletableFuture.allOf(uploadFutures);
    }

    private void initLayer(class_1921 renderLayer, class_287 bufferBuilder) {
        if (this.initializedLayers.add(renderLayer)) {
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        }
    }

    @NotNull
    private class_310 getClient() {
        return class_310.method_1551();
    }
}

