/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.panama.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.panama.RenderHelper;
import net.remmintan.panama.model.BuiltModel;
import net.remmintan.panama.view.BlueprintBlockRenderView;
import org.jetbrains.annotations.NotNull;

public class BuiltBlueprint
implements BuiltModel {
    private final Set<class_1921> initializedLayers = new HashSet<class_1921>();
    private final Set<class_1921> nonEmptyLayers = new HashSet<class_1921>();
    private final Map<class_1921, class_291> vertexBuffers = class_1921.method_22720().stream().collect(Collectors.toMap(Function.identity(), it -> new class_291(class_291.class_8555.field_44793)));
    private final Map<class_1921, class_287.class_7433> builtBuffers = new HashMap<class_1921, class_287.class_7433>();
    private CompletableFuture<Void> uploadsFuture;
    private final class_1920 blueprintData;
    private final class_2382 size;

    public BuiltBlueprint(IStructureBlockData blockData, BiFunction<class_2680, class_6539, Integer> colorProvider) {
        if (blockData == null) {
            throw new IllegalArgumentException("Block data cannot be null");
        }
        if (!blockData.hasLayer(BlueprintDataLayer.GENERAL)) {
            throw new IllegalArgumentException("Block data must have a general layer");
        }
        this.blueprintData = new BlueprintBlockRenderView(blockData.getLayer(BlueprintDataLayer.GENERAL), colorProvider);
        this.size = blockData.getSize();
    }

    public void build(class_750 blockBufferBuilders) {
        this.render(blockBufferBuilders);
        this.uploadBuffers();
    }

    public boolean buffersUploaded() {
        return this.uploadsFuture.isDone();
    }

    @Override
    public class_291 getBuffer(class_1921 layer) {
        return this.vertexBuffers.get(layer);
    }

    @Override
    public void close() {
        this.vertexBuffers.values().forEach(class_291::close);
    }

    @Override
    public boolean hasLayer(class_1921 layer) {
        return this.buffersUploaded() && this.nonEmptyLayers.contains(layer);
    }

    public class_2382 getSize() {
        return this.size;
    }

    private void uploadBuffers() {
        CompletableFuture[] uploadFutures = (CompletableFuture[])this.initializedLayers.stream().map(layer -> {
            class_287.class_7433 bufferBuilder = this.builtBuffers.get(layer);
            class_291 vertexBuffer = this.vertexBuffers.get(layer);
            return RenderHelper.scheduleUpload(bufferBuilder, vertexBuffer);
        }).toArray(CompletableFuture[]::new);
        this.uploadsFuture = CompletableFuture.allOf(uploadFutures);
    }

    private void render(class_750 blockBufferBuilders) {
        class_2338 minPos = class_2338.field_10980;
        class_2338 maxPos = minPos.method_10069(15, 15, 15);
        class_4587 matrixStack = new class_4587();
        class_778.method_20544();
        class_776 blockRenderManager = this.getClient().method_1541();
        for (class_2338 pos : class_2338.method_10097((class_2338)minPos, (class_2338)maxPos)) {
            class_287 bufferBuilder;
            class_2680 blockState = this.blueprintData.method_8320(pos);
            class_3610 fluidState = this.blueprintData.method_8316(pos);
            if (!fluidState.method_15769()) {
                class_1921 fluidRenderLayer = class_4696.method_23680((class_3610)fluidState);
                bufferBuilder = blockBufferBuilders.method_3154(fluidRenderLayer);
                this.initLayer(fluidRenderLayer, bufferBuilder);
                blockRenderManager.method_3352(pos, this.blueprintData, (class_4588)bufferBuilder, blockState, fluidState);
            }
            if (blockState.method_26217() == class_2464.field_11455) continue;
            class_1921 blockLayer = class_4696.method_23679((class_2680)blockState);
            bufferBuilder = blockBufferBuilders.method_3154(blockLayer);
            this.initLayer(blockLayer, bufferBuilder);
            matrixStack.method_22903();
            matrixStack.method_46416((float)(pos.method_10263() & 0xF), (float)(pos.method_10264() & 0xF), (float)(pos.method_10260() & 0xF));
            class_638 clientWorld = this.getClient().field_1687;
            if (clientWorld != null) {
                blockRenderManager.method_3355(blockState, pos, this.blueprintData, matrixStack, (class_4588)bufferBuilder, true, clientWorld.field_9229);
            }
            this.nonEmptyLayers.add(blockLayer);
            matrixStack.method_22909();
        }
        for (class_1921 layer : this.initializedLayers) {
            this.builtBuffers.put(layer, blockBufferBuilders.method_3154(layer).method_1326());
        }
        class_778.method_20545();
    }

    private void initLayer(class_1921 renderLayer, class_287 bufferBuilder) {
        if (this.initializedLayers.add(renderLayer)) {
            this.beginBufferBuilding(bufferBuilder);
        }
    }

    @NotNull
    private class_310 getClient() {
        return class_310.method_1551();
    }

    private void beginBufferBuilding(class_287 buffer) {
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
    }
}

