/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.s2c;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.remmintan.mods.minefortress.core.interfaces.automation.IAutomationAreaInfo;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;
import net.remmintan.mods.minefortress.core.interfaces.networking.INetworkingReader;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IAreasClientManager;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import net.remmintan.mods.minefortress.networking.registries.NetworkingReadersRegistry;

public class S2CSyncAreasPacket
implements FortressS2CPacket {
    public static final String CHANNEL = "sync_areas";
    private final List<IAutomationAreaInfo> automationAreaInfos;

    public S2CSyncAreasPacket(List<IAutomationAreaInfo> automationAreaInfos) {
        this.automationAreaInfos = Collections.unmodifiableList(automationAreaInfos);
    }

    public S2CSyncAreasPacket(class_2540 buf) {
        this.automationAreaInfos = new ArrayList<IAutomationAreaInfo>();
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            INetworkingReader<IAutomationAreaInfo> reader = NetworkingReadersRegistry.findReader(IAutomationAreaInfo.class);
            this.automationAreaInfos.add(reader.readBuffer(buf));
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(this.automationAreaInfos.size());
        for (IAutomationAreaInfo info : this.automationAreaInfos) {
            info.writeToBuffer(buf);
        }
    }

    @Override
    public void handle(class_310 client) {
        client.execute(() -> {
            IAreasClientManager areasManager = S2CSyncAreasPacket.getAutomationAreaManager();
            areasManager.getSavedAreasHolder().setSavedAreas(this.automationAreaInfos);
        });
    }

    private static IAreasClientManager getAutomationAreaManager() {
        IClientManagersProvider provider = CoreModUtils.getMineFortressManagersProvider();
        return provider.get_AreasClientManager();
    }
}

