/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.s2c;

import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IClientBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;

public class ClientboundUpdateBlueprintPacket
implements FortressS2CPacket {
    private final String file;
    private final int newFloorLevel;
    private final class_2487 tag;
    private final Type type;

    private ClientboundUpdateBlueprintPacket(String file, int newFloorLevel, class_2487 tag, Type type) {
        this.file = file;
        this.newFloorLevel = newFloorLevel;
        this.tag = tag;
        this.type = type;
    }

    public ClientboundUpdateBlueprintPacket(class_2540 buf) {
        this.file = buf.method_19772();
        this.newFloorLevel = buf.readInt();
        this.tag = buf.method_10798();
        this.type = (Type)buf.method_10818(Type.class);
    }

    @Override
    public void handle(class_310 client) {
        IClientManagersProvider provider = this.getManagersProvider();
        IClientBlueprintManager blueprintManager = provider.get_BlueprintManager();
        if (this.type == Type.UPDATE) {
            blueprintManager.update(this.file, this.tag, this.newFloorLevel);
        } else if (this.type == Type.REMOVE) {
            blueprintManager.clearStructure();
            blueprintManager.remove(this.file);
            blueprintManager.updateSlotsInBlueprintsScreen();
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10814(this.file);
        buf.writeInt(this.newFloorLevel);
        buf.method_10794(this.tag);
        buf.method_10817((Enum)this.type);
    }

    public static ClientboundUpdateBlueprintPacket edit(String file, int newFloorLevel, class_2487 tag) {
        return new ClientboundUpdateBlueprintPacket(file, newFloorLevel, tag, Type.UPDATE);
    }

    public static ClientboundUpdateBlueprintPacket remove(String file) {
        return new ClientboundUpdateBlueprintPacket(file, 0, new class_2487(), Type.REMOVE);
    }

    private static enum Type {
        UPDATE,
        REMOVE;

    }
}

