/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.s2c;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;
import net.remmintan.mods.minefortress.core.interfaces.networking.INetworkingReader;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.networking.registries.NetworkingReadersRegistry;
import org.apache.logging.log4j.LogManager;

public class ClientboundSyncItemsPacket
implements FortressS2CPacket {
    private final List<IItemInfo> itemInfo;
    private final boolean needReset;

    public ClientboundSyncItemsPacket(List<IItemInfo> itemInfo, boolean needReset) {
        this.itemInfo = Collections.unmodifiableList(itemInfo);
        this.needReset = needReset;
    }

    public ClientboundSyncItemsPacket(class_2540 buf) {
        int size = buf.readInt();
        ArrayList<IItemInfo> tempList = new ArrayList<IItemInfo>();
        INetworkingReader<IItemInfo> reader = NetworkingReadersRegistry.findReader(IItemInfo.class);
        for (int i = 0; i < size; ++i) {
            tempList.add(reader.readBuffer(buf));
        }
        this.itemInfo = Collections.unmodifiableList(tempList);
        this.needReset = buf.readBoolean();
    }

    @Override
    public void handle(class_310 client) {
        IClientManagersProvider provider = this.getManagersProvider();
        IClientResourceManager resourceManager = provider.get_ClientFortressManager().getResourceManager();
        if (this.needReset) {
            resourceManager.reset();
        }
        for (IItemInfo info : this.itemInfo) {
            class_1792 item = info.item();
            if (item == class_1802.field_8615) continue;
            try {
                resourceManager.setItemAmount(item, info.amount());
            }
            catch (IllegalArgumentException e) {
                LogManager.getLogger().warn("Failed to set item amount for item: " + item.method_7848().getString());
                LogManager.getLogger().warn("error: " + e.getMessage());
            }
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.itemInfo.size());
        for (IItemInfo itemInfo : this.itemInfo) {
            class_1792 item = itemInfo.item();
            int amount = itemInfo.amount();
            buf.writeInt(class_1792.method_7880((class_1792)item));
            buf.writeInt(amount);
        }
        buf.writeBoolean(this.needReset);
    }
}

