/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.s2c;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.remmintan.mods.minefortress.core.interfaces.buildings.IEssentialBuildingInfo;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;
import net.remmintan.mods.minefortress.core.interfaces.networking.INetworkingReader;
import net.remmintan.mods.minefortress.networking.registries.NetworkingReadersRegistry;

public class ClientboundSyncBuildingsPacket
implements FortressS2CPacket {
    private final List<IEssentialBuildingInfo> houses;

    public ClientboundSyncBuildingsPacket(List<IEssentialBuildingInfo> houses) {
        this.houses = houses;
    }

    public ClientboundSyncBuildingsPacket(class_2540 buf) {
        int housesSize = buf.readInt();
        ArrayList<IEssentialBuildingInfo> houses = new ArrayList<IEssentialBuildingInfo>();
        INetworkingReader<IEssentialBuildingInfo> reader = NetworkingReadersRegistry.findReader(IEssentialBuildingInfo.class);
        for (int i = 0; i < housesSize; ++i) {
            houses.add(reader.readBuffer(buf));
        }
        this.houses = Collections.unmodifiableList(houses);
    }

    @Override
    public void handle(class_310 client) {
        IClientFortressManager fortressManager = this.getManagersProvider().get_ClientFortressManager();
        fortressManager.updateBuildings(this.houses);
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.houses.size());
        for (IEssentialBuildingInfo house : this.houses) {
            house.write(buf);
        }
    }
}

