/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.s2c;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.remmintan.mods.minefortress.core.dtos.professions.IProfessionEssentialInfo;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressS2CPacket;
import net.remmintan.mods.minefortress.core.interfaces.networking.INetworkingReader;
import net.remmintan.mods.minefortress.core.interfaces.professions.IClientProfessionManager;
import net.remmintan.mods.minefortress.networking.registries.NetworkingReadersRegistry;

public class ClientboundProfessionSyncPacket
implements FortressS2CPacket {
    private final List<IProfessionEssentialInfo> professions;

    public ClientboundProfessionSyncPacket(List<IProfessionEssentialInfo> essentialInfos) {
        this.professions = Collections.unmodifiableList(essentialInfos);
    }

    public ClientboundProfessionSyncPacket(class_2540 buf) {
        this.professions = new ArrayList<IProfessionEssentialInfo>();
        int size = buf.readInt();
        INetworkingReader<IProfessionEssentialInfo> reader = NetworkingReadersRegistry.findReader(IProfessionEssentialInfo.class);
        for (int i = 0; i < size; ++i) {
            IProfessionEssentialInfo info = reader.readBuffer(buf);
            this.professions.add(info);
        }
    }

    @Override
    public void handle(class_310 client) {
        IClientFortressManager fortressManager = this.getManagersProvider().get_ClientFortressManager();
        IClientProfessionManager professionManager1 = fortressManager.getProfessionManager();
        professionManager1.updateProfessions(this.professions);
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(this.professions.size());
        for (IProfessionEssentialInfo professionEssentialInfo : this.professions) {
            buf.method_10814(professionEssentialInfo.id());
            buf.writeInt(professionEssentialInfo.amount());
        }
    }
}

